/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.compatability.jei;

import com.google.common.collect.ImmutableSet;
import electrodynamics.compatability.jei.recipecategories.psuedorecipes.PsuedoO2ORecipe;
import electrodynamics.compatability.jei.recipecategories.psuedorecipes.PsuedoRecipes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import nuclearscience.client.screen.ScreenChemicalExtractor;
import nuclearscience.client.screen.ScreenGasCentrifuge;
import nuclearscience.client.screen.ScreenMSRFuelPreProcessor;
import nuclearscience.client.screen.ScreenNuclearBoiler;
import nuclearscience.client.screen.ScreenParticleInjector;
import nuclearscience.client.screen.ScreenReactorCore;
import nuclearscience.common.recipe.NuclearScienceRecipeInit;
import nuclearscience.compatability.jei.recipecategories.psuedorecipes.NuclearSciencePsuedoRecipes;
import nuclearscience.compatability.jei.recipecategories.psuedorecipes.PsuedoGasCentrifugeRecipe;
import nuclearscience.compatability.jei.recipecategories.specificmachines.nuclearscience.ChemicalExtractorRecipeCategory;
import nuclearscience.compatability.jei.recipecategories.specificmachines.nuclearscience.FissionReactorRecipeCategory;
import nuclearscience.compatability.jei.recipecategories.specificmachines.nuclearscience.FuelReprocessorRecipeCategory;
import nuclearscience.compatability.jei.recipecategories.specificmachines.nuclearscience.GasCentrifugeRecipeCategory;
import nuclearscience.compatability.jei.recipecategories.specificmachines.nuclearscience.MSRProcessorRecipeCategory;
import nuclearscience.compatability.jei.recipecategories.specificmachines.nuclearscience.NuclearBoilerRecipeCategory;
import nuclearscience.compatability.jei.recipecategories.specificmachines.nuclearscience.ParticleAcceleratorAntiMatterRecipeCategory;
import nuclearscience.compatability.jei.recipecategories.specificmachines.nuclearscience.ParticleAcceleratorDarkMatterRecipeCategory;
import nuclearscience.compatability.jei.recipecategories.specificmachines.nuclearscience.RadioactiveProcessorRecipeCategory;

@JeiPlugin
public class NuclearSciencePlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("nuclearscience", "nucsci_jei_plugin");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)GasCentrifugeRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{GasCentrifugeRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)NuclearBoilerRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{NuclearBoilerRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)ChemicalExtractorRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{ChemicalExtractorRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)FissionReactorRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{FissionReactorRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)ParticleAcceleratorAntiMatterRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{ParticleAcceleratorAntiMatterRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)ParticleAcceleratorDarkMatterRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{ParticleAcceleratorDarkMatterRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)FuelReprocessorRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{FuelReprocessorRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)RadioactiveProcessorRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{RadioactiveProcessorRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)MSRProcessorRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{MSRProcessorRecipeCategory.UID});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        NuclearSciencePsuedoRecipes.addNuclearScienceRecipes();
        PsuedoRecipes.addElectrodynamicsRecipes();
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = Objects.requireNonNull(mc.field_71441_e);
        RecipeManager recipeManager = world.func_199532_z();
        HashSet<PsuedoGasCentrifugeRecipe> gasCentrifugeRecipes = new HashSet<PsuedoGasCentrifugeRecipe>(NuclearSciencePsuedoRecipes.GAS_CENTRIFUGE_RECIPES);
        registration.addRecipes(gasCentrifugeRecipes, GasCentrifugeRecipeCategory.UID);
        ImmutableSet nuclearBoilerRecipes = ImmutableSet.copyOf((Collection)recipeManager.func_241447_a_(NuclearScienceRecipeInit.NUCLEAR_BOILER_TYPE));
        registration.addRecipes((Collection)nuclearBoilerRecipes, NuclearBoilerRecipeCategory.UID);
        ImmutableSet chemicalExtractorRecipes = ImmutableSet.copyOf((Collection)recipeManager.func_241447_a_(NuclearScienceRecipeInit.CHEMICAL_EXTRACTOR_TYPE));
        registration.addRecipes((Collection)chemicalExtractorRecipes, ChemicalExtractorRecipeCategory.UID);
        ImmutableSet fissionReactorRecipes = ImmutableSet.copyOf((Collection)recipeManager.func_241447_a_(NuclearScienceRecipeInit.FISSION_REACTOR_TYPE));
        registration.addRecipes((Collection)fissionReactorRecipes, FissionReactorRecipeCategory.UID);
        HashSet<PsuedoO2ORecipe> antiMatterRecipes = new HashSet<PsuedoO2ORecipe>(NuclearSciencePsuedoRecipes.ANTI_MATTER_RECIPES);
        registration.addRecipes(antiMatterRecipes, ParticleAcceleratorAntiMatterRecipeCategory.UID);
        HashSet<PsuedoO2ORecipe> darkMatterRecipes = new HashSet<PsuedoO2ORecipe>(NuclearSciencePsuedoRecipes.DARK_MATTER_RECIPES);
        registration.addRecipes(darkMatterRecipes, ParticleAcceleratorDarkMatterRecipeCategory.UID);
        ImmutableSet fuelReprocessorRecipes = ImmutableSet.copyOf((Collection)recipeManager.func_241447_a_(NuclearScienceRecipeInit.FUEL_REPROCESSOR_TYPE));
        registration.addRecipes((Collection)fuelReprocessorRecipes, FuelReprocessorRecipeCategory.UID);
        ImmutableSet radioactiveProcessorRecipes = ImmutableSet.copyOf((Collection)recipeManager.func_241447_a_(NuclearScienceRecipeInit.RADIOACTIVE_PROCESSOR_TYPE));
        registration.addRecipes((Collection)radioactiveProcessorRecipes, RadioactiveProcessorRecipeCategory.UID);
        ImmutableSet msrProcessorRecipes = ImmutableSet.copyOf((Collection)recipeManager.func_241447_a_(NuclearScienceRecipeInit.MSR_FUEL_PREPROCESSOR_TYPE));
        registration.addRecipes((Collection)msrProcessorRecipes, MSRProcessorRecipeCategory.UID);
        NuclearSciencePlugin.nuclearScienceInfoTabs(registration);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new GasCentrifugeRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new NuclearBoilerRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ChemicalExtractorRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FissionReactorRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ParticleAcceleratorAntiMatterRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ParticleAcceleratorDarkMatterRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FuelReprocessorRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new RadioactiveProcessorRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new MSRProcessorRecipeCategory(helper)});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        int[] arrowLocation = new int[]{97, 31, 22, 15};
        registry.addRecipeClickArea(ScreenNuclearBoiler.class, arrowLocation[0], arrowLocation[1], arrowLocation[2], arrowLocation[3], new ResourceLocation[]{NuclearBoilerRecipeCategory.UID});
        registry.addRecipeClickArea(ScreenChemicalExtractor.class, arrowLocation[0], arrowLocation[1], arrowLocation[2], arrowLocation[3], new ResourceLocation[]{ChemicalExtractorRecipeCategory.UID});
        registry.addRecipeClickArea(ScreenGasCentrifuge.class, 91, 22, 32, 41, new ResourceLocation[]{GasCentrifugeRecipeCategory.UID});
        registry.addRecipeClickArea(ScreenReactorCore.class, 117, 43, 14, 13, new ResourceLocation[]{FissionReactorRecipeCategory.UID});
        registry.addRecipeClickArea(ScreenParticleInjector.class, 102, 33, 28, 14, new ResourceLocation[]{ParticleAcceleratorAntiMatterRecipeCategory.UID, ParticleAcceleratorDarkMatterRecipeCategory.UID});
        registry.addRecipeClickArea(ScreenMSRFuelPreProcessor.class, 98, 40, 16, 16, new ResourceLocation[]{MSRProcessorRecipeCategory.UID});
    }

    private static void nuclearScienceInfoTabs(IRecipeRegistration registration) {
        ArrayList<ItemStack> nsMachines = NuclearSciencePsuedoRecipes.NUCLEAR_SCIENCE_MACHINES;
        for (ItemStack itemStack : nsMachines) {
            String temp = itemStack.func_77973_b().toString();
            registration.addIngredientInfo((Object)itemStack, VanillaTypes.ITEM, new String[]{"info.jei.block." + temp});
        }
    }
}

