/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.compatability.jei.recipecategories.specificmachines.nuclearscience;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.matrix.MatrixStack;
import electrodynamics.compatability.jei.recipecategories.ElectrodynamicsRecipeCategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import nuclearscience.DeferredRegisters;
import nuclearscience.compatability.jei.recipecategories.psuedorecipes.PsuedoGasCentrifugeRecipe;

public class GasCentrifugeRecipeCategory
extends ElectrodynamicsRecipeCategory<PsuedoGasCentrifugeRecipe> {
    public static final int INPUT_FLUID_STACK_SLOT = 0;
    public static final int OUTPUT_1_ITEM_SLOT = 1;
    public static final int OUTPUT_2_ITEM_SLOT = 2;
    private static int[] GUI_BACKGROUND = new int[]{0, 0, 132, 61};
    private static int SMELT_TIME = 100;
    private static int TEXT_Y_HEIGHT = 70;
    private static String MOD_ID = "nuclearscience";
    private static String RECIPE_GROUP = "gas_centrifuge";
    private static String GUI_TEXTURE = "textures/gui/jei/gas_centrifuge_gui.png";
    public static ItemStack INPUT_MACHINE = new ItemStack((IItemProvider)DeferredRegisters.blockGasCentrifuge);
    private LoadingCache<Integer, ArrayList<IDrawableAnimated>> arrowCache;
    private LoadingCache<Integer, ArrayList<IDrawableStatic>> fluidBarCache;
    public static ResourceLocation UID = new ResourceLocation(MOD_ID, RECIPE_GROUP);

    public GasCentrifugeRecipeCategory(final IGuiHelper guiHelper) {
        super(guiHelper, MOD_ID, RECIPE_GROUP, GUI_TEXTURE, INPUT_MACHINE, GUI_BACKGROUND, PsuedoGasCentrifugeRecipe.class, SMELT_TIME, TEXT_Y_HEIGHT);
        this.arrowCache = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, ArrayList<IDrawableAnimated>>(){

            public ArrayList<IDrawableAnimated> load(Integer cookTime) {
                IDrawableAnimated distillArrow = guiHelper.drawableBuilder(GasCentrifugeRecipeCategory.this.getGuiTexture(), 0, 70, 27, 47).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
                IDrawableAnimated condArrow = guiHelper.drawableBuilder(GasCentrifugeRecipeCategory.this.getGuiTexture(), 27, 70, 46, 55).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
                IDrawableAnimated uF6FluidBar = guiHelper.drawableBuilder(GasCentrifugeRecipeCategory.this.getGuiTexture(), 180, 0, 16, 50).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.TOP, false);
                IDrawableAnimated u235FluidBar = guiHelper.drawableBuilder(GasCentrifugeRecipeCategory.this.getGuiTexture(), 148, 0, 16, 22).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.BOTTOM, false);
                IDrawableAnimated u238FluidBar = guiHelper.drawableBuilder(GasCentrifugeRecipeCategory.this.getGuiTexture(), 164, 0, 16, 22).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.BOTTOM, false);
                IDrawableAnimated[] arrows = new IDrawableAnimated[]{distillArrow, condArrow, uF6FluidBar, u235FluidBar, u238FluidBar};
                return new ArrayList<IDrawableAnimated>(Arrays.asList(arrows));
            }
        });
        this.fluidBarCache = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, ArrayList<IDrawableStatic>>(){

            public ArrayList<IDrawableStatic> load(Integer fluidHeight) {
                IDrawableStatic fluidBar = guiHelper.drawableBuilder(GasCentrifugeRecipeCategory.this.getGuiTexture(), 132, 0, 16, 50).build();
                IDrawableStatic[] fluidBars = new IDrawableStatic[]{fluidBar};
                return new ArrayList<IDrawableStatic>(Arrays.asList(fluidBars));
            }
        });
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public void setIngredients(PsuedoGasCentrifugeRecipe recipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.FLUID, this.getFluids(recipe));
        ingredients.setOutputs(VanillaTypes.ITEM, this.getOutputs(recipe));
    }

    public void setRecipe(IRecipeLayout recipeLayout, PsuedoGasCentrifugeRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(1, false, 107, 11);
        guiItemStacks.init(2, false, 107, 32);
        guiFluidStacks.init(0, true, 3, 5, 16, 50, 5000, false, null);
        guiItemStacks.set(ingredients);
        guiFluidStacks.set(ingredients);
    }

    public void draw(PsuedoGasCentrifugeRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        ArrayList<IDrawableStatic> fluidBars = this.getFluidBars();
        fluidBars.get(0).draw(matrixStack, 3, 5);
        ArrayList<IDrawableAnimated> arrows = this.getArrows();
        arrows.get(0).draw(matrixStack, 22, 7);
        arrows.get(1).draw(matrixStack, 70, 3);
        arrows.get(2).draw(matrixStack, 3, 5);
        arrows.get(3).draw(matrixStack, 51, 4);
        arrows.get(4).draw(matrixStack, 51, 35);
        this.drawSmeltTime(matrixStack, this.getYHeight());
    }

    protected ArrayList<IDrawableAnimated> getArrows() {
        return (ArrayList)this.arrowCache.getUnchecked((Object)this.getArrowSmeltTime());
    }

    protected ArrayList<IDrawableStatic> getFluidBars() {
        return (ArrayList)this.fluidBarCache.getUnchecked((Object)this.getArrowSmeltTime());
    }

    protected void drawSmeltTime(MatrixStack matrixStack, int y) {
        int smeltTimeSeconds = this.getArrowSmeltTime() / 20;
        TranslationTextComponent indivU235String = new TranslationTextComponent("gui.jei.category." + this.getRecipeGroup() + ".info.indiv_u235", new Object[]{smeltTimeSeconds});
        TranslationTextComponent indivU238String = new TranslationTextComponent("gui.jei.category." + this.getRecipeGroup() + ".info.indiv_u238", new Object[]{smeltTimeSeconds});
        TranslationTextComponent percentU235String = new TranslationTextComponent("gui.jei.category." + this.getRecipeGroup() + ".info.percent_u235", new Object[]{smeltTimeSeconds});
        TranslationTextComponent percentU238String = new TranslationTextComponent("gui.jei.category." + this.getRecipeGroup() + ".info.percent_u238", new Object[]{smeltTimeSeconds});
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontRenderer = minecraft.field_71466_p;
        int indivU235StringWidth = fontRenderer.func_238414_a_((ITextProperties)indivU235String);
        int indivU238StringWidth = fontRenderer.func_238414_a_((ITextProperties)indivU238String);
        int percentU238StringWidth = fontRenderer.func_238414_a_((ITextProperties)percentU238String);
        int percentU235StringWidth = fontRenderer.func_238414_a_((ITextProperties)percentU235String);
        fontRenderer.func_243248_b(matrixStack, (ITextComponent)indivU238String, (float)(this.getBackground().getWidth() - indivU238StringWidth - 27), (float)(y - 27 - 30), -10395295);
        fontRenderer.func_243248_b(matrixStack, (ITextComponent)percentU238String, (float)(this.getBackground().getWidth() - percentU238StringWidth - 27), (float)(y - 37 - 30), -10395295);
        fontRenderer.func_243248_b(matrixStack, (ITextComponent)indivU235String, (float)(this.getBackground().getWidth() - indivU235StringWidth - 27), (float)(y - 59 - 30), -10395295);
        fontRenderer.func_243248_b(matrixStack, (ITextComponent)percentU235String, (float)(this.getBackground().getWidth() - percentU235StringWidth - 27), (float)(y - 49 - 30), -10395295);
    }

    public NonNullList<FluidStack> getFluids(PsuedoGasCentrifugeRecipe recipe) {
        NonNullList fluids = NonNullList.func_191196_a();
        fluids.add((Object)recipe.INPUT_FLUID_STACK);
        return fluids;
    }

    public List<ItemStack> getOutputs(PsuedoGasCentrifugeRecipe recipe) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        outputs.add(recipe.OUTPUT_1_ITEM);
        outputs.add(recipe.OUTPUT_2_ITEM);
        return outputs;
    }
}

