/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.compatability.jei.recipecategories.specificmachines.nuclearscience;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.matrix.MatrixStack;
import electrodynamics.api.capability.CapabilityUtils;
import electrodynamics.common.recipe.categories.fluid3items2item.Fluid3Items2ItemRecipe;
import electrodynamics.common.recipe.recipeutils.CountableIngredient;
import electrodynamics.common.recipe.recipeutils.FluidIngredient;
import electrodynamics.compatability.jei.recipecategories.ElectrodynamicsRecipeCategory;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import nuclearscience.DeferredRegisters;

public class MSRProcessorRecipeCategory
extends ElectrodynamicsRecipeCategory<Fluid3Items2ItemRecipe> {
    public static final int ITEM_INPUT_1 = 0;
    public static final int ITEM_INPUT_2 = 1;
    public static final int ITEM_INPUT_3 = 2;
    public static final int FLUID_BUCKET = 3;
    public static final int FLUID_INPUT = 4;
    public static final int OUTPUT_SLOT = 5;
    private static int[] GUI_BACKGROUND_COORDS = new int[]{0, 0, 132, 64};
    private static int[] INPUT_FLUID_TANK = new int[]{11, 52, 12, 47, 5000};
    public static int SMELT_TIME = 50;
    private static int TEXT_Y_HEIGHT = 55;
    private static String MOD_ID = "nuclearscience";
    private static String RECIPE_GROUP = "msr_processor";
    private static String GUI_TEXTURE_STRING = "textures/gui/jei/msr_processing_recipe_gui.png";
    public static ItemStack INPUT_MACHINE = new ItemStack((IItemProvider)DeferredRegisters.blockMSRFuelPreProcessor);
    private LoadingCache<Integer, IDrawableAnimated> cache;
    public static ResourceLocation UID = new ResourceLocation(MOD_ID, RECIPE_GROUP);

    public MSRProcessorRecipeCategory(final IGuiHelper guiHelper) {
        super(guiHelper, MOD_ID, RECIPE_GROUP, GUI_TEXTURE_STRING, INPUT_MACHINE, GUI_BACKGROUND_COORDS, Fluid3Items2ItemRecipe.class, TEXT_Y_HEIGHT, SMELT_TIME);
        this.cache = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return guiHelper.drawableBuilder(MSRProcessorRecipeCategory.this.getGuiTexture(), 0, 65, 68, 22).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public void setIngredients(Fluid3Items2ItemRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.getItemIngredients(recipe));
        ingredients.setInputs(VanillaTypes.FLUID, MSRProcessorRecipeCategory.getFluids(recipe));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, Fluid3Items2ItemRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(0, true, 58, 2);
        guiItemStacks.init(1, true, 58, 23);
        guiItemStacks.init(2, true, 58, 44);
        guiItemStacks.init(3, true, 27, 36);
        guiItemStacks.init(5, false, 104, 23);
        int fluidInputAmount = ((FluidIngredient)recipe.func_192400_c().get(3)).getFluidStack().getAmount();
        int leftHeightOffset = (int)Math.ceil((float)fluidInputAmount / (float)INPUT_FLUID_TANK[4] * (float)INPUT_FLUID_TANK[3]);
        int leftStartY = INPUT_FLUID_TANK[1] - leftHeightOffset + 1;
        guiFluidStacks.init(4, true, INPUT_FLUID_TANK[0], leftStartY, INPUT_FLUID_TANK[2], leftHeightOffset, fluidInputAmount, true, null);
        guiItemStacks.set(ingredients);
        guiFluidStacks.set(ingredients);
    }

    public void draw(Fluid3Items2ItemRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        IDrawableAnimated arrow = this.getArrow();
        arrow.draw(matrixStack, 32, 17);
        this.drawSmeltTime(recipe, matrixStack, this.getYHeight());
    }

    protected IDrawableAnimated getArrow() {
        return (IDrawableAnimated)this.cache.getUnchecked((Object)this.getArrowSmeltTime());
    }

    protected void drawSmeltTime(Fluid3Items2ItemRecipe recipe, MatrixStack matrixStack, int y) {
        int smeltTimeSeconds = this.getArrowSmeltTime() / 20;
        TranslationTextComponent timeString = new TranslationTextComponent("gui.jei.category." + this.getRecipeGroup() + ".info.power", new Object[]{smeltTimeSeconds});
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontRenderer = minecraft.field_71466_p;
        fontRenderer.func_243248_b(matrixStack, (ITextComponent)timeString, (float)(this.getBackground().getWidth() - fontRenderer.func_238414_a_((ITextProperties)timeString)), (float)y, -8355712);
    }

    public List<List<ItemStack>> getItemIngredients(Fluid3Items2ItemRecipe recipe) {
        ArrayList<List<ItemStack>> stacks = new ArrayList<List<ItemStack>>();
        NonNullList recipeIngredients = recipe.func_192400_c();
        stacks.add(((CountableIngredient)recipeIngredients.get(0)).fetchCountedStacks());
        stacks.add(((CountableIngredient)recipeIngredients.get(1)).fetchCountedStacks());
        stacks.add(((CountableIngredient)recipeIngredients.get(2)).fetchCountedStacks());
        FluidStack fluid = ((FluidIngredient)recipeIngredients.get(3)).getFluidStack();
        ItemStack filledBucket = new ItemStack((IItemProvider)fluid.getFluid().func_204524_b());
        CapabilityUtils.fill((ItemStack)filledBucket, (FluidStack)fluid);
        ArrayList<ItemStack> bucketList = new ArrayList<ItemStack>();
        bucketList.add(filledBucket);
        stacks.add(bucketList);
        return stacks;
    }

    private static List<FluidStack> getFluids(Fluid3Items2ItemRecipe recipe) {
        ArrayList<FluidStack> list = new ArrayList<FluidStack>();
        list.add(((FluidIngredient)recipe.func_192400_c().get(3)).getFluidStack());
        return list;
    }
}

