/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.compatability.jei.recipecategories.specificmachines.nuclearscience;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.matrix.MatrixStack;
import electrodynamics.compatability.jei.recipecategories.ElectrodynamicsRecipeCategory;
import electrodynamics.compatability.jei.recipecategories.psuedorecipes.PsuedoO2ORecipe;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.AirItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import nuclearscience.DeferredRegisters;

public class ParticleAcceleratorAntiMatterRecipeCategory
extends ElectrodynamicsRecipeCategory<PsuedoO2ORecipe> {
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private static final int ANY_ITEM_INPUT_SLOT = 2;
    private static int[] GUI_BACKGROUND = new int[]{0, 0, 132, 66};
    private static int[] PROCESSING_ARROW_COORDS = new int[]{0, 67, 82, 47};
    private static int[] INPUT_OFFSET = new int[]{12, 39};
    private static int[] OUTPUT_OFFSET = new int[]{101, 20};
    private static int[] PROCESSING_ARROW_OFFSET = new int[]{17, 6};
    private static int SMELT_TIME = 50;
    private static int TEXT_Y_HEIGHT = 58;
    private static String MOD_ID = "nuclearscience";
    private static String RECIPE_GROUP = "partical_accelerator_antimatter";
    private static String GUI_TEXTURE = "textures/gui/jei/particle_accelerator_antimatter_gui.png";
    public static ItemStack INPUT_MACHINE = new ItemStack((IItemProvider)DeferredRegisters.blockParticleInjector);
    private LoadingCache<Integer, IDrawableAnimated> CACHED_ARROWS;
    private static IDrawableAnimated.StartDirection ARROW_START_DIRECTION = IDrawableAnimated.StartDirection.LEFT;
    public static ResourceLocation UID = new ResourceLocation(MOD_ID, RECIPE_GROUP);

    public ParticleAcceleratorAntiMatterRecipeCategory(final IGuiHelper guiHelper) {
        super(guiHelper, MOD_ID, RECIPE_GROUP, GUI_TEXTURE, INPUT_MACHINE, GUI_BACKGROUND, PsuedoO2ORecipe.class, TEXT_Y_HEIGHT, SMELT_TIME);
        this.CACHED_ARROWS = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return guiHelper.drawableBuilder(ParticleAcceleratorAntiMatterRecipeCategory.this.getGuiTexture(), PROCESSING_ARROW_COORDS[0], PROCESSING_ARROW_COORDS[1], PROCESSING_ARROW_COORDS[2], PROCESSING_ARROW_COORDS[3]).buildAnimated(cookTime.intValue(), ARROW_START_DIRECTION, false);
            }
        });
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public void setIngredients(PsuedoO2ORecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, ParticleAcceleratorAntiMatterRecipeCategory.recipeInput(recipe));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.OUTPUT);
    }

    public void setRecipe(IRecipeLayout recipeLayout, PsuedoO2ORecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, INPUT_OFFSET[0], INPUT_OFFSET[1]);
        guiItemStacks.init(2, true, 12, 2);
        guiItemStacks.init(1, false, OUTPUT_OFFSET[0], OUTPUT_OFFSET[1]);
        guiItemStacks.set(ingredients);
    }

    public void draw(PsuedoO2ORecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        IDrawableAnimated arrow = this.getArrow(recipe);
        arrow.draw(matrixStack, PROCESSING_ARROW_OFFSET[0], PROCESSING_ARROW_OFFSET[1]);
        this.drawSmeltTime(recipe, matrixStack, this.getYHeight());
    }

    protected IDrawableAnimated getArrow(PsuedoO2ORecipe recipe) {
        return (IDrawableAnimated)this.CACHED_ARROWS.getUnchecked((Object)this.getArrowSmeltTime());
    }

    protected void drawSmeltTime(PsuedoO2ORecipe recipe, MatrixStack matrixStack, int y) {
        int smeltTimeSeconds = this.getArrowSmeltTime() / 20;
        TranslationTextComponent timeString = new TranslationTextComponent("gui.jei.category." + this.getRecipeGroup() + ".info.power", new Object[]{smeltTimeSeconds});
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontRenderer = minecraft.field_71466_p;
        int stringWidth = fontRenderer.func_238414_a_((ITextProperties)timeString);
        fontRenderer.func_243248_b(matrixStack, (ITextComponent)timeString, (float)(this.getBackground().getWidth() - stringWidth), (float)y, -8355712);
    }

    private static List<List<ItemStack>> recipeInput(PsuedoO2ORecipe recipe) {
        ArrayList<ItemStack> emagCell = new ArrayList<ItemStack>();
        emagCell.add(recipe.INPUT.func_193365_a()[0]);
        int i = 0;
        ArrayList allItems = new ArrayList(ForgeRegistries.ITEMS.getValues());
        ArrayList<Object> vanillaItems = new ArrayList<Object>();
        ItemGroup[] vanillaItemGroups = new ItemGroup[]{ItemGroup.field_78038_k, ItemGroup.field_78030_b, ItemGroup.field_78037_j, ItemGroup.field_78031_c, ItemGroup.field_78039_h, ItemGroup.field_78026_f, ItemGroup.field_78028_d, ItemGroup.field_78040_i, ItemGroup.field_78029_e};
        block0: for (Object item : allItems) {
            for (i = 0; i < vanillaItemGroups.length; ++i) {
                if (item.func_77640_w() != vanillaItemGroups[i]) continue;
                vanillaItems.add(item);
                continue block0;
            }
        }
        for (Object item : vanillaItems) {
            if (!(item instanceof AirItem)) continue;
            vanillaItems.remove(item);
        }
        ArrayList<ItemStack> vanillaItemStacks = new ArrayList<ItemStack>();
        for (Item item : vanillaItems) {
            vanillaItemStacks.add(new ItemStack((IItemProvider)item));
        }
        ArrayList<List<ItemStack>> inputSlots = new ArrayList<List<ItemStack>>();
        inputSlots.add(emagCell);
        inputSlots.add(vanillaItemStacks);
        return inputSlots;
    }
}

