/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.compatability.jei.recipecategories.specificmachines.nuclearscience;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.matrix.MatrixStack;
import electrodynamics.compatability.jei.recipecategories.ElectrodynamicsRecipeCategory;
import electrodynamics.compatability.jei.recipecategories.psuedorecipes.PsuedoO2ORecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import nuclearscience.DeferredRegisters;

public class ParticleAcceleratorDarkMatterRecipeCategory
extends ElectrodynamicsRecipeCategory<PsuedoO2ORecipe> {
    public static final int OUTPUT_SLOT = 0;
    private static int[] GUI_BACKGROUND_COORDS = new int[]{0, 0, 132, 132};
    private static int[] OUTPUT_OFFSET = new int[]{57, 57};
    public static int SMELT_TIME = 50;
    private static int TEXT_Y_HEIGHT = 122;
    private static String MOD_ID = "nuclearscience";
    private static String RECIPE_GROUP = "partical_accelerator_darkmatter";
    private static String GUI_TEXTURE_STRING = "textures/gui/jei/particle_accelerator_dark_matter_gui.png";
    public static ItemStack INPUT_MACHINE = new ItemStack((IItemProvider)DeferredRegisters.blockParticleInjector);
    private LoadingCache<Integer, ArrayList<IDrawableAnimated>> CACHED_ARROWS;
    public static ResourceLocation UID = new ResourceLocation(MOD_ID, RECIPE_GROUP);

    public ParticleAcceleratorDarkMatterRecipeCategory(final IGuiHelper guiHelper) {
        super(guiHelper, MOD_ID, RECIPE_GROUP, GUI_TEXTURE_STRING, INPUT_MACHINE, GUI_BACKGROUND_COORDS, PsuedoO2ORecipe.class, TEXT_Y_HEIGHT, SMELT_TIME);
        this.CACHED_ARROWS = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, ArrayList<IDrawableAnimated>>(){

            public ArrayList<IDrawableAnimated> load(Integer cookTime) {
                IDrawableAnimated majorArrowBottom = guiHelper.drawableBuilder(ParticleAcceleratorDarkMatterRecipeCategory.this.getGuiTexture(), 179, 17, 37, 75).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.BOTTOM, false);
                IDrawableAnimated majorArrowTop = guiHelper.drawableBuilder(ParticleAcceleratorDarkMatterRecipeCategory.this.getGuiTexture(), 132, 0, 37, 75).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.TOP, false);
                IDrawableAnimated[] arrows = new IDrawableAnimated[]{majorArrowBottom, majorArrowTop};
                return new ArrayList<IDrawableAnimated>(Arrays.asList(arrows));
            }
        });
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public void setIngredients(PsuedoO2ORecipe recipe, IIngredients ingredients) {
        NonNullList inputs = NonNullList.func_191196_a();
        inputs.addAll(this.getIngredients(recipe));
        ingredients.setInputIngredients((List)inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.OUTPUT);
    }

    public void setRecipe(IRecipeLayout recipeLayout, PsuedoO2ORecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, OUTPUT_OFFSET[0], OUTPUT_OFFSET[1]);
        guiItemStacks.set(ingredients);
    }

    public void draw(PsuedoO2ORecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        ArrayList<IDrawableAnimated> arrow = this.getArrow(recipe);
        arrow.get(0).draw(matrixStack, 70, 38);
        arrow.get(1).draw(matrixStack, 23, 21);
        this.drawSmeltTime(recipe, matrixStack, this.getYHeight());
    }

    protected ArrayList<IDrawableAnimated> getArrow(PsuedoO2ORecipe recipe) {
        return (ArrayList)this.CACHED_ARROWS.getUnchecked((Object)this.getArrowSmeltTime());
    }

    protected void drawSmeltTime(PsuedoO2ORecipe recipe, MatrixStack matrixStack, int y) {
        int smeltTimeSeconds = this.getArrowSmeltTime() / 20;
        TranslationTextComponent timeString = new TranslationTextComponent("gui.jei.category." + this.getRecipeGroup() + ".info.power", new Object[]{smeltTimeSeconds});
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontRenderer = minecraft.field_71466_p;
        int stringWidth = fontRenderer.func_238414_a_((ITextProperties)timeString);
        fontRenderer.func_243248_b(matrixStack, (ITextComponent)timeString, (float)(this.getBackground().getWidth() - stringWidth), (float)y, -8355712);
    }

    public NonNullList<Ingredient> getIngredients(PsuedoO2ORecipe recipe) {
        Ingredient ingredient1 = recipe.INPUT;
        NonNullList ingredients = NonNullList.func_191196_a();
        ingredients.add((Object)ingredient1);
        return ingredients;
    }
}

