/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.api.radiation;

import electrodynamics.prefab.utilities.object.Location;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import nuclearscience.DeferredRegisters;
import nuclearscience.api.radiation.EffectRadiation;
import nuclearscience.common.item.ItemGeigerCounter;
import nuclearscience.common.item.ItemHazmatArmor;

@Mod.EventBusSubscriber(modid="nuclearscience", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RadiationSystem {
    public static HashMap<Player, Double> radiationMap = new HashMap();

    public static double getRadiationModifier(Level world, Location source, Location end) {
        double distance = 1.0 + source.distance(end);
        Location clone = new Location(end);
        double modifier = 1.0;
        Location newSource = new Location(source);
        clone.add(-source.x(), -source.y(), -source.z()).normalize().mul((double)0.33f);
        BlockPos curr = newSource.toBlockPos();
        double lastHard = 0.0;
        for (int checks = (int)distance * 3; checks > 0; --checks) {
            newSource.add(clone);
            double hard = lastHard;
            BlockPos next = newSource.toBlockPos();
            if (!curr.equals((Object)next)) {
                curr = next;
                BlockState state = world.m_8055_(curr);
                lastHard = hard = (double)(state.m_60734_() == DeferredRegisters.blocklead ? 20000.0f : state.m_60800_((BlockGetter)world, curr)) / (world.m_6425_(curr).m_76178_() ? 1.0 : 50.0);
            }
            modifier += hard / 4.5;
        }
        return modifier;
    }

    public static double getRadiation(Level world, Location source, Location end, double strength) {
        double distance = 1.0 + source.distance(end);
        return strength / (RadiationSystem.getRadiationModifier(world, source, end) * distance * distance);
    }

    public static void applyRadiation(LivingEntity entity, Location source, double strength) {
        int protection = 1;
        if (!entity.f_19853_.f_46443_) {
            Player pl;
            LivingEntity already2;
            Player pl2;
            Player player;
            boolean isPlayer = entity instanceof Player;
            if (isPlayer && !(player = (Player)entity).m_7500_()) {
                for (int i = 0; i < player.m_150109_().f_35975_.size(); ++i) {
                    ItemStack next = (ItemStack)player.m_150109_().f_35975_.get(i);
                    if (!(next.m_41720_() instanceof ItemHazmatArmor)) continue;
                    ++protection;
                    float damage = (float)(strength * (double)2.15f) / 2169.9976f;
                    if (!(Math.random() < (double)damage)) continue;
                    int integerDamage = (int)Math.max(1.0f, damage);
                    if (next.m_41773_() <= next.m_41776_() && !next.m_41629_(integerDamage, entity.f_19853_.f_46441_, (ServerPlayer)player)) continue;
                    player.m_150109_().f_35975_.set(i, (Object)ItemStack.f_41583_);
                }
            }
            Location end = new Location(entity.m_20182_());
            double radiation = 0.0;
            LivingEntity integerDamage = entity;
            if (integerDamage instanceof Player && ((pl2 = (Player)integerDamage).m_6844_(EquipmentSlot.MAINHAND).m_41720_() instanceof ItemGeigerCounter || pl2.m_6844_(EquipmentSlot.OFFHAND).m_41720_() instanceof ItemGeigerCounter)) {
                double already2 = radiationMap.containsKey(entity) ? radiationMap.get(entity) : 0.0;
                radiation = RadiationSystem.getRadiation(entity.f_19853_, source, end, strength);
                radiationMap.put((Player)entity, already2 + radiation);
            }
            if (!((already2 = entity) instanceof Player && (pl = (Player)already2).m_7500_() || protection >= 5 || !(radiationMap.getOrDefault(entity, 11.0) > 4.0))) {
                if (radiation == 0.0) {
                    radiation = RadiationSystem.getRadiation(entity.f_19853_, source, end, strength);
                }
                double distance = 1.0 + source.distance(end);
                double modifier = strength / (radiation * distance * distance);
                int amplitude = (int)Math.max(0.0, Math.min(strength / modifier / (distance * 4000.0), 9.0));
                int time = (int)(strength / modifier / ((double)(amplitude + 1) * distance));
                if (amplitude == 0 && time <= 40) {
                    return;
                }
                entity.m_7292_(new MobEffectInstance((MobEffect)EffectRadiation.INSTANCE, time, Math.min(40, amplitude), false, true));
            }
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            radiationMap.clear();
        }
    }
}

