/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import electrodynamics.DeferredRegisters;
import electrodynamics.api.electricity.formatting.ChatFormatter;
import electrodynamics.api.electricity.formatting.ElectricUnit;
import electrodynamics.api.screen.IScreenWrapper;
import electrodynamics.common.item.subtype.SubtypeProcessorUpgrade;
import electrodynamics.prefab.inventory.container.GenericContainer;
import electrodynamics.prefab.inventory.container.slot.SlotRestricted;
import electrodynamics.prefab.screen.GenericScreen;
import electrodynamics.prefab.screen.component.ScreenComponentElectricInfo;
import electrodynamics.prefab.screen.component.ScreenComponentFluid;
import electrodynamics.prefab.screen.component.ScreenComponentProgress;
import electrodynamics.prefab.screen.component.ScreenComponentSlot;
import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.components.ComponentType;
import electrodynamics.prefab.tile.components.type.ComponentElectrodynamic;
import electrodynamics.prefab.tile.components.type.ComponentProcessor;
import electrodynamics.prefab.tile.components.utils.AbstractFluidHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import nuclearscience.common.inventory.container.ContainerChemicalExtractor;
import nuclearscience.common.tile.TileChemicalExtractor;

@OnlyIn(value=Dist.CLIENT)
public class ScreenChemicalExtractor
extends GenericScreen<ContainerChemicalExtractor> {
    public ScreenChemicalExtractor(ContainerChemicalExtractor container, Inventory playerInventory, Component title) {
        super((GenericContainer)container, playerInventory, title);
        this.components.add(new ScreenComponentProgress(() -> {
            GenericTile furnace = (GenericTile)container.getHostFromIntArray();
            if (furnace != null) {
                ComponentProcessor processor = (ComponentProcessor)furnace.getComponent(ComponentType.Processor);
                if (processor.operatingTicks > 0.0) {
                    return Math.min(1.0, processor.operatingTicks / ((double)processor.requiredTicks / 2.0));
                }
            }
            return 0.0;
        }, (IScreenWrapper)this, 42, 30));
        this.components.add(new ScreenComponentProgress(() -> {
            GenericTile furnace = (GenericTile)container.getHostFromIntArray();
            if (furnace != null) {
                ComponentProcessor processor = (ComponentProcessor)furnace.getComponent(ComponentType.Processor);
                if (processor.operatingTicks > (double)processor.requiredTicks / 2.0) {
                    return Math.min(1.0, (processor.operatingTicks - (double)processor.requiredTicks / 2.0) / ((double)processor.requiredTicks / 2.0));
                }
            }
            return 0.0;
        }, (IScreenWrapper)this, 98, 30));
        this.components.add(new ScreenComponentProgress(() -> 0.0, (IScreenWrapper)this, 46, 50).left());
        this.components.add(new ScreenComponentFluid(() -> {
            TileChemicalExtractor boiler = (TileChemicalExtractor)container.getHostFromIntArray();
            if (boiler != null) {
                AbstractFluidHandler handler = (AbstractFluidHandler)boiler.getComponent(ComponentType.FluidHandler);
                for (Fluid fluid : handler.getValidInputFluids()) {
                    FluidTank tank = handler.getTankFromFluid(fluid, true);
                    if (tank.getFluidAmount() <= 0) continue;
                    return tank;
                }
            }
            return null;
        }, (IScreenWrapper)this, 21, 18));
        this.components.add(new ScreenComponentElectricInfo(this::getEnergyInformation, (IScreenWrapper)this, -25, 2));
    }

    protected ScreenComponentSlot createScreenSlot(Slot slot) {
        SlotRestricted res;
        Slot slot2 = slot;
        return new ScreenComponentSlot(slot2 instanceof SlotRestricted && (res = (SlotRestricted)slot2).m_5857_(new ItemStack((ItemLike)DeferredRegisters.SUBTYPEITEM_MAPPINGS.get(SubtypeProcessorUpgrade.basicspeed))) ? ScreenComponentSlot.EnumSlotType.SPEED : (slot instanceof SlotRestricted ? ScreenComponentSlot.EnumSlotType.LIQUID : ScreenComponentSlot.EnumSlotType.NORMAL), (IScreenWrapper)this, slot.f_40220_ - 1, slot.f_40221_ - 1);
    }

    private List<? extends FormattedCharSequence> getEnergyInformation() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        GenericTile box = (GenericTile)((ContainerChemicalExtractor)this.f_97732_).getHostFromIntArray();
        if (box != null) {
            ComponentElectrodynamic electro = (ComponentElectrodynamic)box.getComponent(ComponentType.Electrodynamic);
            ComponentProcessor processor = (ComponentProcessor)box.getComponent(ComponentType.Processor);
            list.add(new TranslatableComponent("gui.chemicalextractor.usage", new Object[]{new TextComponent(ChatFormatter.getElectricDisplayShort((double)(processor.getUsage() * 20.0), (ElectricUnit)ElectricUnit.WATT)).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
            list.add(new TranslatableComponent("gui.chemicalextractor.voltage", new Object[]{new TextComponent(ChatFormatter.getElectricDisplayShort((double)electro.getVoltage(), (ElectricUnit)ElectricUnit.VOLTAGE)).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        }
        return list;
    }
}

