/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import electrodynamics.api.electricity.formatting.ChatFormatter;
import electrodynamics.api.electricity.formatting.ElectricUnit;
import electrodynamics.api.screen.IScreenWrapper;
import electrodynamics.prefab.inventory.container.GenericContainer;
import electrodynamics.prefab.screen.GenericScreen;
import electrodynamics.prefab.screen.component.ScreenComponentTextInputBar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nuclearscience.common.inventory.container.ContainerQuantumCapacitor;
import nuclearscience.common.packet.NetworkHandler;
import nuclearscience.common.packet.PacketSetQuantumCapacitorData;
import nuclearscience.common.tile.TileQuantumCapacitor;

@OnlyIn(value=Dist.CLIENT)
public class ScreenQuantumCapacitor
extends GenericScreen<ContainerQuantumCapacitor> {
    private EditBox outputField;
    private EditBox frequencyField;
    private boolean needsUpdate = true;

    public ScreenQuantumCapacitor(ContainerQuantumCapacitor container, Inventory playerInventory, Component title) {
        super((GenericContainer)container, playerInventory, title);
        this.components.add(new ScreenComponentTextInputBar((IScreenWrapper)this, 115, 14));
        this.components.add(new ScreenComponentTextInputBar((IScreenWrapper)this, 115, 34));
    }

    protected void m_181908_() {
        super.m_181908_();
        this.outputField.m_94120_();
        this.frequencyField.m_94120_();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initFields();
    }

    protected void initFields() {
        this.f_96541_.f_91068_.m_90926_(true);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.outputField = new EditBox(this.f_96547_, i + 120, j + 18, 46, 13, (Component)new TranslatableComponent("container.quantumcapacitor.joulesoutput"));
        this.outputField.m_94202_(-1);
        this.outputField.m_94205_(-1);
        this.outputField.m_94182_(false);
        this.outputField.m_94199_(6);
        this.outputField.m_94151_(this::updateOutput);
        this.frequencyField = new EditBox(this.f_96547_, i + 120, j + 18 + 20, 46, 13, (Component)new TranslatableComponent("container.quantumcapacitor.frequency"));
        this.frequencyField.m_94202_(-1);
        this.frequencyField.m_94205_(-1);
        this.frequencyField.m_94182_(false);
        this.frequencyField.m_94199_(6);
        this.frequencyField.m_94151_(this::updateFreq);
        this.m_7787_((GuiEventListener)this.outputField);
        this.m_7787_((GuiEventListener)this.frequencyField);
    }

    private void updateValues(String coord) {
        if (!coord.isEmpty()) {
            Double triedOutput = 0.0;
            try {
                triedOutput = Double.parseDouble(this.outputField.m_94155_());
            }
            catch (Exception exception) {
                // empty catch block
            }
            Integer frequency = 0;
            try {
                frequency = Integer.parseInt(this.frequencyField.m_94155_());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (((ContainerQuantumCapacitor)this.f_97732_).getHostFromIntArray() != null) {
                NetworkHandler.CHANNEL.sendToServer((Object)new PacketSetQuantumCapacitorData(((TileQuantumCapacitor)((ContainerQuantumCapacitor)this.f_97732_).getHostFromIntArray()).m_58899_(), triedOutput, frequency));
            }
        }
    }

    private void updateFreq(String val) {
        this.frequencyField.m_94178_(true);
        this.outputField.m_94178_(false);
        this.updateValues(val);
    }

    private void updateOutput(String val) {
        this.frequencyField.m_94178_(false);
        this.outputField.m_94178_(true);
        this.updateValues(val);
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        String s = this.outputField.m_94155_();
        String s1 = this.frequencyField.m_94155_();
        this.m_6575_(minecraft, width, height);
        this.outputField.m_94144_(s);
        this.frequencyField.m_94144_(s1);
    }

    public void m_7861_() {
        super.m_7861_();
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.needsUpdate && ((ContainerQuantumCapacitor)this.f_97732_).getHostFromIntArray() != null) {
            this.needsUpdate = false;
            this.outputField.m_94144_("" + ((TileQuantumCapacitor)((ContainerQuantumCapacitor)this.f_97732_).getHostFromIntArray()).outputJoules);
            this.frequencyField.m_94144_("" + ((TileQuantumCapacitor)((ContainerQuantumCapacitor)this.f_97732_).getHostFromIntArray()).frequency);
        }
        this.outputField.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.frequencyField.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        super.m_7027_(matrixStack, mouseX, mouseY);
        TileQuantumCapacitor box = (TileQuantumCapacitor)((ContainerQuantumCapacitor)this.f_97732_).getHostFromIntArray();
        if (box != null) {
            this.f_96547_.m_92889_(matrixStack, (Component)new TranslatableComponent("gui.quantumcapacitor.current", new Object[]{ChatFormatter.getElectricDisplayShort((double)(box.getOutputJoules() * 20.0 / 1920.0), (ElectricUnit)ElectricUnit.AMPERE)}), (float)this.f_97730_, (float)this.f_97731_ - 55.0f, 0x404040);
            this.f_96547_.m_92889_(matrixStack, (Component)new TranslatableComponent("gui.quantumcapacitor.transfer", new Object[]{ChatFormatter.getElectricDisplayShort((double)(box.getOutputJoules() * 20.0), (ElectricUnit)ElectricUnit.WATT)}), (float)this.f_97730_, (float)this.f_97731_ - 42.0f, 0x404040);
            this.f_96547_.m_92889_(matrixStack, (Component)new TranslatableComponent("gui.quantumcapacitor.voltage", new Object[]{ChatFormatter.getElectricDisplayShort((double)1920.0, (ElectricUnit)ElectricUnit.VOLTAGE)}), (float)this.f_97730_, (float)this.f_97731_ - 29.0f, 0x404040);
            this.f_96547_.m_92889_(matrixStack, (Component)new TranslatableComponent("gui.quantumcapacitor.stored", new Object[]{ChatFormatter.getElectricDisplayShort((double)box.joulesClient, (ElectricUnit)ElectricUnit.JOULES) + " / " + ChatFormatter.getElectricDisplayShort((double)Double.MAX_VALUE, (ElectricUnit)ElectricUnit.JOULES)}), (float)this.f_97730_, (float)this.f_97731_ - 16.0f, 0x404040);
        }
    }
}

