/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import electrodynamics.api.electricity.formatting.ChatFormatter;
import electrodynamics.api.electricity.formatting.ElectricUnit;
import electrodynamics.api.screen.IScreenWrapper;
import electrodynamics.prefab.inventory.container.GenericContainer;
import electrodynamics.prefab.screen.GenericScreen;
import electrodynamics.prefab.screen.component.ScreenComponentElectricInfo;
import electrodynamics.prefab.screen.component.ScreenComponentProgress;
import electrodynamics.prefab.utilities.object.TransferPack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nuclearscience.api.radiation.IRadioactiveObject;
import nuclearscience.api.radiation.RadiationRegister;
import nuclearscience.common.inventory.container.ContainerRadioisotopeGenerator;
import nuclearscience.common.settings.Constants;

@OnlyIn(value=Dist.CLIENT)
public class ScreenRadioisotopeGenerator
extends GenericScreen<ContainerRadioisotopeGenerator> {
    public ScreenRadioisotopeGenerator(ContainerRadioisotopeGenerator container, Inventory playerInventory, Component title) {
        super((GenericContainer)container, playerInventory, title);
        this.components.add(new ScreenComponentProgress(() -> {
            ItemStack in = container.m_38853_(0).m_7993_();
            IRadioactiveObject rad = RadiationRegister.get(in.m_41720_());
            double currentOutput = (double)in.m_41613_() * Constants.RADIOISOTOPEGENERATOR_OUTPUT_MULTIPLIER * rad.getRadiationStrength();
            if (currentOutput > 0.0) {
                return 1.0;
            }
            return 0.0;
        }, (IScreenWrapper)this, 25, 24).flame());
        this.components.add(new ScreenComponentElectricInfo(this::getEnergyInformation, (IScreenWrapper)this, -25, 2));
    }

    private List<? extends FormattedCharSequence> getEnergyInformation() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        ItemStack in = ((ContainerRadioisotopeGenerator)this.f_97732_).m_38853_(0).m_7993_();
        IRadioactiveObject rad = RadiationRegister.get(in.m_41720_());
        double currentOutput = (double)in.m_41613_() * Constants.RADIOISOTOPEGENERATOR_OUTPUT_MULTIPLIER * rad.getRadiationStrength();
        TransferPack transfer = TransferPack.ampsVoltage((double)(currentOutput / Constants.RADIOISOTOPEGENERATOR_VOLTAGE), (double)Constants.RADIOISOTOPEGENERATOR_VOLTAGE);
        list.add(new TranslatableComponent("gui.radioisotopegenerator.current", new Object[]{new TextComponent(ChatFormatter.getElectricDisplayShort((double)transfer.getAmps(), (ElectricUnit)ElectricUnit.AMPERE)).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        list.add(new TranslatableComponent("gui.radioisotopegenerator.output", new Object[]{new TextComponent(ChatFormatter.getElectricDisplayShort((double)transfer.getWatts(), (ElectricUnit)ElectricUnit.WATT)).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        list.add(new TranslatableComponent("gui.radioisotopegenerator.voltage", new Object[]{new TextComponent(ChatFormatter.getElectricDisplayShort((double)transfer.getVoltage(), (ElectricUnit)ElectricUnit.VOLTAGE)).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        return list;
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        super.m_7027_(matrixStack, mouseX, mouseY);
        ItemStack in = ((ContainerRadioisotopeGenerator)this.f_97732_).m_38853_(0).m_7993_();
        IRadioactiveObject rad = RadiationRegister.get(in.m_41720_());
        double currentOutput = (double)in.m_41613_() * Constants.RADIOISOTOPEGENERATOR_OUTPUT_MULTIPLIER * rad.getRadiationStrength();
        TransferPack transfer = TransferPack.ampsVoltage((double)(currentOutput / Constants.RADIOISOTOPEGENERATOR_VOLTAGE), (double)Constants.RADIOISOTOPEGENERATOR_VOLTAGE);
        this.f_96547_.m_92889_(matrixStack, (Component)new TranslatableComponent("gui.radioisotopegenerator.current", new Object[]{ChatFormatter.getElectricDisplayShort((double)transfer.getAmps(), (ElectricUnit)ElectricUnit.AMPERE)}), (float)this.f_97730_ + 60.0f, (float)this.f_97731_ - 48.0f, 0x404040);
        this.f_96547_.m_92889_(matrixStack, (Component)new TranslatableComponent("gui.radioisotopegenerator.output", new Object[]{ChatFormatter.getElectricDisplayShort((double)transfer.getWatts(), (ElectricUnit)ElectricUnit.WATT)}), (float)this.f_97730_ + 60.0f, (float)this.f_97731_ - 35.0f, 0x404040);
        this.f_96547_.m_92889_(matrixStack, (Component)new TranslatableComponent("gui.radioisotopegenerator.voltage", new Object[]{ChatFormatter.getElectricDisplayShort((double)transfer.getVoltage(), (ElectricUnit)ElectricUnit.VOLTAGE)}), (float)this.f_97730_ + 60.0f, (float)this.f_97731_ - 22.0f, 0x404040);
    }
}

