/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.block.connect;

import com.google.common.collect.Maps;
import electrodynamics.common.block.connect.EnumConnectType;
import electrodynamics.prefab.block.GenericEntityBlockWaterloggable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import nuclearscience.api.network.moltensalt.IMoltenSaltPipe;
import nuclearscience.common.block.subtype.SubtypeMoltenSaltPipe;
import nuclearscience.common.tile.TileHeatExchanger;
import nuclearscience.common.tile.TileMSRReactorCore;
import nuclearscience.common.tile.network.TileMoltenSaltPipe;

public class BlockMoltenSaltPipe
extends GenericEntityBlockWaterloggable {
    public static final Map<Direction, EnumProperty<EnumConnectType>> FACING_TO_PROPERTY_MAP = (Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), p -> {
        p.put(Direction.NORTH, EnumConnectType.NORTH);
        p.put(Direction.EAST, EnumConnectType.EAST);
        p.put(Direction.SOUTH, EnumConnectType.SOUTH);
        p.put(Direction.WEST, EnumConnectType.WEST);
        p.put(Direction.UP, EnumConnectType.UP);
        p.put(Direction.DOWN, EnumConnectType.DOWN);
    });
    public static final HashSet<Block> PIPESET = new HashSet();
    protected final VoxelShape cube;
    protected final VoxelShape cubeup;
    protected final VoxelShape cubedown;
    protected final VoxelShape cubenorth;
    protected final VoxelShape cubesouth;
    protected final VoxelShape cubewest;
    protected final VoxelShape cubeeast;
    protected HashMap<HashSet<Direction>, VoxelShape> shapestates = new HashMap();
    protected boolean locked = false;
    public final SubtypeMoltenSaltPipe pipe;

    public BlockMoltenSaltPipe(SubtypeMoltenSaltPipe pipe) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_).m_60978_(0.15f).m_60988_());
        this.pipe = pipe;
        double w = 3.0;
        double sm = 8.0 - w;
        double lg = 8.0 + w;
        this.cube = Block.m_49796_((double)sm, (double)sm, (double)sm, (double)lg, (double)lg, (double)lg);
        this.cubeup = Block.m_49796_((double)sm, (double)sm, (double)sm, (double)lg, (double)16.0, (double)lg);
        this.cubedown = Block.m_49796_((double)sm, (double)0.0, (double)sm, (double)lg, (double)lg, (double)lg);
        this.cubenorth = Block.m_49796_((double)sm, (double)sm, (double)0.0, (double)lg, (double)lg, (double)lg);
        this.cubesouth = Block.m_49796_((double)sm, (double)sm, (double)sm, (double)lg, (double)lg, (double)16.0);
        this.cubewest = Block.m_49796_((double)0.0, (double)sm, (double)sm, (double)lg, (double)lg, (double)lg);
        this.cubeeast = Block.m_49796_((double)sm, (double)sm, (double)sm, (double)16.0, (double)lg, (double)lg);
        PIPESET.add((Block)this);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{EnumConnectType.UP, EnumConnectType.DOWN, EnumConnectType.NORTH, EnumConnectType.EAST, EnumConnectType.SOUTH, EnumConnectType.WEST});
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        VoxelShape shape = this.cube;
        HashSet<Direction> checked = new HashSet<Direction>();
        if (!EnumConnectType.NONE.equals((Object)state.m_61143_((Property)EnumConnectType.UP))) {
            checked.add(Direction.UP);
        }
        if (!EnumConnectType.NONE.equals((Object)state.m_61143_((Property)EnumConnectType.DOWN))) {
            checked.add(Direction.DOWN);
        }
        if (!EnumConnectType.NONE.equals((Object)state.m_61143_((Property)EnumConnectType.WEST))) {
            checked.add(Direction.WEST);
        }
        if (!EnumConnectType.NONE.equals((Object)state.m_61143_((Property)EnumConnectType.EAST))) {
            checked.add(Direction.EAST);
        }
        if (!EnumConnectType.NONE.equals((Object)state.m_61143_((Property)EnumConnectType.NORTH))) {
            checked.add(Direction.NORTH);
        }
        if (!EnumConnectType.NONE.equals((Object)state.m_61143_((Property)EnumConnectType.SOUTH))) {
            checked.add(Direction.SOUTH);
        }
        this.locked = true;
        if (this.shapestates.containsKey(checked)) {
            this.locked = false;
            return this.shapestates.get(checked);
        }
        this.locked = false;
        for (Direction dir : checked) {
            switch (dir) {
                case DOWN: {
                    shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.cubedown, (BooleanOp)BooleanOp.f_82695_);
                    break;
                }
                case EAST: {
                    shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.cubeeast, (BooleanOp)BooleanOp.f_82695_);
                    break;
                }
                case NORTH: {
                    shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.cubenorth, (BooleanOp)BooleanOp.f_82695_);
                    break;
                }
                case SOUTH: {
                    shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.cubesouth, (BooleanOp)BooleanOp.f_82695_);
                    break;
                }
                case UP: {
                    shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.cubeup, (BooleanOp)BooleanOp.f_82695_);
                    break;
                }
                case WEST: {
                    shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.cubewest, (BooleanOp)BooleanOp.f_82695_);
                    break;
                }
            }
        }
        while (this.locked) {
            System.out.println("Wire bounding boxes locked. This should never happen!");
        }
        this.shapestates.put(checked, shape);
        if (shape == null) {
            return Shapes.m_83040_();
        }
        return shape;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState stateIn, @Nullable LivingEntity placer, ItemStack stack) {
        BlockState acc = stateIn;
        for (Direction d : Direction.values()) {
            BlockEntity facingTile = worldIn.m_7702_(pos.m_142300_(d));
            if (facingTile instanceof IMoltenSaltPipe) {
                acc = (BlockState)acc.m_61124_((Property)FACING_TO_PROPERTY_MAP.get(d), (Comparable)EnumConnectType.WIRE);
                continue;
            }
            if ((!(facingTile instanceof TileMSRReactorCore) || d.m_122424_() != Direction.UP) && (!(facingTile instanceof TileHeatExchanger) || d.m_122424_() != Direction.DOWN)) continue;
            acc = (BlockState)acc.m_61124_((Property)FACING_TO_PROPERTY_MAP.get(d), (Comparable)EnumConnectType.INVENTORY);
        }
        worldIn.m_46597_(pos, acc);
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity tile;
        BlockEntity blockEntity;
        super.m_6807_(state, worldIn, pos, oldState, isMoving);
        if (!worldIn.f_46443_ && (blockEntity = (tile = worldIn.m_7702_(pos))) instanceof IMoltenSaltPipe) {
            IMoltenSaltPipe s = (IMoltenSaltPipe)blockEntity;
            s.refreshNetwork();
        }
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        BlockEntity tile;
        BlockEntity blockEntity;
        super.onNeighborChange(state, world, pos, neighbor);
        if (!world.m_5776_() && (blockEntity = (tile = world.m_7702_(pos))) instanceof IMoltenSaltPipe) {
            IMoltenSaltPipe s = (IMoltenSaltPipe)blockEntity;
            s.refreshNetworkIfChange();
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (stateIn.m_61143_((Property)BlockStateProperties.f_61362_) == Boolean.TRUE) {
            world.m_6217_().m_5945_(currentPos, (Object)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        EnumProperty<EnumConnectType> property = FACING_TO_PROPERTY_MAP.get(facing);
        BlockEntity tile = world.m_7702_(facingPos);
        if (tile instanceof IMoltenSaltPipe) {
            return (BlockState)stateIn.m_61124_(property, (Comparable)EnumConnectType.WIRE);
        }
        if (tile instanceof TileMSRReactorCore && facing.m_122424_() == Direction.UP || tile instanceof TileHeatExchanger && facing.m_122424_() == Direction.DOWN) {
            return (BlockState)stateIn.m_61124_(property, (Comparable)EnumConnectType.INVENTORY);
        }
        return (BlockState)stateIn.m_61124_(property, (Comparable)EnumConnectType.NONE);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileMoltenSaltPipe(pos, state);
    }
}

