/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.entity;

import com.mojang.math.Vector3f;
import electrodynamics.prefab.block.GenericEntityBlock;
import electrodynamics.prefab.utilities.object.Location;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import nuclearscience.DeferredRegisters;
import nuclearscience.api.fusion.IElectromagnet;
import nuclearscience.api.radiation.RadiationSystem;
import nuclearscience.common.block.BlockElectromagneticBooster;
import nuclearscience.common.block.facing.FacingDirection;
import nuclearscience.common.tile.TileElectromagneticSwitch;
import nuclearscience.common.tile.TileParticleInjector;

public class EntityParticle
extends Entity {
    private static final EntityDataAccessor<Direction> DIRECTION = SynchedEntityData.m_135353_(EntityParticle.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.m_135353_(EntityParticle.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private Direction direction = Direction.UP;
    public float speed = 0.02f;
    public BlockPos source = BlockPos.f_121853_;

    public EntityParticle(EntityType<?> entityTypeIn, Level worldIn) {
        super((EntityType)DeferredRegisters.ENTITY_PARTICLE.get(), worldIn);
    }

    public EntityParticle(Direction direction, Level worldIn, Location pos) {
        this((EntityType)DeferredRegisters.ENTITY_PARTICLE.get(), worldIn);
        this.m_146884_(new Vec3(pos.x(), pos.y(), pos.z()));
        this.direction = direction;
        this.f_19811_ = true;
        if (worldIn.f_46443_) {
            EntityParticle.m_20103_((double)4.0);
        }
    }

    public void m_8119_() {
        BlockEntity tile = this.f_19853_.m_7702_(this.source);
        if (!this.f_19853_.f_46443_) {
            if (!(tile instanceof TileParticleInjector)) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            ((TileParticleInjector)tile).addParticle(this);
            if (this.direction == null) {
                this.direction = Direction.UP;
            }
            this.f_19804_.m_135381_(DIRECTION, (Object)this.direction);
            this.f_19804_.m_135381_(SPEED, (Object)Float.valueOf(this.speed));
        } else if (!this.f_19804_.m_135388_()) {
            this.direction = (Direction)this.f_19804_.m_135370_(DIRECTION);
            this.speed = ((Float)this.f_19804_.m_135370_(SPEED)).floatValue();
        }
        Location source = new Location(this.m_142538_());
        double totstrength = 1000.0;
        double range = 1.0;
        AABB bb = AABB.m_165882_((Vec3)new Vec3(0.0, 0.0, 0.0), (double)range, (double)range, (double)range);
        bb = bb.m_82383_(new Vec3(source.x(), source.y(), source.z()));
        List list = this.f_19853_.m_45976_(LivingEntity.class, bb);
        for (LivingEntity living : list) {
            RadiationSystem.applyRadiation(living, source, totstrength);
        }
        if (this.direction != null && this.direction != Direction.UP) {
            int checks = (int)(Math.ceil(this.speed) * 2.0);
            float localSpeed = this.speed / (float)checks;
            for (int i = 0; i < checks; ++i) {
                BlockPos positionNow;
                if (!this.f_19853_.f_46443_) {
                    TileParticleInjector injector = (TileParticleInjector)tile;
                    injector.checkCollision();
                } else {
                    this.f_19853_.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 5.0f), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                }
                BlockPos next = this.m_142538_();
                BlockState oldState = this.f_19853_.m_8055_(next);
                boolean isBooster = false;
                if (oldState.m_60734_() == DeferredRegisters.blockElectromagneticBooster) {
                    Direction dir = ((Direction)oldState.m_61143_((Property)GenericEntityBlock.FACING)).m_122424_();
                    FacingDirection face = (FacingDirection)((Object)oldState.m_61143_((Property)BlockElectromagneticBooster.FACINGDIRECTION));
                    if (face == FacingDirection.RIGHT) {
                        dir = dir.m_122427_();
                    } else if (face == FacingDirection.LEFT) {
                        dir = dir.m_122428_();
                    }
                    if (dir == this.direction) {
                        this.speed = (float)((double)this.speed + 0.0033333333333333335);
                    } else if (dir == this.direction.m_122424_()) {
                        this.speed = (float)((double)this.speed - 0.02);
                    } else {
                        this.speed = (float)((double)this.speed + 0.0016666666666666668);
                        this.direction = dir;
                        Direction[] floor = this.m_142538_();
                        this.m_6034_((double)floor.m_123341_() + 0.5, (double)floor.m_123342_() + 0.5, (double)floor.m_123343_() + 0.5);
                    }
                    isBooster = true;
                }
                if (this.speed < 0.0f) {
                    this.speed *= -1.0f;
                    this.direction = this.direction.m_122424_();
                }
                this.m_6034_(this.m_20185_() + (double)((float)this.direction.m_122429_() * localSpeed), this.m_20186_(), this.m_20189_() + (double)((float)this.direction.m_122431_() * localSpeed));
                if (isBooster && this.f_19853_.m_8055_(positionNow = this.m_142538_()).m_60734_() == DeferredRegisters.blockElectromagneticSwitch) {
                    HashSet<Direction> directions = new HashSet<Direction>();
                    for (Direction dir : Direction.values()) {
                        if (dir == Direction.UP || dir == Direction.DOWN || dir == this.direction.m_122424_() || this.f_19853_.m_8055_(positionNow.m_142300_(dir)).m_60734_() != Blocks.f_50016_) continue;
                        directions.add(dir);
                    }
                    BlockEntity te = this.f_19853_.m_7702_(positionNow);
                    Object object = te;
                    if (object instanceof TileElectromagneticSwitch) {
                        TileElectromagneticSwitch switchte = (TileElectromagneticSwitch)((Object)object);
                        directions.remove(switchte.lastDirection);
                        if (directions.size() > (switchte.lastDirection == null ? 2 : 1)) {
                            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.speed, Explosion.BlockInteraction.DESTROY);
                            this.m_6089_();
                            break;
                        }
                        object = directions.iterator();
                        while (object.hasNext()) {
                            Direction dir;
                            switchte.lastDirection = dir = (Direction)object.next();
                            this.direction = dir;
                            this.m_6034_((double)positionNow.m_123341_() + 0.5, (double)positionNow.m_123342_() + 0.5, (double)positionNow.m_123343_() + 0.5);
                        }
                    }
                }
                if (this.f_19853_.f_46443_) continue;
                BlockPos getPos = this.m_142538_();
                BlockState nextState = this.f_19853_.m_8055_(getPos);
                if (nextState.m_60734_() == Blocks.f_50016_ || nextState.m_60734_() == DeferredRegisters.blockElectromagneticSwitch) {
                    int amount = 0;
                    for (Direction of : Direction.values()) {
                        if (!(this.f_19853_.m_8055_(this.m_142538_().m_142300_(of)).m_60734_() instanceof IElectromagnet)) continue;
                        ++amount;
                    }
                    if (amount < 4) {
                        this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.speed, Explosion.BlockInteraction.DESTROY);
                        this.m_6089_();
                        break;
                    }
                    BlockState testNextBlock = this.f_19853_.m_8055_(getPos.m_142300_(this.direction));
                    if (!(testNextBlock.m_60734_() instanceof IElectromagnet) || testNextBlock.m_60734_() == DeferredRegisters.blockElectromagneticSwitch) continue;
                    Direction checkRot = this.direction.m_122427_();
                    testNextBlock = this.f_19853_.m_8055_(getPos.m_142300_(checkRot));
                    if (testNextBlock.m_60734_() == Blocks.f_50016_ || testNextBlock.m_60734_() == DeferredRegisters.blockElectromagneticSwitch) {
                        BlockPos floor = this.m_142538_();
                        this.direction = checkRot;
                        this.m_6034_((double)floor.m_123341_() + 0.5, (double)floor.m_123342_() + 0.5, (double)floor.m_123343_() + 0.5);
                        continue;
                    }
                    checkRot = this.direction.m_122427_().m_122424_();
                    testNextBlock = this.f_19853_.m_8055_(getPos.m_142300_(checkRot));
                    if (testNextBlock.m_60734_() == Blocks.f_50016_ || testNextBlock.m_60734_() == DeferredRegisters.blockElectromagneticSwitch) {
                        BlockPos floor = this.m_142538_();
                        this.direction = checkRot;
                        this.m_6034_((double)floor.m_123341_() + 0.5, (double)floor.m_123342_() + 0.5, (double)floor.m_123343_() + 0.5);
                        continue;
                    }
                    this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.speed, Explosion.BlockInteraction.DESTROY);
                    this.m_6089_();
                    break;
                }
                boolean checkIsBooster = nextState.m_60734_() == DeferredRegisters.blockElectromagneticBooster && oldState.m_60734_() == DeferredRegisters.blockElectromagneticBooster;
                boolean explode = false;
                if (checkIsBooster) {
                    Direction nextDir;
                    Direction oldDir = (Direction)oldState.m_61143_((Property)GenericEntityBlock.FACING);
                    if (oldDir != (nextDir = (Direction)nextState.m_61143_((Property)GenericEntityBlock.FACING))) {
                        FacingDirection face = (FacingDirection)((Object)oldState.m_61143_((Property)BlockElectromagneticBooster.FACINGDIRECTION));
                        if (face == FacingDirection.RIGHT) {
                            oldDir = oldDir.m_122427_();
                        } else if (face == FacingDirection.LEFT) {
                            oldDir = oldDir.m_122428_();
                        }
                        if (oldDir != nextDir) {
                            explode = true;
                        }
                    }
                } else if (nextState.m_60734_() != DeferredRegisters.blockElectromagneticBooster) {
                    explode = true;
                }
                if (!explode) continue;
                this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.speed, Explosion.BlockInteraction.DESTROY);
                this.m_6089_();
                break;
            }
            this.speed = Math.min(this.speed, 1.999f);
        } else if (this.f_19797_ > 100) {
            this.m_6089_();
        }
    }

    protected void m_8097_() {
        if (this.direction == null) {
            this.direction = Direction.UP;
        }
        this.f_19804_.m_135372_(DIRECTION, (Object)this.direction);
        this.f_19804_.m_135372_(SPEED, (Object)Float.valueOf(this.speed));
    }

    public boolean m_20068_() {
        return true;
    }

    protected void m_7378_(CompoundTag compound) {
        this.source = new BlockPos(compound.m_128451_("sourceX"), compound.m_128451_("sourceY"), compound.m_128451_("sourceZ"));
    }

    public Component m_7755_() {
        return new TextComponent("entity.particle");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("sourceX", this.source.m_123341_());
        compound.m_128405_("sourceY", this.source.m_123342_());
        compound.m_128405_("sourceZ", this.source.m_123343_());
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

