/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.network;

import com.google.common.collect.Sets;
import electrodynamics.api.network.ITickableNetwork;
import electrodynamics.common.network.NetworkRegistry;
import electrodynamics.prefab.network.AbstractNetwork;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import nuclearscience.api.network.moltensalt.IMoltenSaltPipe;
import nuclearscience.common.block.subtype.SubtypeMoltenSaltPipe;
import nuclearscience.common.tile.TileHeatExchanger;

public class MoltenSaltNetwork
extends AbstractNetwork<IMoltenSaltPipe, SubtypeMoltenSaltPipe, BlockEntity, Double> {
    public MoltenSaltNetwork() {
        this(new HashSet());
    }

    public MoltenSaltNetwork(Collection<? extends IMoltenSaltPipe> varCables) {
        this.conductorSet.addAll(varCables);
        NetworkRegistry.register((ITickableNetwork)this);
    }

    public MoltenSaltNetwork(Set<AbstractNetwork<IMoltenSaltPipe, SubtypeMoltenSaltPipe, BlockEntity, Double>> networks) {
        for (AbstractNetwork<IMoltenSaltPipe, SubtypeMoltenSaltPipe, BlockEntity, Double> net : networks) {
            if (net == null) continue;
            this.conductorSet.addAll(net.conductorSet);
            net.deregister();
        }
        this.refresh();
        NetworkRegistry.register((ITickableNetwork)this);
    }

    public MoltenSaltNetwork(Set<MoltenSaltNetwork> networks, boolean special) {
        for (MoltenSaltNetwork net : networks) {
            if (net == null) continue;
            this.conductorSet.addAll(net.conductorSet);
            net.deregister();
        }
        this.refresh();
        NetworkRegistry.register((ITickableNetwork)this);
    }

    public Double emit(Double transfer, ArrayList<BlockEntity> ignored, boolean debug) {
        if (transfer > 0.0) {
            HashSet availableAcceptors = Sets.newHashSet((Iterable)this.acceptorSet);
            double heat = 0.0;
            availableAcceptors.removeAll(ignored);
            if (!availableAcceptors.isEmpty()) {
                double perReceiver = transfer / (double)availableAcceptors.size();
                for (BlockEntity receiver : availableAcceptors) {
                    if (!this.acceptorInputMap.containsKey(receiver)) continue;
                    Double rec = ((TileHeatExchanger)receiver).receiveHeat(perReceiver - (double)(this.getSize() * 5));
                    heat += rec.doubleValue();
                    this.transmittedThisTick += rec.doubleValue();
                    this.checkForOverload((int)this.transmittedThisTick);
                }
            }
            return heat;
        }
        return 0.0;
    }

    private boolean checkForOverload(int attemptSend) {
        if ((double)attemptSend >= this.networkMaxTransfer) {
            HashSet<SubtypeMoltenSaltPipe> checkList = new HashSet<SubtypeMoltenSaltPipe>();
            for (SubtypeMoltenSaltPipe type : SubtypeMoltenSaltPipe.values()) {
                if (type.maxTransfer > (long)attemptSend) continue;
                checkList.add(type);
            }
            for (SubtypeMoltenSaltPipe index : checkList) {
                for (IMoltenSaltPipe conductor : (HashSet)this.conductorTypeMap.get((Object)index)) {
                    conductor.destroyViolently();
                }
            }
            return true;
        }
        return false;
    }

    public boolean isConductor(BlockEntity tile) {
        return tile instanceof IMoltenSaltPipe;
    }

    public boolean isAcceptor(BlockEntity acceptor, Direction orientation) {
        return acceptor instanceof TileHeatExchanger || this.isConductor(acceptor);
    }

    public AbstractNetwork<IMoltenSaltPipe, SubtypeMoltenSaltPipe, BlockEntity, Double> createInstance() {
        return new MoltenSaltNetwork();
    }

    public AbstractNetwork<IMoltenSaltPipe, SubtypeMoltenSaltPipe, BlockEntity, Double> createInstanceConductor(Set<IMoltenSaltPipe> conductors) {
        return new MoltenSaltNetwork((Collection<? extends IMoltenSaltPipe>)conductors);
    }

    public AbstractNetwork<IMoltenSaltPipe, SubtypeMoltenSaltPipe, BlockEntity, Double> createInstance(Set<AbstractNetwork<IMoltenSaltPipe, SubtypeMoltenSaltPipe, BlockEntity, Double>> networks) {
        return new MoltenSaltNetwork(networks);
    }

    public SubtypeMoltenSaltPipe[] getConductorTypes() {
        return SubtypeMoltenSaltPipe.values();
    }

    public boolean canConnect(BlockEntity acceptor, Direction orientation) {
        return acceptor instanceof TileHeatExchanger && orientation == Direction.UP || this.isConductor(acceptor);
    }
}

