/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.packet;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import nuclearscience.common.tile.TileQuantumCapacitor;

public class PacketSetQuantumCapacitorData {
    private final double outputJoules;
    private final int frequency;
    private final BlockPos pos;

    public PacketSetQuantumCapacitorData(BlockPos pos, double outputJoules, int frequency) {
        this.pos = pos;
        this.outputJoules = outputJoules;
        this.frequency = frequency;
    }

    public static void handle(PacketSetQuantumCapacitorData message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            TileQuantumCapacitor tile;
            ServerLevel world = ((NetworkEvent.Context)context.get()).getSender().m_9236_();
            if (world != null && (tile = (TileQuantumCapacitor)world.m_7702_(message.pos)) != null) {
                tile.outputJoules = message.outputJoules;
                tile.frequency = message.frequency;
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketSetQuantumCapacitorData pkt, FriendlyByteBuf buf) {
        buf.m_130064_(pkt.pos);
        buf.writeDouble(pkt.outputJoules);
        buf.writeInt(pkt.frequency);
    }

    public static PacketSetQuantumCapacitorData decode(FriendlyByteBuf buf) {
        return new PacketSetQuantumCapacitorData(buf.m_130135_(), buf.readDouble(), buf.readInt());
    }
}

