/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.ComponentType;
import electrodynamics.prefab.tile.components.type.ComponentElectrodynamic;
import electrodynamics.prefab.tile.components.type.ComponentPacketHandler;
import electrodynamics.prefab.tile.components.type.ComponentTickable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import nuclearscience.DeferredRegisters;
import nuclearscience.common.settings.Constants;
import nuclearscience.common.tile.TilePlasma;

public class TileFusionReactorCore
extends GenericTile {
    public int deuterium;
    public int tritium;
    private int timeLeft = 0;

    public TileFusionReactorCore(BlockPos pos, BlockState state) {
        super((BlockEntityType)DeferredRegisters.TILE_FUSIONREACTORCORE.get(), pos, state);
        this.addComponent((Component)new ComponentTickable().tickServer(this::tickServer));
        this.addComponent((Component)new ComponentPacketHandler().customPacketReader(this::readCustomPacket).customPacketWriter(this::writeCustomPacket));
        this.addComponent((Component)new ComponentElectrodynamic((GenericTile)this).input(Direction.DOWN).input(Direction.UP).maxJoules(Constants.FUSIONREACTOR_USAGE_PER_TICK * 20.0).voltage(480.0));
    }

    public void tickServer(ComponentTickable tick) {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(ComponentType.Electrodynamic);
        if (this.f_58857_.m_6106_().m_6792_() % 20L == 0L) {
            ((ComponentPacketHandler)this.getComponent(ComponentType.PacketHandler)).sendCustomPacket();
        }
        if (this.tritium > 0 && this.deuterium > 0 && this.timeLeft <= 0 && electro.getJoulesStored() > Constants.FUSIONREACTOR_USAGE_PER_TICK) {
            --this.deuterium;
            --this.tritium;
            this.timeLeft = 300;
        }
        if (this.timeLeft > 0 && electro.getJoulesStored() > Constants.FUSIONREACTOR_USAGE_PER_TICK) {
            for (Direction dir : Direction.values()) {
                if (dir == Direction.UP || dir == Direction.DOWN) continue;
                BlockPos offset = this.f_58858_.m_142300_(dir);
                BlockState state = this.f_58857_.m_8055_(offset);
                if (state.m_60734_() == DeferredRegisters.blockPlasma) {
                    BlockEntity tile = this.f_58857_.m_7702_(offset);
                    BlockEntity blockEntity = tile;
                    if (!(blockEntity instanceof TilePlasma)) continue;
                    TilePlasma plasma = (TilePlasma)blockEntity;
                    if (plasma.ticksExisted <= 30) continue;
                    plasma.ticksExisted = 0;
                    continue;
                }
                if (state.m_60734_() != Blocks.f_50016_) continue;
                this.f_58857_.m_46597_(offset, DeferredRegisters.blockPlasma.m_49966_());
            }
            electro.joules(electro.getJoulesStored() - Constants.FUSIONREACTOR_USAGE_PER_TICK);
        }
        --this.timeLeft;
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        this.writeCustomPacket(compound);
        return super.m_6945_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.readCustomPacket(compound);
    }

    public void writeCustomPacket(CompoundTag nbt) {
        nbt.m_128405_("deuterium", this.deuterium);
        nbt.m_128405_("tritium", this.tritium);
    }

    public void readCustomPacket(CompoundTag nbt) {
        this.deuterium = nbt.m_128451_("deuterium");
        this.tritium = nbt.m_128451_("tritium");
    }
}

