/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.api.sound.SoundAPI;
import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.ComponentType;
import electrodynamics.prefab.tile.components.type.ComponentContainerProvider;
import electrodynamics.prefab.tile.components.type.ComponentDirection;
import electrodynamics.prefab.tile.components.type.ComponentElectrodynamic;
import electrodynamics.prefab.tile.components.type.ComponentFluidHandlerMulti;
import electrodynamics.prefab.tile.components.type.ComponentInventory;
import electrodynamics.prefab.tile.components.type.ComponentPacketHandler;
import electrodynamics.prefab.tile.components.type.ComponentProcessor;
import electrodynamics.prefab.tile.components.type.ComponentTickable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import nuclearscience.DeferredRegisters;
import nuclearscience.SoundRegister;
import nuclearscience.common.inventory.container.ContainerGasCentrifuge;
import nuclearscience.common.settings.Constants;
import nuclearscience.common.tags.NuclearScienceTags;

public class TileGasCentrifuge
extends GenericTile {
    public static final int TANKCAPACITY = 5000;
    public static final float REQUIRED = 2500.0f;
    public int stored235 = 0;
    public int stored238 = 0;
    public int spinSpeed;
    private static int inputSlots = 0;
    private static int outputSize = 2;
    private static int itemBiSize = 0;
    private static int inputBucketSlots = 0;
    private static int outputBucketSlots = 0;
    private static int upgradeSlots = 3;
    private static int invSize = inputSlots + outputSize + inputBucketSlots + outputBucketSlots + upgradeSlots + itemBiSize;

    public TileGasCentrifuge(BlockPos pos, BlockState state) {
        super((BlockEntityType)DeferredRegisters.TILE_GASCENTRIFUGE.get(), pos, state);
        this.addComponent((Component)new ComponentTickable().tickClient(this::tickClient));
        this.addComponent((Component)new ComponentDirection());
        this.addComponent((Component)new ComponentPacketHandler().customPacketReader(this::readCustomPacket).customPacketWriter(this::writeCustomPacket));
        this.addComponent((Component)new ComponentFluidHandlerMulti((GenericTile)this).setManualFluidTags(1, true, 5000, new Tags.IOptionalNamedTag[]{NuclearScienceTags.Fluids.URANIUM_HEXAFLUORIDE}).relativeInput(new Direction[]{Direction.NORTH}));
        this.addComponent((Component)new ComponentElectrodynamic((GenericTile)this).voltage(240.0).input(Direction.DOWN).maxJoules(Constants.GASCENTRIFUGE_USAGE_PER_TICK * 10.0));
        this.addComponent((Component)new ComponentInventory((GenericTile)this).size(invSize).faceSlots(Direction.DOWN, new Integer[]{0, 1}).relativeFaceSlots(Direction.WEST, new Integer[]{0, 1}).valid(TileGasCentrifuge.getPredicate((int)inputSlots, (int)outputSize, (int)itemBiSize, (int)(inputBucketSlots + outputBucketSlots), (int)upgradeSlots, (int)invSize)));
        this.addComponent((Component)new ComponentProcessor((GenericTile)this).usage(Constants.GASCENTRIFUGE_USAGE_PER_TICK).requiredTicks((long)Constants.GASCENTRIFUGE_REQUIRED_TICKS_PER_PROCESSING).canProcess(this::canProcess).process(this::process));
        this.addComponent((Component)new ComponentContainerProvider("container.gascentrifuge").createMenu((id, player) -> new ContainerGasCentrifuge((int)id, (Inventory)player, (Container)this.getComponent(ComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    public boolean canProcess(ComponentProcessor processor) {
        boolean val;
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(ComponentType.Electrodynamic);
        ComponentInventory inv = (ComponentInventory)this.getComponent(ComponentType.Inventory);
        ComponentFluidHandlerMulti tank = (ComponentFluidHandlerMulti)this.getComponent(ComponentType.FluidHandler);
        boolean hasFluid = (double)tank.getInputTanks()[0].getFluidAmount() >= 41.666666666666664;
        boolean bl = val = electro.getJoulesStored() >= processor.getUsage() && hasFluid && inv.m_8020_(0).m_41613_() < inv.m_8020_(0).m_41741_() && inv.m_8020_(1).m_41613_() < inv.m_8020_(1).m_41741_();
        if (!val && this.spinSpeed > 0) {
            this.spinSpeed = 0;
            ((ComponentPacketHandler)this.getComponent(ComponentType.PacketHandler)).sendCustomPacket();
        }
        return val;
    }

    public void process(ComponentProcessor processor) {
        ItemStack stack;
        ComponentInventory inv = (ComponentInventory)this.getComponent(ComponentType.Inventory);
        ComponentFluidHandlerMulti tank = (ComponentFluidHandlerMulti)this.getComponent(ComponentType.FluidHandler);
        this.spinSpeed = (int)processor.operatingSpeed;
        ((ComponentPacketHandler)this.getComponent(ComponentType.PacketHandler)).sendCustomPacket();
        int processed = 41;
        for (Fluid fluid : NuclearScienceTags.Fluids.URANIUM_HEXAFLUORIDE.m_6497_()) {
            FluidTank fTank = tank.getTankFromFluid(fluid, true);
            if (fTank.getFluidAmount() < processed) continue;
            fTank.getFluid().shrink(processed);
            break;
        }
        this.stored235 = (int)((double)this.stored235 + (double)processed * 0.172);
        this.stored238 = (int)((double)this.stored238 + (double)processed * 0.8280000000000001);
        if ((float)this.stored235 > 2500.0f) {
            stack = inv.m_8020_(0);
            if (!stack.m_41619_()) {
                stack.m_41764_(stack.m_41613_() + 1);
            } else {
                inv.m_6836_(0, new ItemStack((ItemLike)DeferredRegisters.ITEM_URANIUM235.get()));
            }
            this.stored235 -= 2500;
        }
        if ((float)this.stored238 > 2500.0f) {
            stack = inv.m_8020_(1);
            if (!stack.m_41619_()) {
                stack.m_41764_(stack.m_41613_() + 1);
            } else {
                inv.m_6836_(1, new ItemStack((ItemLike)DeferredRegisters.ITEM_URANIUM238.get()));
            }
            this.stored238 -= 2500;
        }
    }

    protected void tickClient(ComponentTickable tickable) {
        if (this.spinSpeed > 0 && tickable.getTicks() % 80L == 0L) {
            SoundAPI.playSound((SoundEvent)((SoundEvent)SoundRegister.SOUND_GASCENTRIFUGE.get()), (SoundSource)SoundSource.BLOCKS, (float)1.0f, (float)1.0f, (BlockPos)this.f_58858_);
        }
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        compound.m_128405_("stored235", this.stored235);
        compound.m_128405_("stored238", this.stored238);
        return super.m_6945_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.stored235 = compound.m_128451_("stored235");
        this.stored238 = compound.m_128451_("stored238");
    }

    public void writeCustomPacket(CompoundTag tag) {
        tag.m_128405_("spinSpeed", this.spinSpeed);
        tag.m_128405_("stored235", this.stored235);
        tag.m_128405_("stored238", this.stored238);
    }

    public void readCustomPacket(CompoundTag nbt) {
        this.spinSpeed = nbt.m_128451_("spinSpeed");
        this.stored235 = nbt.m_128451_("stored235");
        this.stored238 = nbt.m_128451_("stored238");
    }
}

