/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.ComponentType;
import electrodynamics.prefab.tile.components.type.ComponentPacketHandler;
import electrodynamics.prefab.tile.components.type.ComponentTickable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import nuclearscience.DeferredRegisters;
import nuclearscience.common.settings.Constants;
import nuclearscience.common.tile.TileTurbine;

public class TileHeatExchanger
extends GenericTile {
    public static final int STEAM_GEN_DIAMETER = 5;
    public static final int STEAM_GEN_HEIGHT = 2;
    private TileTurbine[][][] cachedTurbines = new TileTurbine[5][2][5];
    private double temperature;

    public TileHeatExchanger(BlockPos pos, BlockState state) {
        super((BlockEntityType)DeferredRegisters.TILE_HEATEXCHANGER.get(), pos, state);
        this.addComponent((Component)new ComponentTickable().tickCommon(this::tickCommon).tickServer(this::tickServer));
        this.addComponent((Component)new ComponentPacketHandler().customPacketReader(this::readCustomPacket).customPacketWriter(this::writeCustomPacket).guiPacketReader(this::readCustomPacket).guiPacketWriter(this::writeCustomPacket));
    }

    protected void tickServer(ComponentTickable tickable) {
        if (tickable.getTicks() % 10L == 0L) {
            ((ComponentPacketHandler)this.getComponent(ComponentType.PacketHandler)).sendCustomPacket();
        }
    }

    protected void tickCommon(ComponentTickable tickable) {
        if (this.temperature > 100.0) {
            this.produceSteam();
        }
        this.temperature *= 0.9;
    }

    protected void produceSteam() {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 5; ++k) {
                    boolean isFaceWater;
                    int offsetZ;
                    int offsetY;
                    boolean isReactor2d;
                    boolean bl = isReactor2d = i - 2 == 0 && k - 2 == 0;
                    if (isReactor2d && j == 0) {
                        if (this.f_58857_.f_46443_ || !((double)this.f_58857_.f_46441_.nextFloat() < this.temperature / 900000.0) || !this.f_58857_.m_8055_(this.f_58858_).m_61138_((Property)BlockStateProperties.f_61362_)) continue;
                        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
                        continue;
                    }
                    int offsetX = this.f_58858_.m_123341_() + i - 2;
                    BlockPos offpos = new BlockPos(offsetX, offsetY = this.f_58858_.m_123342_() + j, offsetZ = this.f_58858_.m_123343_() + k - 2);
                    Block offset = this.f_58857_.m_8055_(offpos).m_60734_();
                    if (offset != Blocks.f_49990_) continue;
                    boolean bl2 = isFaceWater = this.f_58857_.m_8055_(new BlockPos(offsetX, this.f_58858_.m_123342_(), this.f_58858_.m_123343_())).m_60734_() == Blocks.f_49990_ || this.f_58857_.m_8055_(new BlockPos(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), offsetZ)).m_60734_() == Blocks.f_49990_ || isReactor2d;
                    if (!isFaceWater) continue;
                    if (!this.f_58857_.f_46443_) {
                        TileTurbine turbine = this.cachedTurbines[i][j][k];
                        if (turbine != null) {
                            if (turbine.m_58901_()) {
                                this.cachedTurbines[i][j][k] = null;
                            }
                            turbine.addSteam((int)(Constants.MSRREACTOR_MAXENERGYTARGET / (500.0 * (900.0 / this.temperature))), (int)this.temperature);
                        }
                        if ((double)this.f_58857_.f_46441_.nextFloat() < this.temperature / 900000.0) {
                            this.f_58857_.m_46597_(offpos, Blocks.f_50016_.m_49966_());
                            continue;
                        }
                        if (turbine != null && !turbine.m_58901_()) continue;
                        BlockEntity above = this.f_58857_.m_7702_(new BlockPos(offsetX, offsetY + 1, offsetZ));
                        BlockEntity blockEntity = above;
                        if (blockEntity instanceof TileTurbine) {
                            TileTurbine ab;
                            this.cachedTurbines[i][j][k] = ab = (TileTurbine)blockEntity;
                            continue;
                        }
                        this.cachedTurbines[i][j][k] = null;
                        continue;
                    }
                    if (!this.f_58857_.f_46443_ || !((double)this.f_58857_.f_46441_.nextFloat() < this.temperature / 2700.0)) continue;
                    double offsetFX = (double)offsetX + this.f_58857_.f_46441_.nextDouble() / 2.0 * (double)(this.f_58857_.f_46441_.nextBoolean() ? -1 : 1);
                    double offsetFY = (double)offsetY + this.f_58857_.f_46441_.nextDouble() / 2.0 * (double)(this.f_58857_.f_46441_.nextBoolean() ? -1 : 1);
                    double offsetFZ = (double)offsetZ + this.f_58857_.f_46441_.nextDouble() / 2.0 * (double)(this.f_58857_.f_46441_.nextBoolean() ? -1 : 1);
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, offsetFX + 0.5, offsetFY + (double)0.2f, offsetFZ + 0.5, 0.0, 0.0, 0.0);
                    if (this.f_58857_.f_46441_.nextInt(3) != 0) continue;
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, offsetFX + 0.5, offsetFY + 0.5, offsetFZ + 0.5, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    protected void writeCustomPacket(CompoundTag tag) {
        tag.m_128347_("temperature", this.temperature);
    }

    protected void readCustomPacket(CompoundTag nbt) {
        this.temperature = nbt.m_128459_("temperature");
    }

    public Double receiveHeat(Double perReceiver) {
        this.temperature = perReceiver;
        return perReceiver;
    }
}

