/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.ComponentType;
import electrodynamics.prefab.tile.components.type.ComponentContainerProvider;
import electrodynamics.prefab.tile.components.type.ComponentDirection;
import electrodynamics.prefab.tile.components.type.ComponentPacketHandler;
import electrodynamics.prefab.tile.components.type.ComponentTickable;
import electrodynamics.prefab.utilities.object.CachedTileOutput;
import electrodynamics.prefab.utilities.object.Location;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import nuclearscience.DeferredRegisters;
import nuclearscience.api.network.moltensalt.IMoltenSaltPipe;
import nuclearscience.api.radiation.RadiationSystem;
import nuclearscience.common.inventory.container.ContainerMSRReactorCore;
import nuclearscience.common.network.MoltenSaltNetwork;
import nuclearscience.common.tile.TileControlRodAssembly;
import nuclearscience.common.tile.TileFreezePlug;

public class TileMSRReactorCore
extends GenericTile {
    public static final int MELTDOWN_TEMPERATURE = 900;
    public static final double FUEL_CAPACITY = 1000.0;
    public static final double FUEL_USAGE_RATE = 0.01;
    public double temperature = 15.0;
    public int ticksOverheating = 0;
    public double currentFuel = 0.0;
    private CachedTileOutput outputCache;
    public CachedTileOutput plugCache;

    public TileMSRReactorCore(BlockPos pos, BlockState state) {
        super((BlockEntityType)DeferredRegisters.TILE_MSRREACTORCORE.get(), pos, state);
        this.addComponent((Component)new ComponentDirection());
        this.addComponent((Component)new ComponentTickable().tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((Component)new ComponentPacketHandler().customPacketReader(this::readCustomPacket).customPacketWriter(this::writeCustomPacket).guiPacketReader(this::readCustomPacket).guiPacketWriter(this::writeCustomPacket));
        this.addComponent((Component)new ComponentContainerProvider("container.msrreactorcore").createMenu((id, player) -> new ContainerMSRReactorCore((int)id, (Inventory)player, null, (ContainerData)this.getCoordsArray())));
    }

    protected void writeCustomPacket(CompoundTag tag) {
        tag.m_128347_("temperature", this.temperature);
        tag.m_128347_("currentFuel", this.currentFuel);
    }

    protected void readCustomPacket(CompoundTag nbt) {
        this.temperature = nbt.m_128459_("temperature");
        this.currentFuel = nbt.m_128459_("currentFuel");
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        this.writeCustomPacket(compound);
        return super.m_6945_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        this.readCustomPacket(compound);
        super.m_142466_(compound);
    }

    protected void tickServer(ComponentTickable tick) {
        TileFreezePlug freeze;
        Object object;
        double change;
        if (this.outputCache == null) {
            this.outputCache = new CachedTileOutput(this.f_58857_, new BlockPos((Vec3i)this.f_58858_).m_142300_(Direction.UP));
        }
        if (this.plugCache == null) {
            this.plugCache = new CachedTileOutput(this.f_58857_, new BlockPos((Vec3i)this.f_58858_).m_142300_(Direction.DOWN));
        }
        if (tick.getTicks() % 40L == 0L) {
            this.outputCache.update();
            this.plugCache.update();
        }
        if ((change = (this.temperature - 15.0) / 3000.0 + (this.temperature - 15.0) / 5000.0) != 0.0) {
            this.temperature -= change < 0.001 && change > 0.0 ? 0.001 : (change > -0.001 && change < 0.0 ? -0.001 : change);
        }
        if (this.plugCache.valid() && (object = this.plugCache.getSafe()) instanceof TileFreezePlug && (freeze = (TileFreezePlug)((Object)object)).isFrozen() && this.currentFuel > 0.01) {
            int insertion = 0;
            for (Direction dir : Direction.values()) {
                TileControlRodAssembly cr;
                BlockEntity tile;
                BlockEntity blockEntity;
                if (dir == Direction.UP || dir == Direction.DOWN || !((blockEntity = (tile = this.f_58857_.m_7702_(this.m_58899_().m_142300_(dir)))) instanceof TileControlRodAssembly)) continue;
                TileControlRodAssembly control = cr = (TileControlRodAssembly)blockEntity;
                if (control.direction != dir.m_122424_()) continue;
                insertion += control.insertion;
            }
            if (this.f_58857_.m_6106_().m_6793_() % 10L == 0L) {
                Location source = new Location((double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 0.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f));
                double totstrength = this.temperature * Math.pow(3.0, Math.pow(this.temperature / 900.0, 9.0));
                double range = Math.sqrt(totstrength) / (5.0 * Math.sqrt(2.0)) * 2.0;
                AABB bb = AABB.m_165882_((Vec3)new Vec3(source.x(), source.y(), source.z()), (double)range, (double)range, (double)range);
                List list = this.f_58857_.m_45976_(LivingEntity.class, bb);
                for (LivingEntity living : list) {
                    RadiationSystem.applyRadiation(living, source, totstrength);
                }
            }
            double insertDecimal = (double)(100 - insertion) / 100.0;
            this.currentFuel -= Math.min(this.currentFuel, 0.01 * insertDecimal * Math.pow(2.0, Math.pow(this.temperature / 800.0, 4.0)));
            this.temperature += (900.0 * insertDecimal * (1.2 + this.f_58857_.f_46441_.nextDouble() / 5.0) - this.temperature) / 200.0;
            if (this.outputCache.valid() && this.outputCache.getSafe() instanceof IMoltenSaltPipe) {
                MoltenSaltNetwork net = (MoltenSaltNetwork)((IMoltenSaltPipe)this.outputCache.getSafe()).getNetwork();
                net.emit(this.temperature, new ArrayList<BlockEntity>(), false);
            }
        }
        if (tick.getTicks() % 5L == 0L) {
            ((ComponentPacketHandler)this.getComponent(ComponentType.PacketHandler)).sendGuiPacketToTracking();
        }
    }

    protected void tickClient(ComponentTickable tick) {
        if (this.plugCache == null) {
            this.plugCache = new CachedTileOutput(this.f_58857_, new BlockPos((Vec3i)this.f_58858_).m_142300_(Direction.DOWN));
        }
    }
}

