/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.type.ComponentTickable;
import electrodynamics.prefab.utilities.object.Location;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import nuclearscience.DeferredRegisters;
import nuclearscience.api.radiation.RadiationSystem;

public class TileMeltedReactor
extends GenericTile {
    public static final float RADIATION_RADIUS = 30.0f;
    public static final float START_RADIATION = 4.383E7f;
    public int radiation = 43830000;
    public int temperature = 6000;

    public TileMeltedReactor(BlockPos pos, BlockState state) {
        super((BlockEntityType)DeferredRegisters.TILE_MELTEDREACTOR.get(), pos, state);
        this.addComponent((Component)new ComponentTickable().tickServer(this::tickServer));
    }

    protected void tickServer(ComponentTickable tickable) {
        Block block;
        BlockState st;
        BlockPos p;
        double distanceSq;
        double d5;
        double d4;
        double d3;
        double z2;
        double y2;
        BlockState state;
        long ticks = tickable.getTicks();
        if (ticks % 3L == 0L && ((state = this.f_58857_.m_8055_(this.f_58858_.m_7495_())).m_60767_() == Material.f_76296_ || state.m_60734_() instanceof LiquidBlock)) {
            BlockEntity tile;
            this.f_58857_.m_46597_(this.f_58858_.m_7495_(), this.m_58900_());
            this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50016_.m_49966_());
            BlockEntity blockEntity = tile = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
            if (blockEntity instanceof TileMeltedReactor) {
                TileMeltedReactor newTile = (TileMeltedReactor)blockEntity;
                newTile.radiation = this.radiation;
                newTile.radiation = this.radiation;
            }
            return;
        }
        if (this.temperature > 0) {
            --this.temperature;
            double x2 = (double)this.f_58858_.m_123341_() + 0.5 + (this.f_58857_.f_46441_.nextDouble() - 0.5) * 30.0 / 2.0;
            y2 = (double)this.f_58858_.m_123342_() + 0.5 + (this.f_58857_.f_46441_.nextDouble() - 0.5) * 30.0 / 2.0;
            z2 = (double)this.f_58858_.m_123343_() + 0.5 + (this.f_58857_.f_46441_.nextDouble() - 0.5) * 30.0 / 2.0;
            d3 = (double)this.f_58858_.m_123341_() - x2;
            distanceSq = d3 * d3 + (d4 = (double)this.f_58858_.m_123342_() - y2) * d4 + (d5 = (double)this.f_58858_.m_123343_() - z2) * d5;
            if (distanceSq < 900.0 && this.f_58857_.f_46441_.nextDouble() > distanceSq / 900.0) {
                p = new BlockPos(Math.floor(x2), Math.floor(y2), Math.floor(z2));
                st = this.f_58857_.m_8055_(p);
                block = st.m_60734_();
                if (st.m_60767_() == Material.f_76296_) {
                    if (this.f_58857_.m_8055_(p.m_7495_()).m_60767_() != Material.f_76296_) {
                        this.f_58857_.m_46597_(p, Blocks.f_50016_.m_49966_());
                    }
                } else if (block == Blocks.f_50069_) {
                    if (this.temperature > 2100) {
                        this.f_58857_.m_46597_(p, Blocks.f_50652_.m_49966_());
                    }
                } else if (block == Blocks.f_50652_) {
                    this.f_58857_.m_46597_(p, Blocks.f_49991_.m_49966_());
                } else if (block == Blocks.f_49990_) {
                    this.f_58857_.m_46597_(p, Blocks.f_50016_.m_49966_());
                } else if (block == Blocks.f_49992_) {
                    this.f_58857_.m_46597_(p, Blocks.f_50058_.m_49966_());
                }
            }
        }
        if (this.radiation > 0) {
            --this.radiation;
            double x2 = (double)this.f_58858_.m_123341_() + 0.5 + (this.f_58857_.f_46441_.nextDouble() - 0.5) * 30.0 / 2.0;
            y2 = (double)this.f_58858_.m_123342_() + 0.5 + (this.f_58857_.f_46441_.nextDouble() - 0.5) * 30.0 / 2.0;
            z2 = (double)this.f_58858_.m_123343_() + 0.5 + (this.f_58857_.f_46441_.nextDouble() - 0.5) * 30.0 / 2.0;
            d3 = (double)this.f_58858_.m_123341_() - x2;
            distanceSq = d3 * d3 + (d4 = (double)this.f_58858_.m_123342_() - y2) * d4 + (d5 = (double)this.f_58858_.m_123343_() - z2) * d5;
            if (distanceSq < 900.0 && this.f_58857_.f_46441_.nextDouble() > distanceSq / 900.0 && ((block = (st = this.f_58857_.m_8055_(p = new BlockPos(Math.floor(x2), Math.floor(y2), Math.floor(z2)))).m_60734_()) == Blocks.f_50440_ || block == Blocks.f_50493_)) {
                this.f_58857_.m_46597_(p, DeferredRegisters.blockRadioactiveSoil.m_49966_());
            }
        }
        if (this.f_58857_.m_6106_().m_6793_() % 10L == 0L) {
            Location source = new Location((double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 0.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f));
            double totstrength = 120000.0f * ((float)this.radiation / 4.383E7f);
            double range = Math.sqrt(totstrength) / (5.0 * Math.sqrt(2.0)) * 2.0;
            AABB bb = AABB.m_165882_((Vec3)new Vec3(source.x(), source.y(), source.z()), (double)range, (double)range, (double)range);
            List list = this.f_58857_.m_45976_(LivingEntity.class, bb);
            for (LivingEntity living : list) {
                RadiationSystem.applyRadiation(living, source, totstrength);
            }
        }
    }
}

