/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.ComponentType;
import electrodynamics.prefab.tile.components.type.ComponentContainerProvider;
import electrodynamics.prefab.tile.components.type.ComponentDirection;
import electrodynamics.prefab.tile.components.type.ComponentElectrodynamic;
import electrodynamics.prefab.tile.components.type.ComponentInventory;
import electrodynamics.prefab.tile.components.type.ComponentPacketHandler;
import electrodynamics.prefab.tile.components.type.ComponentTickable;
import electrodynamics.prefab.utilities.object.CachedTileOutput;
import electrodynamics.prefab.utilities.object.TransferPack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import nuclearscience.DeferredRegisters;
import nuclearscience.common.inventory.container.ContainerMoltenSaltSupplier;
import nuclearscience.common.settings.Constants;
import nuclearscience.common.tile.TileMSRReactorCore;

public class TileMoltenSaltSupplier
extends GenericTile {
    protected CachedTileOutput output;

    public TileMoltenSaltSupplier(BlockPos pos, BlockState state) {
        super((BlockEntityType)DeferredRegisters.TILE_MOLTENSALTSUPPLIER.get(), pos, state);
        this.addComponent((Component)new ComponentDirection());
        this.addComponent((Component)new ComponentTickable().tickServer(this::tickServer));
        this.addComponent((Component)new ComponentPacketHandler());
        this.addComponent((Component)new ComponentElectrodynamic((GenericTile)this).voltage(Constants.MOLTENSALTSUPPLIER_VOLTAGE).extractPower((x, y) -> TransferPack.EMPTY).output(Direction.UP).output(Direction.DOWN).maxJoules(Constants.MOLTENSALTSUPPLIER_USAGE_PER_TICK * 20.0));
        this.addComponent((Component)new ComponentInventory((GenericTile)this).size(1).slotFaces(Integer.valueOf(0), Direction.values()).valid((slot, stack) -> stack.m_41720_() == DeferredRegisters.ITEM_LIFHT4PUF3.get()));
        this.addComponent((Component)new ComponentContainerProvider("container.moltensaltsupplier").createMenu((id, player) -> new ContainerMoltenSaltSupplier((int)id, (Inventory)player, (Container)this.getComponent(ComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    public void tickServer(ComponentTickable tickable) {
        ComponentElectrodynamic electro;
        Direction dir = ((ComponentDirection)this.getComponent(ComponentType.Direction)).getDirection();
        if (this.output == null) {
            this.output = new CachedTileOutput(this.f_58857_, this.f_58858_.m_142300_(dir.m_122424_()));
        }
        if (tickable.getTicks() % 50L == 0L) {
            ((ComponentPacketHandler)this.getComponent(ComponentType.PacketHandler)).sendGuiPacketToTracking();
        }
        if ((electro = (ComponentElectrodynamic)this.getComponent(ComponentType.Electrodynamic)).getJoulesStored() > Constants.MOLTENSALTSUPPLIER_USAGE_PER_TICK) {
            electro.extractPower(TransferPack.joulesVoltage((double)Constants.MOLTENSALTSUPPLIER_USAGE_PER_TICK, (double)Constants.MOLTENSALTSUPPLIER_VOLTAGE), false);
            if (tickable.getTicks() % 40L == 0L) {
                TileMSRReactorCore core;
                Object object;
                this.output.update();
                ItemStack in = ((ComponentInventory)this.getComponent(ComponentType.Inventory)).m_8020_(0);
                if (in.m_41613_() > 0 && this.output.valid() && (object = this.output.getSafe()) instanceof TileMSRReactorCore && ((ComponentDirection)(core = (TileMSRReactorCore)((Object)object)).getComponent(ComponentType.Direction)).getDirection() == dir && 1000.0 - core.currentFuel >= 250.0) {
                    in.m_41774_(1);
                    core.currentFuel += 250.0;
                }
            }
        }
    }
}

