/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.ComponentType;
import electrodynamics.prefab.tile.components.type.ComponentContainerProvider;
import electrodynamics.prefab.tile.components.type.ComponentDirection;
import electrodynamics.prefab.tile.components.type.ComponentElectrodynamic;
import electrodynamics.prefab.tile.components.type.ComponentInventory;
import electrodynamics.prefab.tile.components.type.ComponentPacketHandler;
import electrodynamics.prefab.tile.components.type.ComponentProcessor;
import electrodynamics.prefab.tile.components.type.ComponentTickable;
import electrodynamics.prefab.utilities.object.Location;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import nuclearscience.DeferredRegisters;
import nuclearscience.common.entity.EntityParticle;
import nuclearscience.common.inventory.container.ContainerParticleInjector;
import nuclearscience.common.settings.Constants;

public class TileParticleInjector
extends GenericTile {
    private EntityParticle[] particles = new EntityParticle[2];
    private long timeSinceSpawn = 0L;

    public TileParticleInjector(BlockPos pos, BlockState state) {
        super((BlockEntityType)DeferredRegisters.TILE_PARTICLEINJECTOR.get(), pos, state);
        this.addComponent((Component)new ComponentTickable());
        this.addComponent((Component)new ComponentDirection());
        this.addComponent((Component)new ComponentPacketHandler());
        this.addComponent((Component)new ComponentInventory((GenericTile)this).size(3).valid((index, stack) -> index != 1 || stack.m_41720_() == DeferredRegisters.ITEM_CELLELECTROMAGNETIC.get()).relativeFaceSlots(Direction.UP, new Integer[]{0, 1}).relativeFaceSlots(Direction.WEST, new Integer[]{0, 1}).relativeSlotFaces(Integer.valueOf(2), new Direction[]{Direction.DOWN, Direction.EAST}));
        this.addComponent((Component)new ComponentElectrodynamic((GenericTile)this).voltage(960.0).relativeInput(Direction.NORTH).maxJoules(Constants.PARTICLEINJECTOR_USAGE_PER_PARTICLE * 10.0));
        this.addComponent((Component)new ComponentProcessor((GenericTile)this).canProcess(this::canProcess).usage(Constants.PARTICLEINJECTOR_USAGE_PER_PARTICLE).process(this::process));
        this.addComponent((Component)new ComponentContainerProvider("container.particleinjector").createMenu((id, player) -> new ContainerParticleInjector((int)id, (Inventory)player, (Container)this.getComponent(ComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    protected boolean canProcess(ComponentProcessor processor) {
        if (this.particles[0] != null && !this.particles[0].m_6084_()) {
            this.particles[0] = null;
        }
        if (this.particles[1] != null && !this.particles[1].m_6084_()) {
            this.particles[1] = null;
        }
        ComponentInventory inv = (ComponentInventory)this.getComponent(ComponentType.Inventory);
        ItemStack resultStack = inv.m_8020_(2);
        --this.timeSinceSpawn;
        boolean isItem = false;
        ItemStack inputItem = inv.m_8020_(0);
        if (inputItem != null && !inputItem.m_41619_()) {
            isItem = true;
        }
        return this.timeSinceSpawn < 0L && isItem && (this.particles[0] == null || this.particles[1] == null) && inv.m_8020_(0).m_41613_() > 0 && resultStack.m_41613_() < resultStack.m_41741_();
    }

    public void checkCollision() {
        EntityParticle two;
        EntityParticle one;
        ComponentInventory inv = (ComponentInventory)this.getComponent(ComponentType.Inventory);
        ItemStack resultStack = inv.m_8020_(2);
        ItemStack cellStack = inv.m_8020_(1);
        if (resultStack.m_41613_() < resultStack.m_41741_() && cellStack.m_41613_() > 0 && this.particles[0] != null && this.particles[1] != null && (one = this.particles[0]).m_20270_(two = this.particles[1]) < 1.0f) {
            double speedOfMax = Math.pow((double)(one.speed + two.speed) / 4.0, 2.0);
            one.m_142687_(Entity.RemovalReason.KILLED);
            two.m_142687_(Entity.RemovalReason.KILLED);
            this.particles[1] = null;
            this.particles[0] = null;
            cellStack.m_41774_(1);
            double mod = this.f_58857_.f_46441_.nextDouble();
            if (speedOfMax > 0.999) {
                if (resultStack.m_41720_() == DeferredRegisters.ITEM_CELLDARKMATTER.get()) {
                    resultStack.m_41764_(resultStack.m_41613_() + 1);
                } else if (resultStack.m_41619_()) {
                    inv.m_6836_(2, new ItemStack((ItemLike)DeferredRegisters.ITEM_CELLDARKMATTER.get()));
                }
            } else if (speedOfMax > mod) {
                if (resultStack.m_41720_() == DeferredRegisters.ITEM_CELLANTIMATTERSMALL.get()) {
                    resultStack.m_41764_(resultStack.m_41613_() + 1);
                } else if (resultStack.m_41619_()) {
                    inv.m_6836_(2, new ItemStack((ItemLike)DeferredRegisters.ITEM_CELLANTIMATTERSMALL.get()));
                }
            }
        }
    }

    public void process(ComponentProcessor processor) {
        this.timeSinceSpawn = 100L;
        Direction dir = ((ComponentDirection)this.getComponent(ComponentType.Direction)).getDirection();
        ItemStack stack = ((ComponentInventory)this.getComponent(ComponentType.Inventory)).m_8020_(0);
        stack.m_41774_(1);
        EntityParticle particle = new EntityParticle(dir, this.f_58857_, new Location((double)((float)this.f_58858_.m_123341_() + 0.5f + (float)dir.m_122429_() * 1.5f), (double)((float)this.f_58858_.m_123342_() + 0.5f + (float)dir.m_122430_() * 1.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f + (float)dir.m_122431_() * 1.5f)));
        this.addParticle(particle);
        this.f_58857_.m_7967_((Entity)particle);
    }

    public void addParticle(EntityParticle particle) {
        if (this.particles[0] != particle && this.particles[1] != particle) {
            particle.source = this.m_58899_();
            if (this.particles[0] == null) {
                this.particles[0] = particle;
            } else if (this.particles[1] == null) {
                this.particles[1] = particle;
            }
        }
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

