/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.type.ComponentTickable;
import electrodynamics.prefab.utilities.object.CachedTileOutput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import nuclearscience.DeferredRegisters;
import nuclearscience.api.fusion.IElectromagnet;
import nuclearscience.common.settings.Constants;
import nuclearscience.common.tile.TileTurbine;

public class TilePlasma
extends GenericTile {
    public int ticksExisted;
    public int spread = 6;
    private CachedTileOutput output;

    public TilePlasma(BlockPos pos, BlockState state) {
        super((BlockEntityType)DeferredRegisters.TILE_PLASMA.get(), pos, state);
        this.addComponent((Component)new ComponentTickable().tickServer(this::tickServer));
    }

    protected void tickServer(ComponentTickable tickable) {
        ++this.ticksExisted;
        if (this.ticksExisted > 80) {
            this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50016_.m_49966_());
        }
        if (this.ticksExisted == 1 && this.spread > 0) {
            for (Direction dir : Direction.values()) {
                BlockEntity tile;
                BlockEntity blockEntity;
                BlockPos offset = this.f_58858_.m_142300_(dir);
                BlockState state = this.f_58857_.m_8055_(offset);
                boolean didntExist = false;
                if (state.m_60734_() != this.m_58900_().m_60734_()) {
                    didntExist = true;
                    if (state.m_60800_((BlockGetter)this.f_58857_, offset) != -1.0f && !(state.m_60734_() instanceof IElectromagnet) && state.m_60734_() != DeferredRegisters.blockFusionReactorCore) {
                        this.f_58857_.m_46597_(offset, DeferredRegisters.blockPlasma.m_49966_());
                    }
                }
                if (!((blockEntity = (tile = this.f_58857_.m_7702_(offset))) instanceof TilePlasma)) continue;
                TilePlasma plasma = (TilePlasma)blockEntity;
                if (plasma.ticksExisted > 1 && plasma.spread < this.spread) {
                    plasma.ticksExisted = this.ticksExisted - 1;
                }
                if (!didntExist) continue;
                plasma.spread = this.spread - 1;
            }
        }
        if (this.ticksExisted > 1 && this.f_58857_.m_8055_(this.m_58899_().m_142300_(Direction.UP)).m_60734_() instanceof IElectromagnet && this.f_58857_.m_8055_(this.m_58899_().m_5484_(Direction.UP, 2)).m_60734_() == Blocks.f_49990_) {
            if (this.output == null) {
                this.output = new CachedTileOutput(this.f_58857_, this.m_58899_().m_5484_(Direction.UP, 3));
            } else if (this.output.getSafe() instanceof TileTurbine) {
                TileTurbine turbine = (TileTurbine)((Object)this.output.getSafe());
                turbine.addSteam((int)(Constants.FUSIONREACTOR_MAXENERGYTARGET / 2260.0), Integer.MAX_VALUE);
            }
        }
    }
}

