/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.common.network.ElectricityUtilities;
import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.ComponentType;
import electrodynamics.prefab.tile.components.type.ComponentContainerProvider;
import electrodynamics.prefab.tile.components.type.ComponentElectrodynamic;
import electrodynamics.prefab.tile.components.type.ComponentInventory;
import electrodynamics.prefab.tile.components.type.ComponentPacketHandler;
import electrodynamics.prefab.tile.components.type.ComponentTickable;
import electrodynamics.prefab.utilities.object.CachedTileOutput;
import electrodynamics.prefab.utilities.object.TransferPack;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import nuclearscience.DeferredRegisters;
import nuclearscience.common.inventory.container.ContainerQuantumCapacitor;
import nuclearscience.common.world.QuantumCapacitorData;

public class TileQuantumCapacitor
extends GenericTile
implements IEnergyStorage {
    public static final double DEFAULT_MAX_JOULES = Double.MAX_VALUE;
    public static final double DEFAULT_VOLTAGE = 1920.0;
    public double outputJoules = 359.0;
    public int frequency = 0;
    public UUID uuid = UUID.randomUUID();
    private CachedTileOutput outputCache;
    private CachedTileOutput outputCache2;
    public double joulesClient = 0.0;
    private Direction lastDir = null;

    public TileQuantumCapacitor(BlockPos pos, BlockState state) {
        super((BlockEntityType)DeferredRegisters.TILE_QUANTUMCAPACITOR.get(), pos, state);
        this.addComponent((Component)new ComponentTickable().tickServer(this::tickServer));
        this.addComponent((Component)new ComponentPacketHandler().guiPacketReader(this::readGUIPacket).guiPacketWriter(this::writeGUIPacket));
        this.addComponent((Component)new ComponentElectrodynamic((GenericTile)this).voltage(1920.0).output(Direction.DOWN).output(Direction.UP).input(Direction.WEST).input(Direction.EAST).input(Direction.SOUTH).input(Direction.NORTH).receivePower(this::receivePower).setJoules(this::setJoulesStored).getJoules(this::getJoulesStored));
        this.addComponent((Component)new ComponentInventory((GenericTile)this));
        this.addComponent((Component)new ComponentContainerProvider("container.quantumcapacitor").createMenu((id, player) -> new ContainerQuantumCapacitor((int)id, (Inventory)player, (Container)this.getComponent(ComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    public double getOutputJoules() {
        return this.outputJoules;
    }

    public void tickServer(ComponentTickable tickable) {
        double sent;
        double joules;
        if (this.outputCache == null) {
            this.outputCache = new CachedTileOutput(this.f_58857_, new BlockPos((Vec3i)this.f_58858_).m_142300_(Direction.UP));
        }
        if (this.outputCache2 == null) {
            this.outputCache2 = new CachedTileOutput(this.f_58857_, new BlockPos((Vec3i)this.f_58858_).m_142300_(Direction.DOWN));
        }
        if (tickable.getTicks() % 40L == 0L) {
            this.outputCache.update();
            this.outputCache2.update();
        }
        if ((joules = this.getJoulesStored()) > 0.0 && this.outputCache.valid()) {
            sent = ElectricityUtilities.receivePower((BlockEntity)((BlockEntity)this.outputCache.getSafe()), (Direction)Direction.DOWN, (TransferPack)TransferPack.joulesVoltage((double)Math.min(joules, this.outputJoules), (double)1920.0), (boolean)false).getJoules();
            QuantumCapacitorData.get(this.f_58857_).setJoules(this.uuid, this.frequency, this.getJoulesStored() - sent);
        }
        if ((joules = this.getJoulesStored()) > 0.0 && this.outputCache2.valid()) {
            sent = ElectricityUtilities.receivePower((BlockEntity)((BlockEntity)this.outputCache2.getSafe()), (Direction)Direction.UP, (TransferPack)TransferPack.joulesVoltage((double)Math.min(joules, this.outputJoules), (double)1920.0), (boolean)false).getJoules();
            QuantumCapacitorData.get(this.f_58857_).setJoules(this.uuid, this.frequency, this.getJoulesStored() - sent);
        }
        if (tickable.getTicks() % 50L == 0L) {
            ((ComponentPacketHandler)this.getComponent(ComponentType.PacketHandler)).sendGuiPacketToTracking();
        }
    }

    public void writeGUIPacket(CompoundTag nbt) {
        nbt.m_128347_("joulesClient", this.getJoulesStored());
        nbt.m_128405_("frequency", this.frequency);
        nbt.m_128362_("uuid", this.uuid);
        nbt.m_128347_("outputJoules", this.outputJoules);
    }

    public void readGUIPacket(CompoundTag nbt) {
        this.joulesClient = nbt.m_128459_("joulesClient");
        this.frequency = nbt.m_128451_("frequency");
        this.uuid = nbt.m_128342_("uuid");
        this.outputJoules = nbt.m_128459_("outputJoules");
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        super.m_6945_(compound);
        compound.m_128405_("frequency", this.frequency);
        compound.m_128347_("outputJoules", this.outputJoules);
        compound.m_128362_("uuid", this.uuid);
        return compound;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.outputJoules = compound.m_128459_("outputJoules");
        this.frequency = compound.m_128451_("frequency");
        if (compound.m_128403_("uuid")) {
            this.uuid = compound.m_128342_("uuid");
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            this.lastDir = facing;
            return LazyOptional.of(() -> this);
        }
        return super.getCapability(capability, facing);
    }

    public TransferPack receivePower(TransferPack transfer, boolean debug) {
        double joules = this.getJoulesStored();
        if (this.lastDir != Direction.UP && this.lastDir != Direction.DOWN) {
            double received = Math.min(Math.min(Double.MAX_VALUE, transfer.getJoules()), Double.MAX_VALUE - joules);
            if (!debug) {
                if (transfer.getVoltage() == 1920.0) {
                    joules += received;
                }
                QuantumCapacitorData.get(this.f_58857_).setJoules(this.uuid, this.frequency, joules);
                if (transfer.getVoltage() > 1920.0) {
                    this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50016_.m_49966_());
                    this.f_58857_.m_46511_(null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (float)Math.log10(10.0 + transfer.getVoltage() / 1920.0), Explosion.BlockInteraction.DESTROY);
                    return TransferPack.EMPTY;
                }
            }
            return TransferPack.joulesVoltage((double)received, (double)transfer.getVoltage());
        }
        return TransferPack.EMPTY;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int calVoltage = 120;
        TransferPack pack = this.receivePower(TransferPack.joulesVoltage((double)maxReceive, (double)calVoltage), simulate);
        return (int)Math.min(2.147483647E9, pack.getJoules());
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int calVoltage = 120;
        TransferPack pack = ((ComponentElectrodynamic)this.getComponent(ComponentType.Electrodynamic)).extractPower(TransferPack.joulesVoltage((double)maxExtract, (double)calVoltage), simulate);
        return (int)Math.min(2.147483647E9, pack.getJoules());
    }

    public int getEnergyStored() {
        return (int)Math.min(2.147483647E9, this.getJoulesStored());
    }

    public int getMaxEnergyStored() {
        return (int)Math.min(2.147483647E9, Double.MAX_VALUE);
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public void setJoulesStored(double joules) {
        QuantumCapacitorData data = QuantumCapacitorData.get(this.f_58857_);
        if (data != null) {
            data.setJoules(this.uuid, this.frequency, joules);
        }
    }

    public double getJoulesStored() {
        QuantumCapacitorData data = QuantumCapacitorData.get(this.f_58857_);
        return data == null ? 0.0 : data.getJoules(this.uuid, this.frequency);
    }

    public double getMaxJoulesStored() {
        return Double.MAX_VALUE;
    }
}

