/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.common.network.ElectricityUtilities;
import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.ComponentType;
import electrodynamics.prefab.tile.components.type.ComponentContainerProvider;
import electrodynamics.prefab.tile.components.type.ComponentElectrodynamic;
import electrodynamics.prefab.tile.components.type.ComponentInventory;
import electrodynamics.prefab.tile.components.type.ComponentPacketHandler;
import electrodynamics.prefab.tile.components.type.ComponentTickable;
import electrodynamics.prefab.utilities.object.CachedTileOutput;
import electrodynamics.prefab.utilities.object.TransferPack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import nuclearscience.DeferredRegisters;
import nuclearscience.api.radiation.IRadioactiveObject;
import nuclearscience.api.radiation.RadiationRegister;
import nuclearscience.common.inventory.container.ContainerRadioisotopeGenerator;
import nuclearscience.common.settings.Constants;

public class TileRadioisotopeGenerator
extends GenericTile {
    protected CachedTileOutput output1;
    protected CachedTileOutput output2;

    public TileRadioisotopeGenerator(BlockPos pos, BlockState state) {
        super((BlockEntityType)DeferredRegisters.TILE_RADIOISOTOPEGENERATOR.get(), pos, state);
        this.addComponent((Component)new ComponentTickable().tickServer(this::tickServer));
        this.addComponent((Component)new ComponentPacketHandler());
        this.addComponent((Component)new ComponentElectrodynamic((GenericTile)this).voltage(Constants.RADIOISOTOPEGENERATOR_VOLTAGE).extractPower((x, y) -> TransferPack.EMPTY).output(Direction.UP).output(Direction.DOWN));
        this.addComponent((Component)new ComponentInventory((GenericTile)this).size(1).slotFaces(Integer.valueOf(0), Direction.values()).valid((slot, stack) -> RadiationRegister.get(stack.m_41720_()) != RadiationRegister.NULL));
        this.addComponent((Component)new ComponentContainerProvider("container.radioisotopegenerator").createMenu((id, player) -> new ContainerRadioisotopeGenerator((int)id, (Inventory)player, (Container)this.getComponent(ComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    public void tickServer(ComponentTickable tickable) {
        if (this.output1 == null) {
            this.output1 = new CachedTileOutput(this.f_58857_, this.f_58858_.m_142300_(Direction.UP));
        }
        if (this.output2 == null) {
            this.output2 = new CachedTileOutput(this.f_58857_, this.f_58858_.m_142300_(Direction.DOWN));
        }
        if (tickable.getTicks() % 40L == 0L) {
            this.output1.update();
            this.output2.update();
        }
        ItemStack in = ((ComponentInventory)this.getComponent(ComponentType.Inventory)).m_8020_(0);
        IRadioactiveObject rad = RadiationRegister.get(in.m_41720_());
        double currentOutput = (double)in.m_41613_() * Constants.RADIOISOTOPEGENERATOR_OUTPUT_MULTIPLIER * rad.getRadiationStrength();
        if (currentOutput > 0.0) {
            TransferPack transfer = TransferPack.ampsVoltage((double)(currentOutput / (Constants.RADIOISOTOPEGENERATOR_VOLTAGE * 2.0)), (double)Constants.RADIOISOTOPEGENERATOR_VOLTAGE);
            if (this.output1.valid()) {
                ElectricityUtilities.receivePower((BlockEntity)((BlockEntity)this.output1.getSafe()), (Direction)Direction.DOWN, (TransferPack)transfer, (boolean)false);
            }
            if (this.output2.valid()) {
                ElectricityUtilities.receivePower((BlockEntity)((BlockEntity)this.output2.getSafe()), (Direction)Direction.UP, (TransferPack)transfer, (boolean)false);
            }
        }
    }
}

