/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.common.recipe.ElectrodynamicsRecipe;
import electrodynamics.common.recipe.categories.item2item.Item2ItemRecipe;
import electrodynamics.common.recipe.recipeutils.CountableIngredient;
import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.ComponentType;
import electrodynamics.prefab.tile.components.type.ComponentContainerProvider;
import electrodynamics.prefab.tile.components.type.ComponentInventory;
import electrodynamics.prefab.tile.components.type.ComponentPacketHandler;
import electrodynamics.prefab.tile.components.type.ComponentTickable;
import electrodynamics.prefab.utilities.object.Location;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import nuclearscience.DeferredRegisters;
import nuclearscience.api.radiation.DamageSourceRadiation;
import nuclearscience.api.radiation.RadiationSystem;
import nuclearscience.common.inventory.container.ContainerReactorCore;
import nuclearscience.common.recipe.NuclearScienceRecipeInit;
import nuclearscience.common.settings.Constants;
import nuclearscience.common.tile.TileControlRodAssembly;
import nuclearscience.common.tile.TileTurbine;

public class TileReactorCore
extends GenericTile {
    public static final int MELTDOWN_TEMPERATURE_ACTUAL = 5611;
    public static final int MELTDOWN_TEMPERATURE_CALC = 4407;
    public static final int WATER_TEMPERATURE = 10;
    public static final int AIR_TEMPERATURE = 15;
    public static final int MAX_FUEL_COUNT = 12;
    public static final int STEAM_GEN_DIAMETER = 5;
    public static final int STEAM_GEN_HEIGHT = 2;
    private TileTurbine[][][] cachedTurbines = new TileTurbine[5][2][5];
    public double temperature = 15.0;
    public boolean hasDeuterium = false;
    public int ticksOverheating = 0;
    public int fuelCount = 0;
    public int ticks = 0;

    public TileReactorCore(BlockPos pos, BlockState state) {
        super((BlockEntityType)DeferredRegisters.TILE_REACTORCORE.get(), pos, state);
        this.addComponent((Component)new ComponentTickable().tickCommon(this::tickCommon).tickServer(this::tickServer));
        this.addComponent((Component)new ComponentPacketHandler().customPacketReader(this::readCustomPacket).customPacketWriter(this::writeCustomPacket).guiPacketReader(this::readCustomPacket).guiPacketWriter(this::writeCustomPacket));
        this.addComponent((Component)new ComponentInventory((GenericTile)this).size(6).faceSlots(Direction.UP, new Integer[]{0, 1, 2, 3, 4}).faceSlots(Direction.DOWN, new Integer[]{5}));
        this.addComponent((Component)new ComponentContainerProvider("container.reactorcore").createMenu((id, player) -> new ContainerReactorCore((int)id, (Inventory)player, (Container)this.getComponent(ComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    protected void tickServer(ComponentTickable tickable) {
        boolean hasWater;
        ComponentInventory inv = (ComponentInventory)this.getComponent(ComponentType.Inventory);
        if (tickable.getTicks() % 10L == 0L) {
            ((ComponentPacketHandler)this.getComponent(ComponentType.PacketHandler)).sendCustomPacket();
        }
        this.fuelCount = 0;
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = inv.m_8020_(i);
            this.fuelCount += stack.m_41720_() == DeferredRegisters.ITEM_FUELLEUO2.get() ? 2 : (stack.m_41720_() == DeferredRegisters.ITEM_FUELHEUO2.get() ? 3 : (stack.m_41720_() == DeferredRegisters.ITEM_FUELPLUTONIUM.get() ? 2 : 0));
        }
        this.hasDeuterium = !inv.m_8020_(4).m_41619_();
        double decrease = (this.temperature - 15.0) / 3000.0;
        if (this.fuelCount == 0) {
            decrease *= 25.0;
        }
        boolean bl = hasWater = !this.m_58900_().m_60819_().m_76178_();
        if (hasWater) {
            decrease += (this.temperature - 10.0) / 5000.0;
        }
        if (decrease != 0.0) {
            this.temperature -= decrease < 0.001 && decrease > 0.0 ? 0.001 : (decrease > -0.001 && decrease < 0.0 ? -0.001 : decrease);
        }
        if (this.fuelCount > 0 && this.ticks > 50) {
            BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
            int insertion = 0;
            BlockEntity blockEntity = tile;
            if (blockEntity instanceof TileControlRodAssembly) {
                TileControlRodAssembly assembly = (TileControlRodAssembly)blockEntity;
                insertion = assembly.isMSR ? 0 : assembly.insertion;
            }
            double insertDecimal = (double)(100 - insertion) / 100.0;
            if ((double)this.f_58857_.f_46441_.nextFloat() < insertDecimal) {
                for (int slot = 0; slot < 4; ++slot) {
                    ItemStack fuelRod = inv.m_8020_(slot);
                    if (fuelRod != ItemStack.f_41583_ && fuelRod.m_41773_() >= fuelRod.m_41776_()) {
                        inv.m_6836_(slot, new ItemStack((ItemLike)DeferredRegisters.ITEM_FUELSPENT.get()));
                    }
                    fuelRod.m_41721_((int)((long)(fuelRod.m_41773_() + 1) + Math.round(this.temperature) / 4407L));
                }
            }
            this.temperature += (4407.0 * insertDecimal * (0.25 * ((double)this.fuelCount / 2.0) + this.f_58857_.f_46441_.nextDouble() / 5.0) - this.temperature) / (200.0 + 20.0 * (hasWater ? 4.0 : 1.0));
            if (this.temperature > (double)(5611 + this.f_58857_.f_46441_.nextInt(50)) && this.fuelCount > 0) {
                ++this.ticksOverheating;
                if (this.ticksOverheating > 200) {
                    this.meltdown();
                }
            }
            if (this.f_58857_.m_6106_().m_6793_() % 10L == 0L) {
                Location source = new Location((double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 0.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f));
                double totstrength = this.temperature * 10.0;
                double range = Math.sqrt(totstrength) / (5.0 * Math.sqrt(2.0)) * 2.0;
                AABB bb = AABB.m_165882_((Vec3)new Vec3(source.x(), source.y(), source.z()), (double)range, (double)range, (double)range);
                List list = this.f_58857_.m_45976_(LivingEntity.class, bb);
                for (LivingEntity living : list) {
                    RadiationSystem.applyRadiation(living, source, totstrength);
                }
            }
        } else {
            this.ticksOverheating = 0;
        }
        this.temperature = Math.max(15.0, this.temperature);
        if (this.fuelCount > 0 && (double)this.f_58857_.f_46441_.nextFloat() < 1.0 / (5288400.0 / this.temperature)) {
            this.processFissReact(inv);
        }
    }

    protected void tickCommon(ComponentTickable tickable) {
        int n = this.ticks = this.ticks > 0x7FFFFFFD ? 0 : this.ticks + 1;
        if (this.ticks % 20 == 0) {
            this.f_58857_.m_5518_().m_142202_(this.f_58858_);
        }
        this.produceSteam();
    }

    public void meltdown() {
        if (!this.f_58857_.f_46443_) {
            int radius = 2;
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
            for (int i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    for (int k = -radius; k <= radius; ++k) {
                        BlockPos ppos = new BlockPos(this.f_58858_.m_123341_() + i, this.f_58858_.m_123342_() + j, this.f_58858_.m_123343_() + k);
                        BlockState state = this.f_58857_.m_8055_(ppos);
                        if (state.m_60734_() != Blocks.f_49990_) continue;
                        this.f_58857_.m_46597_(ppos, Blocks.f_50016_.m_49966_());
                    }
                }
            }
            this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50016_.m_49966_());
            Explosion actual = new Explosion(this.f_58857_, null, DamageSourceRadiation.INSTANCE, null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), 20.0f, true, Explosion.BlockInteraction.BREAK);
            radius = 3 * this.fuelCount;
            for (int i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    for (int k = -radius; k <= radius; ++k) {
                        double distance;
                        BlockPos ppos = new BlockPos(this.f_58858_.m_123341_() + i, this.f_58858_.m_123342_() + j, this.f_58858_.m_123343_() + k);
                        BlockState state = this.f_58857_.m_8055_(ppos);
                        if (!(state.m_60734_().getExplosionResistance(state, (BlockGetter)this.f_58857_, ppos, actual) < (float)radius) || !((distance = Math.sqrt(i * i + j * j + k * k)) < (double)radius) || !((double)this.f_58857_.f_46441_.nextFloat() < 1.0 - 1.0E-4 * distance * distance * distance) || !((double)this.f_58857_.f_46441_.nextFloat() < 0.9)) continue;
                        this.f_58857_.m_8055_(ppos).onBlockExploded(this.f_58857_, ppos, actual);
                    }
                }
            }
            this.f_58857_.m_46511_(null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), 20.0f, Explosion.BlockInteraction.DESTROY);
            this.f_58857_.m_46597_(this.f_58858_, DeferredRegisters.blockMeltedReactor.m_49966_());
        }
    }

    protected void produceSteam() {
        if (this.temperature <= 400.0) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 5; ++k) {
                    boolean isFaceWater;
                    int offsetZ;
                    int offsetY;
                    boolean isReactor2d;
                    boolean bl = isReactor2d = i - 2 == 0 && k - 2 == 0;
                    if (isReactor2d && j == 0) {
                        if (this.f_58857_.f_46443_ || !((double)this.f_58857_.f_46441_.nextFloat() < this.temperature / 4407000.0) || !this.f_58857_.m_8055_(this.f_58858_).m_61138_((Property)BlockStateProperties.f_61362_)) continue;
                        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
                        continue;
                    }
                    int offsetX = this.f_58858_.m_123341_() + i - 2;
                    BlockPos offpos = new BlockPos(offsetX, offsetY = this.f_58858_.m_123342_() + j, offsetZ = this.f_58858_.m_123343_() + k - 2);
                    Block offset = this.f_58857_.m_8055_(offpos).m_60734_();
                    if (offset != Blocks.f_49990_) continue;
                    boolean bl2 = isFaceWater = this.f_58857_.m_8055_(new BlockPos(offsetX, this.f_58858_.m_123342_(), this.f_58858_.m_123343_())).m_60734_() == Blocks.f_49990_ || this.f_58857_.m_8055_(new BlockPos(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), offsetZ)).m_60734_() == Blocks.f_49990_ || isReactor2d;
                    if (!isFaceWater) continue;
                    if (!this.f_58857_.f_46443_) {
                        TileTurbine turbine = this.cachedTurbines[i][j][k];
                        if (turbine != null) {
                            if (turbine.m_58901_()) {
                                this.cachedTurbines[i][j][k] = null;
                            }
                            turbine.addSteam((int)(Constants.FISSIONREACTOR_MAXENERGYTARGET / (500.0 * (5611.0 / this.temperature))), (int)this.temperature);
                        }
                        if ((double)this.f_58857_.f_46441_.nextFloat() < this.temperature / 4407000.0) {
                            this.f_58857_.m_46597_(offpos, Blocks.f_50016_.m_49966_());
                            continue;
                        }
                        if (turbine != null && !turbine.m_58901_()) continue;
                        BlockEntity above = this.f_58857_.m_7702_(new BlockPos(offsetX, offsetY + 1, offsetZ));
                        BlockEntity blockEntity = above;
                        if (blockEntity instanceof TileTurbine) {
                            TileTurbine trb;
                            this.cachedTurbines[i][j][k] = trb = (TileTurbine)blockEntity;
                            continue;
                        }
                        this.cachedTurbines[i][j][k] = null;
                        continue;
                    }
                    if (!this.f_58857_.f_46443_ || !((double)this.f_58857_.f_46441_.nextFloat() < this.temperature / 16833.0)) continue;
                    double offsetFX = (double)offsetX + this.f_58857_.f_46441_.nextDouble() / 2.0 * (double)(this.f_58857_.f_46441_.nextBoolean() ? -1 : 1);
                    double offsetFY = (double)offsetY + this.f_58857_.f_46441_.nextDouble() / 2.0 * (double)(this.f_58857_.f_46441_.nextBoolean() ? -1 : 1);
                    double offsetFZ = (double)offsetZ + this.f_58857_.f_46441_.nextDouble() / 2.0 * (double)(this.f_58857_.f_46441_.nextBoolean() ? -1 : 1);
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, offsetFX + 0.5, offsetFY + (double)0.2f, offsetFZ + 0.5, 0.0, 0.0, 0.0);
                    if (this.f_58857_.f_46441_.nextInt(3) != 0) continue;
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, offsetFX + 0.5, offsetFY + 0.5, offsetFZ + 0.5, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    protected void writeCustomPacket(CompoundTag tag) {
        ComponentInventory inv = (ComponentInventory)this.getComponent(ComponentType.Inventory);
        tag.m_128379_("hasDeuterium", this.hasDeuterium);
        tag.m_128347_("temperature", this.temperature);
        tag.m_128405_("fuelCount", inv.m_18947_((Item)DeferredRegisters.ITEM_FUELHEUO2.get()) + inv.m_18947_((Item)DeferredRegisters.ITEM_FUELLEUO2.get()));
    }

    protected void readCustomPacket(CompoundTag nbt) {
        this.hasDeuterium = nbt.m_128471_("hasDeuterium");
        this.temperature = nbt.m_128459_("temperature");
        this.fuelCount = nbt.m_128451_("fuelCount");
    }

    public void processFissReact(ComponentInventory inv) {
        int inputSlot = 4;
        int outputSlot = 5;
        ItemStack input = inv.m_8020_(inputSlot);
        ItemStack output = inv.m_8020_(outputSlot);
        if (input != null && !input.equals(new ItemStack((ItemLike)Items.f_41852_), true)) {
            Set recipes = ElectrodynamicsRecipe.findRecipesbyType(NuclearScienceRecipeInit.FISSION_REACTOR_TYPE, (Level)this.f_58857_);
            for (Recipe iRecipe : recipes) {
                Item2ItemRecipe recipe = (Item2ItemRecipe)iRecipe;
                for (CountableIngredient ing : recipe.getCountedIngredients()) {
                    if (!ing.testStack(input)) continue;
                    if (output.m_41619_()) {
                        inv.m_6836_(outputSlot, recipe.m_8043_().m_41777_());
                        input.m_41774_(((CountableIngredient)recipe.getCountedIngredients().get(0)).getStackSize());
                        continue;
                    }
                    if (output.m_41613_() > output.m_41741_() + recipe.m_8043_().m_41613_()) continue;
                    output.m_41769_(recipe.m_8043_().m_41613_());
                    input.m_41774_(((CountableIngredient)recipe.getCountedIngredients().get(0)).getStackSize());
                }
            }
        }
    }
}

