/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.ComponentType;
import electrodynamics.prefab.tile.components.type.ComponentDirection;
import electrodynamics.prefab.tile.components.type.ComponentElectrodynamic;
import electrodynamics.prefab.tile.components.type.ComponentPacketHandler;
import electrodynamics.prefab.tile.components.type.ComponentTickable;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import nuclearscience.DeferredRegisters;
import nuclearscience.common.item.ItemFrequencyCard;

public class TileTeleporter
extends GenericTile {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public int cooldown = 0;
    public String world;

    public TileTeleporter(BlockPos pos, BlockState state) {
        super((BlockEntityType)DeferredRegisters.TILE_TELEPORTER.get(), pos, state);
        this.addComponent((Component)new ComponentDirection());
        this.addComponent((Component)new ComponentTickable().tickServer(this::tickServer));
        this.addComponent((Component)new ComponentPacketHandler());
        this.addComponent((Component)new ComponentElectrodynamic((GenericTile)this).maxJoules(5000000.0).voltage(480.0).input(Direction.DOWN));
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82400_(3.0);
    }

    protected void tickServer(ComponentTickable tickable) {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(ComponentType.Electrodynamic);
        if (tickable.getTicks() % (long)(electro.getJoulesStored() == 0.0 ? 40 : 15) == 0L) {
            ((ComponentPacketHandler)this.getComponent(ComponentType.PacketHandler)).sendGuiPacketToTracking();
        }
        if (this.cooldown <= 0) {
            this.cooldown = 20;
            if (electro.getJoulesStored() == electro.getMaxJoulesStored()) {
                ServerLevel serverWorld;
                AABB BB = new AABB(this.m_58899_(), this.m_58899_().m_142082_(1, 2, 1));
                List player = this.m_58904_().m_142425_((EntityTypeTest)EntityType.f_20532_, BB, en -> true);
                if (!player.isEmpty() && (serverWorld = ItemFrequencyCard.getFromNBT((ServerLevel)this.m_58904_(), this.world)) == ((Player)player.get(0)).m_20193_()) {
                    ((Player)player.get(0)).m_20324_((double)this.xCoord, (double)(this.yCoord + 1), (double)this.zCoord);
                    this.cooldown = 80;
                    electro.joules(0.0);
                }
            }
        }
        --this.cooldown;
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        if (this.world != null) {
            compound.m_128405_("xCoord", this.xCoord);
            compound.m_128405_("yCoord", this.yCoord);
            compound.m_128405_("zCoord", this.zCoord);
            compound.m_128359_("world", this.world);
        }
        return super.m_6945_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("world")) {
            this.xCoord = compound.m_128451_("xCoord");
            this.yCoord = compound.m_128451_("yCoord");
            this.zCoord = compound.m_128451_("zCoord");
            this.world = compound.m_128461_("world");
        }
    }
}

