/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.api.sound.SoundAPI;
import electrodynamics.common.network.ElectricityUtilities;
import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.ComponentType;
import electrodynamics.prefab.tile.components.type.ComponentElectrodynamic;
import electrodynamics.prefab.tile.components.type.ComponentPacketHandler;
import electrodynamics.prefab.tile.components.type.ComponentTickable;
import electrodynamics.prefab.utilities.object.CachedTileOutput;
import electrodynamics.prefab.utilities.object.TransferPack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import nuclearscience.DeferredRegisters;
import nuclearscience.SoundRegister;
import nuclearscience.common.block.BlockTurbine;

public class TileTurbine
extends GenericTile {
    public static final int MAX_STEAM = 3000000;
    public int spinSpeed = 0;
    public boolean isCore;
    protected CachedTileOutput output;
    protected int currentVoltage = 0;
    protected int steam;
    protected int wait = 30;
    protected boolean hasCore;
    protected BlockPos coreLocation = BlockPos.f_121853_;

    public AABB getRenderBoundingBox() {
        return this.isCore ? super.getRenderBoundingBox().m_82377_(1.0, 0.0, 1.0) : super.getRenderBoundingBox();
    }

    public TileTurbine(BlockPos pos, BlockState state) {
        super((BlockEntityType)DeferredRegisters.TILE_TURBINE.get(), pos, state);
        this.addComponent((Component)new ComponentTickable().tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((Component)new ComponentPacketHandler().customPacketWriter(this::writeCustomPacket).customPacketReader(this::readCustomPacket));
        this.addComponent((Component)new ComponentElectrodynamic((GenericTile)this).output(Direction.UP).setCapabilityTest(() -> !this.hasCore || this.isCore));
    }

    public void constructStructure() {
        int j;
        int i;
        int radius = 1;
        for (i = -radius; i <= radius; ++i) {
            for (j = -radius; j <= radius; ++j) {
                if (i == 0 && j == 0) continue;
                BlockEntity tile = this.f_58857_.m_7702_(new BlockPos(this.f_58858_.m_123341_() + i, this.f_58858_.m_123342_(), this.f_58858_.m_123343_() + j));
                BlockEntity blockEntity = tile;
                if (blockEntity instanceof TileTurbine) {
                    TileTurbine turbine = (TileTurbine)blockEntity;
                    if (!turbine.hasCore) continue;
                }
                return;
            }
        }
        this.isCore = true;
        for (i = -radius; i <= radius; ++i) {
            for (j = -radius; j <= radius; ++j) {
                BlockPos offset = new BlockPos(this.f_58858_.m_123341_() + i, this.f_58858_.m_123342_(), this.f_58858_.m_123343_() + j);
                ((TileTurbine)this.f_58857_.m_7702_(offset)).addToStructure(this);
                BlockState state = this.f_58857_.m_8055_(offset);
                this.f_58857_.m_46597_(offset, (BlockState)state.m_61124_((Property)BlockTurbine.RENDER, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public void deconstructStructure() {
        TileTurbine core;
        if (this.isCore) {
            int radius = 1;
            for (int i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    BlockPos offset;
                    BlockEntity tile;
                    BlockEntity blockEntity;
                    if (i == 0 && j == 0 || !((blockEntity = (tile = this.f_58857_.m_7702_(offset = new BlockPos(this.f_58858_.m_123341_() + i, this.f_58858_.m_123342_(), this.f_58858_.m_123343_() + j)))) instanceof TileTurbine)) continue;
                    TileTurbine turbine = (TileTurbine)blockEntity;
                    turbine.hasCore = false;
                    turbine.coreLocation = new BlockPos(0, 0, 0);
                    BlockState state = this.f_58857_.m_8055_(offset);
                    if (!state.m_61138_((Property)BlockTurbine.RENDER)) continue;
                    this.f_58857_.m_46597_(offset, (BlockState)state.m_61124_((Property)BlockTurbine.RENDER, (Comparable)Boolean.valueOf(true)));
                }
            }
            this.isCore = false;
            this.hasCore = false;
            this.coreLocation = new BlockPos(0, 0, 0);
            BlockState state = this.m_58900_();
            if (state.m_61138_((Property)BlockTurbine.RENDER)) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockTurbine.RENDER, (Comparable)Boolean.valueOf(true)));
            }
        } else if (this.hasCore && (core = (TileTurbine)this.f_58857_.m_7702_(this.coreLocation)) != null) {
            core.deconstructStructure();
        }
        ((ComponentPacketHandler)this.getComponent(ComponentType.PacketHandler)).sendCustomPacket();
    }

    protected void addToStructure(TileTurbine core) {
        this.coreLocation = core.f_58858_;
        this.hasCore = true;
        ((ComponentPacketHandler)this.getComponent(ComponentType.PacketHandler)).sendCustomPacket();
    }

    public void addSteam(int steam, int temp) {
        BlockEntity core;
        BlockEntity blockEntity;
        this.steam = Math.min(3000000 * (this.isCore ? 9 : 1), this.steam + steam);
        this.currentVoltage = temp < 4300 ? 120 : (temp < 6000 ? 240 : 480);
        if (!this.isCore && this.hasCore && (blockEntity = (core = this.f_58857_.m_7702_(this.coreLocation))) instanceof TileTurbine) {
            TileTurbine turbine = (TileTurbine)blockEntity;
            if (((TileTurbine)core).isCore) {
                turbine.addSteam(this.steam, temp);
                this.steam = 0;
            }
        }
    }

    public void tickServer(ComponentTickable tickable) {
        ((ComponentElectrodynamic)this.getComponent(ComponentType.Electrodynamic)).voltage((double)this.currentVoltage);
        if (this.output == null) {
            this.output = new CachedTileOutput(this.f_58857_, this.f_58858_.m_142300_(Direction.UP));
        }
        if (tickable.getTicks() % 30L == 0L) {
            ((ComponentPacketHandler)this.getComponent(ComponentType.PacketHandler)).sendCustomPacket();
            this.spinSpeed = this.currentVoltage / 120;
            this.output.update();
        }
        if (this.hasCore && !this.isCore) {
            this.currentVoltage = 0;
            return;
        }
        if (this.steam > 0 && this.currentVoltage > 0) {
            this.wait = 30;
            if (this.output.valid()) {
                TransferPack transfer = TransferPack.joulesVoltage((double)((double)this.steam * (this.hasCore ? 1.111 : 1.0)), (double)this.currentVoltage);
                ElectricityUtilities.receivePower((BlockEntity)((BlockEntity)this.output.getSafe()), (Direction)Direction.DOWN, (TransferPack)transfer, (boolean)false);
                this.steam = Math.max(this.steam - Math.max(75, this.steam), 0);
            }
        } else {
            if (this.wait <= 0) {
                this.currentVoltage = 0;
                this.wait = 30;
            }
            --this.wait;
        }
    }

    public void tickClient(ComponentTickable tickable) {
        if (this.spinSpeed > 0 && tickable.getTicks() % 200L == 0L) {
            SoundAPI.playSound((SoundEvent)((SoundEvent)SoundRegister.SOUND_TURBINE.get()), (SoundSource)SoundSource.BLOCKS, (float)1.0f, (float)1.0f, (BlockPos)this.f_58858_);
        }
    }

    public void writeCustomPacket(CompoundTag tag) {
        tag.m_128405_("spinSpeed", this.spinSpeed);
        tag.m_128379_("hasCore", this.hasCore);
        tag.m_128379_("isCore", this.isCore);
    }

    public void readCustomPacket(CompoundTag nbt) {
        this.spinSpeed = nbt.m_128451_("spinSpeed");
        this.hasCore = nbt.m_128471_("hasCore");
        this.isCore = nbt.m_128471_("isCore");
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        compound.m_128379_("hasCore", this.hasCore);
        compound.m_128379_("isCore", this.isCore);
        compound.m_128405_("coreX", this.coreLocation.m_123341_());
        compound.m_128405_("coreY", this.coreLocation.m_123342_());
        compound.m_128405_("coreZ", this.coreLocation.m_123343_());
        return super.m_6945_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.hasCore = compound.m_128471_("hasCore");
        this.isCore = compound.m_128471_("isCore");
        this.coreLocation = new BlockPos(compound.m_128451_("coreX"), compound.m_128451_("coreY"), compound.m_128451_("coreZ"));
    }
}

