/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.generic;

import com.google.common.collect.Sets;
import electrodynamics.api.network.INetwork;
import electrodynamics.prefab.network.AbstractNetwork;
import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.type.ComponentPacketHandler;
import electrodynamics.prefab.utilities.Scheduler;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import nuclearscience.api.network.moltensalt.IMoltenSaltPipe;
import nuclearscience.common.network.MoltenSaltNetwork;
import nuclearscience.common.tile.TileHeatExchanger;

public abstract class GenericTileMoltenSaltPipe
extends GenericTile
implements IMoltenSaltPipe {
    public MoltenSaltNetwork moltenSaltNetwork;
    private boolean[] connections = new boolean[6];
    private BlockEntity[] tileConnections = new BlockEntity[6];

    public AbstractNetwork<?, ?, ?, ?> getAbstractNetwork() {
        return this.moltenSaltNetwork;
    }

    protected GenericTileMoltenSaltPipe(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.addComponent((Component)new ComponentPacketHandler().customPacketReader(this::readCustomPacket).customPacketWriter(this::writeCustomPacket));
    }

    private HashSet<IMoltenSaltPipe> getConnectedConductors() {
        HashSet<IMoltenSaltPipe> set = new HashSet<IMoltenSaltPipe>();
        for (Direction dir : Direction.values()) {
            BlockEntity facing = this.f_58857_.m_7702_(new BlockPos((Vec3i)this.f_58858_).m_142300_(dir));
            if (!(facing instanceof IMoltenSaltPipe)) continue;
            set.add((IMoltenSaltPipe)facing);
        }
        return set;
    }

    public MoltenSaltNetwork getNetwork() {
        return this.getNetwork(true);
    }

    public MoltenSaltNetwork getNetwork(boolean createIfNull) {
        if (this.moltenSaltNetwork == null && createIfNull) {
            HashSet<IMoltenSaltPipe> adjacentCables = this.getConnectedConductors();
            HashSet<MoltenSaltNetwork> connectedNets = new HashSet<MoltenSaltNetwork>();
            for (IMoltenSaltPipe wire : adjacentCables) {
                INetwork iNetwork;
                if (wire.getNetwork(false) == null || !((iNetwork = wire.getNetwork()) instanceof MoltenSaltNetwork)) continue;
                MoltenSaltNetwork net = (MoltenSaltNetwork)iNetwork;
                connectedNets.add(net);
            }
            if (connectedNets.isEmpty()) {
                this.moltenSaltNetwork = new MoltenSaltNetwork(Sets.newHashSet((Object[])new GenericTileMoltenSaltPipe[]{this}));
            } else {
                this.moltenSaltNetwork = connectedNets.size() == 1 ? (MoltenSaltNetwork)((Object)connectedNets.toArray()[0]) : new MoltenSaltNetwork(connectedNets, false);
                this.moltenSaltNetwork.conductorSet.add(this);
            }
        }
        return this.moltenSaltNetwork;
    }

    @Override
    public void setNetwork(AbstractNetwork<?, ?, ?, ?> network) {
        AbstractNetwork<?, ?, ?, ?> abstractNetwork;
        if (this.moltenSaltNetwork != network && (abstractNetwork = network) instanceof MoltenSaltNetwork) {
            MoltenSaltNetwork net = (MoltenSaltNetwork)abstractNetwork;
            this.removeFromNetwork();
            this.moltenSaltNetwork = net;
        }
    }

    @Override
    public void refreshNetwork() {
        if (!this.f_58857_.f_46443_) {
            this.updateAdjacent();
            ArrayList<MoltenSaltNetwork> foundNetworks = new ArrayList<MoltenSaltNetwork>();
            for (Direction dir : Direction.values()) {
                IMoltenSaltPipe pipe;
                BlockEntity facing = this.f_58857_.m_7702_(new BlockPos((Vec3i)this.f_58858_).m_142300_(dir));
                BlockEntity blockEntity = facing;
                if (!(blockEntity instanceof IMoltenSaltPipe) || !((blockEntity = (pipe = (IMoltenSaltPipe)blockEntity).getNetwork()) instanceof MoltenSaltNetwork)) continue;
                MoltenSaltNetwork net = (MoltenSaltNetwork)blockEntity;
                foundNetworks.add(net);
            }
            if (!foundNetworks.isEmpty()) {
                ((MoltenSaltNetwork)((Object)foundNetworks.get((int)0))).conductorSet.add(this);
                this.moltenSaltNetwork = (MoltenSaltNetwork)((Object)foundNetworks.get(0));
                if (foundNetworks.size() > 1) {
                    foundNetworks.remove(0);
                    for (MoltenSaltNetwork network : foundNetworks) {
                        this.getNetwork().merge(network);
                    }
                }
            }
            this.getNetwork().refresh();
        }
    }

    @Override
    public void removeFromNetwork() {
        if (this.moltenSaltNetwork != null) {
            this.moltenSaltNetwork.removeFromNetwork(this);
        }
    }

    public boolean updateAdjacent() {
        boolean flag = false;
        for (Direction dir : Direction.values()) {
            boolean is;
            BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_.m_142300_(dir));
            boolean bl = is = tile instanceof IMoltenSaltPipe || tile instanceof TileHeatExchanger;
            if (this.connections[dir.ordinal()] == is) continue;
            this.connections[dir.ordinal()] = is;
            this.tileConnections[dir.ordinal()] = tile;
            flag = true;
        }
        return flag;
    }

    public BlockEntity[] getAdjacentConnections() {
        return this.tileConnections;
    }

    @Override
    public void refreshNetworkIfChange() {
        if (this.updateAdjacent()) {
            this.refreshNetwork();
        }
    }

    @Override
    public void destroyViolently() {
    }

    public void m_7651_() {
        if (!this.f_58857_.f_46443_ && this.moltenSaltNetwork != null) {
            this.getNetwork().split(this);
        }
        super.m_7651_();
    }

    public void onChunkUnloaded() {
        if (!this.f_58857_.f_46443_ && this.moltenSaltNetwork != null) {
            this.getNetwork().split(this);
        }
    }

    public void onLoad() {
        super.onLoad();
        Scheduler.schedule((int)1, this::refreshNetwork);
    }

    protected abstract void writeCustomPacket(CompoundTag var1);

    protected abstract void readCustomPacket(CompoundTag var1);
}

