/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.compatability.jei;

import com.google.common.collect.ImmutableSet;
import electrodynamics.client.screen.ScreenO2OProcessor;
import electrodynamics.compatability.jei.ElectrodynamicsJEIPlugin;
import electrodynamics.compatability.jei.recipecategories.psuedo.PsuedoItem2ItemRecipe;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import nuclearscience.client.screen.ScreenChemicalExtractor;
import nuclearscience.client.screen.ScreenGasCentrifuge;
import nuclearscience.client.screen.ScreenMSRFuelPreProcessor;
import nuclearscience.client.screen.ScreenNuclearBoiler;
import nuclearscience.client.screen.ScreenParticleInjector;
import nuclearscience.client.screen.ScreenRadioactiveProcessor;
import nuclearscience.client.screen.ScreenReactorCore;
import nuclearscience.common.recipe.NuclearScienceRecipeInit;
import nuclearscience.compatability.jei.recipecategories.fluiditem2fluid.specificmachines.NuclearBoilerRecipeCategory;
import nuclearscience.compatability.jei.recipecategories.fluiditem2item.specificmachines.ChemicalExtractorRecipeCategory;
import nuclearscience.compatability.jei.recipecategories.fluiditem2item.specificmachines.MSRProcessorRecipeCategory;
import nuclearscience.compatability.jei.recipecategories.fluiditem2item.specificmachines.RadioactiveProcessorRecipeCategory;
import nuclearscience.compatability.jei.recipecategories.item2item.FissionReactorRecipeCategory;
import nuclearscience.compatability.jei.recipecategories.item2item.FuelReprocessorRecipeCategory;
import nuclearscience.compatability.jei.recipecategories.psuedo.specificmachines.GasCentrifugeRecipeCategory;
import nuclearscience.compatability.jei.recipecategories.psuedo.specificmachines.ParticleAcceleratorAntiMatterRecipeCategory;
import nuclearscience.compatability.jei.recipecategories.psuedo.specificmachines.ParticleAcceleratorDarkMatterRecipeCategory;
import nuclearscience.compatability.jei.utils.psuedorecipes.NuclearSciencePsuedoRecipes;
import nuclearscience.compatability.jei.utils.psuedorecipes.PsuedoGasCentrifugeRecipe;

@JeiPlugin
public class NuclearSciencePlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("nuclearscience", "nucsci_jei_plugin");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(GasCentrifugeRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{GasCentrifugeRecipeCategory.UID});
        registration.addRecipeCatalyst(NuclearBoilerRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{NuclearBoilerRecipeCategory.UID});
        registration.addRecipeCatalyst(ChemicalExtractorRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{ChemicalExtractorRecipeCategory.UID});
        registration.addRecipeCatalyst(FissionReactorRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{FissionReactorRecipeCategory.UID});
        registration.addRecipeCatalyst(ParticleAcceleratorAntiMatterRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{ParticleAcceleratorAntiMatterRecipeCategory.UID});
        registration.addRecipeCatalyst(ParticleAcceleratorDarkMatterRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{ParticleAcceleratorDarkMatterRecipeCategory.UID});
        registration.addRecipeCatalyst(FuelReprocessorRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{FuelReprocessorRecipeCategory.UID});
        registration.addRecipeCatalyst(RadioactiveProcessorRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{RadioactiveProcessorRecipeCategory.UID});
        registration.addRecipeCatalyst(MSRProcessorRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{MSRProcessorRecipeCategory.UID});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        NuclearSciencePsuedoRecipes.addNuclearScienceRecipes();
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = Objects.requireNonNull(mc.f_91073_);
        RecipeManager recipeManager = world.m_7465_();
        HashSet<PsuedoGasCentrifugeRecipe> gasCentrifugeRecipes = new HashSet<PsuedoGasCentrifugeRecipe>(NuclearSciencePsuedoRecipes.GAS_CENTRIFUGE_RECIPES);
        registration.addRecipes(gasCentrifugeRecipes, GasCentrifugeRecipeCategory.UID);
        ImmutableSet nuclearBoilerRecipes = ImmutableSet.copyOf((Collection)recipeManager.m_44013_(NuclearScienceRecipeInit.NUCLEAR_BOILER_TYPE));
        registration.addRecipes((Collection)nuclearBoilerRecipes, NuclearBoilerRecipeCategory.UID);
        ImmutableSet chemicalExtractorRecipes = ImmutableSet.copyOf((Collection)recipeManager.m_44013_(NuclearScienceRecipeInit.CHEMICAL_EXTRACTOR_TYPE));
        registration.addRecipes((Collection)chemicalExtractorRecipes, ChemicalExtractorRecipeCategory.UID);
        ImmutableSet fissionReactorRecipes = ImmutableSet.copyOf((Collection)recipeManager.m_44013_(NuclearScienceRecipeInit.FISSION_REACTOR_TYPE));
        registration.addRecipes((Collection)fissionReactorRecipes, FissionReactorRecipeCategory.UID);
        HashSet<PsuedoItem2ItemRecipe> antiMatterRecipes = new HashSet<PsuedoItem2ItemRecipe>(NuclearSciencePsuedoRecipes.ANTI_MATTER_RECIPES);
        registration.addRecipes(antiMatterRecipes, ParticleAcceleratorAntiMatterRecipeCategory.UID);
        HashSet<PsuedoItem2ItemRecipe> darkMatterRecipes = new HashSet<PsuedoItem2ItemRecipe>(NuclearSciencePsuedoRecipes.DARK_MATTER_RECIPES);
        registration.addRecipes(darkMatterRecipes, ParticleAcceleratorDarkMatterRecipeCategory.UID);
        ImmutableSet fuelReprocessorRecipes = ImmutableSet.copyOf((Collection)recipeManager.m_44013_(NuclearScienceRecipeInit.FUEL_REPROCESSOR_TYPE));
        registration.addRecipes((Collection)fuelReprocessorRecipes, FuelReprocessorRecipeCategory.UID);
        ImmutableSet radioactiveProcessorRecipes = ImmutableSet.copyOf((Collection)recipeManager.m_44013_(NuclearScienceRecipeInit.RADIOACTIVE_PROCESSOR_TYPE));
        registration.addRecipes((Collection)radioactiveProcessorRecipes, RadioactiveProcessorRecipeCategory.UID);
        ImmutableSet msrProcessorRecipes = ImmutableSet.copyOf((Collection)recipeManager.m_44013_(NuclearScienceRecipeInit.MSR_FUEL_PREPROCESSOR_TYPE));
        registration.addRecipes((Collection)msrProcessorRecipes, MSRProcessorRecipeCategory.UID);
        NuclearSciencePlugin.nuclearScienceInfoTabs(registration);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new GasCentrifugeRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new NuclearBoilerRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ChemicalExtractorRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FissionReactorRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ParticleAcceleratorAntiMatterRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ParticleAcceleratorDarkMatterRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FuelReprocessorRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new RadioactiveProcessorRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new MSRProcessorRecipeCategory(helper)});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addRecipeClickArea(ScreenO2OProcessor.class, 85, 35, 22, 15, ElectrodynamicsJEIPlugin.O2O_CLICK_AREAS.toArray(new ResourceLocation[ElectrodynamicsJEIPlugin.O2O_CLICK_AREAS.size()]));
        registry.addRecipeClickArea(ScreenNuclearBoiler.class, 97, 31, 22, 15, new ResourceLocation[]{NuclearBoilerRecipeCategory.UID});
        registry.addRecipeClickArea(ScreenRadioactiveProcessor.class, 97, 31, 22, 15, new ResourceLocation[]{RadioactiveProcessorRecipeCategory.UID});
        registry.addRecipeClickArea(ScreenChemicalExtractor.class, 97, 31, 22, 15, new ResourceLocation[]{ChemicalExtractorRecipeCategory.UID});
        registry.addRecipeClickArea(ScreenGasCentrifuge.class, 91, 22, 32, 41, new ResourceLocation[]{GasCentrifugeRecipeCategory.UID});
        registry.addRecipeClickArea(ScreenReactorCore.class, 117, 43, 14, 13, new ResourceLocation[]{FissionReactorRecipeCategory.UID});
        registry.addRecipeClickArea(ScreenParticleInjector.class, 102, 33, 28, 14, new ResourceLocation[]{ParticleAcceleratorAntiMatterRecipeCategory.UID, ParticleAcceleratorDarkMatterRecipeCategory.UID});
        registry.addRecipeClickArea(ScreenMSRFuelPreProcessor.class, 98, 40, 16, 16, new ResourceLocation[]{MSRProcessorRecipeCategory.UID});
    }

    private static void nuclearScienceInfoTabs(IRecipeRegistration registration) {
        for (ItemStack itemStack : NuclearSciencePsuedoRecipes.INFO_ITEMS) {
            String temp = itemStack.m_41720_().toString();
            registration.addIngredientInfo((Object)itemStack, VanillaTypes.ITEM, new Component[]{new TranslatableComponent("info.jei.block." + temp)});
        }
    }
}

