/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.compatability.jei.recipecategories.psuedo.specificmachines;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import nuclearscience.DeferredRegisters;
import nuclearscience.compatability.jei.utils.psuedorecipes.PsuedoGasCentrifugeRecipe;

public class GasCentrifugeRecipeCategory
implements IRecipeCategory<PsuedoGasCentrifugeRecipe> {
    public static final int INPUT_FLUID_STACK_SLOT = 0;
    public static final int OUTPUT_1_ITEM_SLOT = 1;
    public static final int OUTPUT_2_ITEM_SLOT = 2;
    private static int[] GUI_BACKGROUND = new int[]{0, 0, 132, 61};
    private static int ANIMATION_TIME = 100;
    private static int DESC_Y_HEIGHT = 70;
    private static String MOD_ID = "nuclearscience";
    private static String RECIPE_GROUP = "gas_centrifuge";
    private static String GUI_TEXTURE = "textures/gui/jei/gas_centrifuge_gui.png";
    public static ItemStack INPUT_MACHINE = new ItemStack((ItemLike)DeferredRegisters.blockGasCentrifuge);
    private LoadingCache<Integer, ArrayList<IDrawableAnimated>> arrowCache;
    private LoadingCache<Integer, ArrayList<IDrawableStatic>> fluidBarCache;
    public static ResourceLocation UID = new ResourceLocation(MOD_ID, RECIPE_GROUP);
    private IDrawable BACKGROUND;
    private IDrawable ICON;

    public GasCentrifugeRecipeCategory(final IGuiHelper guiHelper) {
        this.ICON = guiHelper.createDrawableIngredient((Object)INPUT_MACHINE);
        this.BACKGROUND = guiHelper.createDrawable(new ResourceLocation(MOD_ID, GUI_TEXTURE), GUI_BACKGROUND[0], GUI_BACKGROUND[1], GUI_BACKGROUND[2], GUI_BACKGROUND[3]);
        final ResourceLocation guiTexture = new ResourceLocation(MOD_ID, GUI_TEXTURE);
        this.arrowCache = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, ArrayList<IDrawableAnimated>>(){

            public ArrayList<IDrawableAnimated> load(Integer cookTime) {
                IDrawableAnimated distillArrow = guiHelper.drawableBuilder(guiTexture, 0, 70, 27, 47).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
                IDrawableAnimated condArrow = guiHelper.drawableBuilder(guiTexture, 27, 70, 46, 55).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
                IDrawableAnimated uF6FluidBar = guiHelper.drawableBuilder(guiTexture, 180, 0, 16, 50).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.TOP, false);
                IDrawableAnimated u235FluidBar = guiHelper.drawableBuilder(guiTexture, 148, 0, 16, 22).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.BOTTOM, false);
                IDrawableAnimated u238FluidBar = guiHelper.drawableBuilder(guiTexture, 164, 0, 16, 22).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.BOTTOM, false);
                IDrawableAnimated[] arrows = new IDrawableAnimated[]{distillArrow, condArrow, uF6FluidBar, u235FluidBar, u238FluidBar};
                return new ArrayList<IDrawableAnimated>(Arrays.asList(arrows));
            }
        });
        this.fluidBarCache = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, ArrayList<IDrawableStatic>>(){

            public ArrayList<IDrawableStatic> load(Integer fluidHeight) {
                IDrawableStatic fluidBar = guiHelper.drawableBuilder(guiTexture, 132, 0, 16, 50).build();
                IDrawableStatic[] fluidBars = new IDrawableStatic[]{fluidBar};
                return new ArrayList<IDrawableStatic>(Arrays.asList(fluidBars));
            }
        });
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends PsuedoGasCentrifugeRecipe> getRecipeClass() {
        return PsuedoGasCentrifugeRecipe.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("gui.jei.category." + RECIPE_GROUP);
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    public void setIngredients(PsuedoGasCentrifugeRecipe recipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.FLUID, this.getFluids(recipe));
        ingredients.setOutputs(VanillaTypes.ITEM, this.getOutputs(recipe));
    }

    public void setRecipe(IRecipeLayout recipeLayout, PsuedoGasCentrifugeRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(1, false, 107, 11);
        guiItemStacks.init(2, false, 107, 32);
        guiFluidStacks.init(0, true, 3, 5, 16, 50, 5000, false, null);
        guiItemStacks.set(ingredients);
        guiFluidStacks.set(ingredients);
    }

    public void draw(PsuedoGasCentrifugeRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        ArrayList fluidBars = (ArrayList)this.fluidBarCache.getUnchecked((Object)ANIMATION_TIME);
        ((IDrawableStatic)fluidBars.get(0)).draw(matrixStack, 3, 5);
        ArrayList arrows = (ArrayList)this.arrowCache.getUnchecked((Object)ANIMATION_TIME);
        ((IDrawableAnimated)arrows.get(0)).draw(matrixStack, 22, 7);
        ((IDrawableAnimated)arrows.get(1)).draw(matrixStack, 70, 3);
        ((IDrawableAnimated)arrows.get(2)).draw(matrixStack, 3, 5);
        ((IDrawableAnimated)arrows.get(3)).draw(matrixStack, 51, 4);
        ((IDrawableAnimated)arrows.get(4)).draw(matrixStack, 51, 35);
        int animTimeSeconds = ANIMATION_TIME / 20;
        TranslatableComponent indivU235String = new TranslatableComponent("gui.jei.category." + RECIPE_GROUP + ".info.indiv_u235", new Object[]{animTimeSeconds});
        TranslatableComponent indivU238String = new TranslatableComponent("gui.jei.category." + RECIPE_GROUP + ".info.indiv_u238", new Object[]{animTimeSeconds});
        TranslatableComponent percentU235String = new TranslatableComponent("gui.jei.category." + RECIPE_GROUP + ".info.percent_u235", new Object[]{animTimeSeconds});
        TranslatableComponent percentU238String = new TranslatableComponent("gui.jei.category." + RECIPE_GROUP + ".info.percent_u238", new Object[]{animTimeSeconds});
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        int indivU235StringWidth = fontRenderer.m_92852_((FormattedText)indivU235String);
        int indivU238StringWidth = fontRenderer.m_92852_((FormattedText)indivU238String);
        int percentU238StringWidth = fontRenderer.m_92852_((FormattedText)percentU238String);
        int percentU235StringWidth = fontRenderer.m_92852_((FormattedText)percentU235String);
        fontRenderer.m_92889_(matrixStack, (Component)indivU238String, (float)(this.getBackground().getWidth() - indivU238StringWidth - 27), (float)(DESC_Y_HEIGHT - 27), -10395295);
        fontRenderer.m_92889_(matrixStack, (Component)percentU238String, (float)(this.getBackground().getWidth() - percentU238StringWidth - 27), (float)(DESC_Y_HEIGHT - 37), -10395295);
        fontRenderer.m_92889_(matrixStack, (Component)indivU235String, (float)(this.getBackground().getWidth() - indivU235StringWidth - 27), (float)(DESC_Y_HEIGHT - 59), -10395295);
        fontRenderer.m_92889_(matrixStack, (Component)percentU235String, (float)(this.getBackground().getWidth() - percentU235StringWidth - 27), (float)(DESC_Y_HEIGHT - 49), -10395295);
    }

    public NonNullList<FluidStack> getFluids(PsuedoGasCentrifugeRecipe recipe) {
        NonNullList fluids = NonNullList.m_122779_();
        fluids.add((Object)recipe.inputFluidStack);
        return fluids;
    }

    public List<ItemStack> getOutputs(PsuedoGasCentrifugeRecipe recipe) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        outputs.add(recipe.output1);
        outputs.add(recipe.output2);
        return outputs;
    }
}

