/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.compatability.jei.recipecategories.psuedo.specificmachines;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import electrodynamics.compatability.jei.recipecategories.psuedo.PsuedoItem2ItemRecipe;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import nuclearscience.DeferredRegisters;

public class ParticleAcceleratorAntiMatterRecipeCategory
implements IRecipeCategory<PsuedoItem2ItemRecipe> {
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private static final int ANY_ITEM_INPUT_SLOT = 2;
    private static int[] GUI_BACKGROUND = new int[]{0, 0, 132, 66};
    private static int[] PROCESSING_ARROW_COORDS = new int[]{0, 67, 82, 47};
    private static int[] INPUT_OFFSET = new int[]{12, 39};
    private static int[] OUTPUT_OFFSET = new int[]{101, 20};
    private static int[] PROCESSING_ARROW_OFFSET = new int[]{17, 6};
    private static int ANIM_TIME = 50;
    private static int DESC_Y_HEIGHT = 58;
    private static String MOD_ID = "nuclearscience";
    private static String RECIPE_GROUP = "partical_accelerator_antimatter";
    private static String GUI_TEXTURE = "textures/gui/jei/particle_accelerator_antimatter_gui.png";
    public static ItemStack INPUT_MACHINE = new ItemStack((ItemLike)DeferredRegisters.blockParticleInjector);
    private LoadingCache<Integer, IDrawableAnimated> cachedArrows;
    private static IDrawableAnimated.StartDirection ARROW_START_DIRECTION = IDrawableAnimated.StartDirection.LEFT;
    public static ResourceLocation UID = new ResourceLocation(MOD_ID, RECIPE_GROUP);
    private IDrawable BACKGROUND;
    private IDrawable ICON;

    public ParticleAcceleratorAntiMatterRecipeCategory(final IGuiHelper guiHelper) {
        this.ICON = guiHelper.createDrawableIngredient((Object)INPUT_MACHINE);
        this.BACKGROUND = guiHelper.createDrawable(new ResourceLocation(MOD_ID, GUI_TEXTURE), GUI_BACKGROUND[0], GUI_BACKGROUND[1], GUI_BACKGROUND[2], GUI_BACKGROUND[3]);
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return guiHelper.drawableBuilder(new ResourceLocation(MOD_ID, GUI_TEXTURE), PROCESSING_ARROW_COORDS[0], PROCESSING_ARROW_COORDS[1], PROCESSING_ARROW_COORDS[2], PROCESSING_ARROW_COORDS[3]).buildAnimated(cookTime.intValue(), ARROW_START_DIRECTION, false);
            }
        });
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends PsuedoItem2ItemRecipe> getRecipeClass() {
        return PsuedoItem2ItemRecipe.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("gui.jei.category." + RECIPE_GROUP);
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    public void setIngredients(PsuedoItem2ItemRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, ParticleAcceleratorAntiMatterRecipeCategory.recipeInput(recipe));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.OUTPUT);
    }

    public void setRecipe(IRecipeLayout recipeLayout, PsuedoItem2ItemRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, INPUT_OFFSET[0], INPUT_OFFSET[1]);
        guiItemStacks.init(2, true, 12, 2);
        guiItemStacks.init(1, false, OUTPUT_OFFSET[0], OUTPUT_OFFSET[1]);
        guiItemStacks.set(ingredients);
    }

    public void draw(PsuedoItem2ItemRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        IDrawableAnimated arrow = (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)ANIM_TIME);
        arrow.draw(matrixStack, PROCESSING_ARROW_OFFSET[0], PROCESSING_ARROW_OFFSET[1]);
        int animTimeSeconds = ANIM_TIME / 20;
        TranslatableComponent timeString = new TranslatableComponent("gui.jei.category." + RECIPE_GROUP + ".info.power", new Object[]{animTimeSeconds});
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        float stringWidth = fontRenderer.m_92852_((FormattedText)timeString);
        fontRenderer.m_92889_(matrixStack, (Component)timeString, (float)this.getBackground().getWidth() - stringWidth, (float)DESC_Y_HEIGHT, -8355712);
    }

    private static List<List<ItemStack>> recipeInput(PsuedoItem2ItemRecipe recipe) {
        ArrayList<ItemStack> emagCell = new ArrayList<ItemStack>();
        emagCell.add(((Ingredient)recipe.INPUTS.get(0)).m_43908_()[0]);
        int i = 0;
        ArrayList allItems = new ArrayList(ForgeRegistries.ITEMS.getValues());
        ArrayList<Object> vanillaItems = new ArrayList<Object>();
        CreativeModeTab[] vanillaItemGroups = new CreativeModeTab[]{CreativeModeTab.f_40758_, CreativeModeTab.f_40749_, CreativeModeTab.f_40757_, CreativeModeTab.f_40750_, CreativeModeTab.f_40755_, CreativeModeTab.f_40753_, CreativeModeTab.f_40751_, CreativeModeTab.f_40756_, CreativeModeTab.f_40752_};
        block0: for (Object item : allItems) {
            for (i = 0; i < vanillaItemGroups.length; ++i) {
                if (item.m_41471_() != vanillaItemGroups[i]) continue;
                vanillaItems.add(item);
                continue block0;
            }
        }
        for (Object item : vanillaItems) {
            if (!(item instanceof AirItem)) continue;
            vanillaItems.remove(item);
        }
        ArrayList<ItemStack> vanillaItemStacks = new ArrayList<ItemStack>();
        for (Item item : vanillaItems) {
            vanillaItemStacks.add(new ItemStack((ItemLike)item));
        }
        ArrayList<List<ItemStack>> inputSlots = new ArrayList<List<ItemStack>>();
        inputSlots.add(emagCell);
        inputSlots.add(vanillaItemStacks);
        return inputSlots;
    }
}

