/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.compatability.jei.recipecategories.psuedo.specificmachines;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import electrodynamics.compatability.jei.recipecategories.psuedo.PsuedoItem2ItemRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import nuclearscience.DeferredRegisters;

public class ParticleAcceleratorDarkMatterRecipeCategory
implements IRecipeCategory<PsuedoItem2ItemRecipe> {
    public static final int OUTPUT_SLOT = 0;
    private static int[] GUI_BACKGROUND = new int[]{0, 0, 132, 132};
    private static int[] OUTPUT_OFFSET = new int[]{57, 57};
    public static int ANIM_TIME = 50;
    private static int DESC_Y_HEIGHT = 122;
    private static String MOD_ID = "nuclearscience";
    private static String RECIPE_GROUP = "partical_accelerator_darkmatter";
    private static String GUI_TEXTURE = "textures/gui/jei/particle_accelerator_dark_matter_gui.png";
    public static ItemStack INPUT_MACHINE = new ItemStack((ItemLike)DeferredRegisters.blockParticleInjector);
    private LoadingCache<Integer, ArrayList<IDrawableAnimated>> cachedArrows;
    public static ResourceLocation UID = new ResourceLocation(MOD_ID, RECIPE_GROUP);
    private IDrawable BACKGROUND;
    private IDrawable ICON;

    public ParticleAcceleratorDarkMatterRecipeCategory(final IGuiHelper guiHelper) {
        this.ICON = guiHelper.createDrawableIngredient((Object)INPUT_MACHINE);
        this.BACKGROUND = guiHelper.createDrawable(new ResourceLocation(MOD_ID, GUI_TEXTURE), GUI_BACKGROUND[0], GUI_BACKGROUND[1], GUI_BACKGROUND[2], GUI_BACKGROUND[3]);
        final ResourceLocation guiTexture = new ResourceLocation(MOD_ID, GUI_TEXTURE);
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, ArrayList<IDrawableAnimated>>(){

            public ArrayList<IDrawableAnimated> load(Integer cookTime) {
                IDrawableAnimated majorArrowBottom = guiHelper.drawableBuilder(guiTexture, 179, 17, 37, 75).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.BOTTOM, false);
                IDrawableAnimated majorArrowTop = guiHelper.drawableBuilder(guiTexture, 132, 0, 37, 75).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.TOP, false);
                IDrawableAnimated[] arrows = new IDrawableAnimated[]{majorArrowBottom, majorArrowTop};
                return new ArrayList<IDrawableAnimated>(Arrays.asList(arrows));
            }
        });
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends PsuedoItem2ItemRecipe> getRecipeClass() {
        return PsuedoItem2ItemRecipe.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("gui.jei.category." + RECIPE_GROUP);
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    public void setIngredients(PsuedoItem2ItemRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.INPUTS);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.OUTPUT);
    }

    public void setRecipe(IRecipeLayout recipeLayout, PsuedoItem2ItemRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, OUTPUT_OFFSET[0], OUTPUT_OFFSET[1]);
        guiItemStacks.set(ingredients);
    }

    public void draw(PsuedoItem2ItemRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        ArrayList arrow = (ArrayList)this.cachedArrows.getUnchecked((Object)ANIM_TIME);
        ((IDrawableAnimated)arrow.get(0)).draw(matrixStack, 70, 38);
        ((IDrawableAnimated)arrow.get(1)).draw(matrixStack, 23, 21);
        int animTimeSeconds = ANIM_TIME / 20;
        TranslatableComponent timeString = new TranslatableComponent("gui.jei.category." + RECIPE_GROUP + ".info.power", new Object[]{animTimeSeconds});
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        float stringWidth = fontRenderer.m_92852_((FormattedText)timeString);
        fontRenderer.m_92889_(matrixStack, (Component)timeString, (float)this.getBackground().getWidth() - stringWidth, (float)DESC_Y_HEIGHT, -8355712);
    }
}

