/*
 * Decompiled with CFR 0.152.
 */
package pm.c7.scout.item;

import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketItem;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5632;
import org.jetbrains.annotations.Nullable;
import pm.c7.scout.ScoutNetworking;
import pm.c7.scout.ScoutPlayerScreenHandler;
import pm.c7.scout.ScoutUtil;
import pm.c7.scout.item.BagTooltipData;
import pm.c7.scout.screen.BagSlot;

public class BaseBagItem
extends TrinketItem {
    private static final String ITEMS_KEY = "Items";
    private final int slots;
    private final BagType type;

    public BaseBagItem(class_1792.class_1793 settings, int slots, BagType type) {
        super(settings);
        if (type == BagType.SATCHEL && slots > 18) {
            throw new IllegalArgumentException("Satchel has too many slots.");
        }
        if (type == BagType.POUCH && slots > 6) {
            throw new IllegalArgumentException("Pouch has too many slots.");
        }
        this.slots = slots;
        this.type = type;
    }

    public int getSlotCount() {
        return this.slots;
    }

    public BagType getType() {
        return this.type;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.scout.slots", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(this.slots)).method_27692(class_124.field_1078)}).method_27692(class_124.field_1080));
    }

    public class_1263 getInventory(final class_1799 stack) {
        class_1277 inventory = new class_1277(this.slots){

            public void method_5431() {
                stack.method_7948().method_10566(BaseBagItem.ITEMS_KEY, (class_2520)ScoutUtil.inventoryToTag(this));
                super.method_5431();
            }
        };
        class_2487 compound = stack.method_7948();
        if (!compound.method_10545(ITEMS_KEY)) {
            compound.method_10566(ITEMS_KEY, (class_2520)new class_2499());
        }
        class_2499 items = compound.method_10554(ITEMS_KEY, 10);
        ScoutUtil.inventoryFromTag(items, inventory);
        return inventory;
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        class_2371 stacks = class_2371.method_10211();
        class_1263 inventory = this.getInventory(stack);
        for (int i = 0; i < this.slots; ++i) {
            stacks.add((Object)inventory.method_5438(i));
        }
        if (stacks.stream().allMatch(class_1799::method_7960)) {
            return Optional.empty();
        }
        return Optional.of(new BagTooltipData((class_2371<class_1799>)stacks, this.slots));
    }

    public void onEquip(class_1799 stack, SlotReference slotRef, class_1309 entity) {
        class_1657 player = (class_1657)entity;
        ScoutPlayerScreenHandler handler = (ScoutPlayerScreenHandler)player.field_7498;
        int slotIndex = slotRef.index();
        class_1263 inventory = this.getInventory(stack);
        class_2371<BagSlot> bagSlots = class_2371.method_10211();
        if (this.type == BagType.SATCHEL) {
            bagSlots = handler.scout$getSatchelSlots();
        } else if (this.type == BagType.POUCH) {
            if (slotIndex == 0) {
                bagSlots = handler.scout$getLeftPouchSlots();
            } else if (slotIndex == 1) {
                bagSlots = handler.scout$getRightPouchSlots();
            }
        }
        for (int i = 0; i < this.slots; ++i) {
            BagSlot slot = (BagSlot)((Object)bagSlots.get(i));
            slot.setInventory(inventory);
            slot.setEnabled(true);
        }
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeBoolean(true);
        packet.writeInt(slotIndex);
        packet.method_10793(stack);
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)ScoutNetworking.ENABLE_SLOTS, (class_2540)packet);
        }
    }

    public void onUnequip(class_1799 stack, SlotReference slotRef, class_1309 entity) {
        class_1657 player = (class_1657)entity;
        ScoutPlayerScreenHandler handler = (ScoutPlayerScreenHandler)player.field_7498;
        int slotIndex = slotRef.index();
        class_2371<BagSlot> bagSlots = class_2371.method_10211();
        if (this.type == BagType.SATCHEL) {
            bagSlots = handler.scout$getSatchelSlots();
        } else if (this.type == BagType.POUCH) {
            if (slotIndex == 0) {
                bagSlots = handler.scout$getLeftPouchSlots();
            } else if (slotIndex == 1) {
                bagSlots = handler.scout$getRightPouchSlots();
            }
        }
        for (int i = 0; i < this.slots; ++i) {
            BagSlot slot = (BagSlot)((Object)bagSlots.get(i));
            slot.setInventory(null);
            slot.setEnabled(false);
        }
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeBoolean(false);
        packet.writeInt(slotIndex);
        packet.method_10793(stack);
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)ScoutNetworking.ENABLE_SLOTS, (class_2540)packet);
        }
    }

    public static enum BagType {
        SATCHEL,
        POUCH;

    }
}

