/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.undergroundvillages.jigsaw;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class CustomJigsawPlacement {
    static final Logger LOGGER = LogUtils.getLogger();

    public static Optional<PieceGenerator<JigsawConfiguration>> addPieces(PieceGeneratorSupplier.Context<JigsawConfiguration> context, PieceFactory factory, BlockPos pos, boolean p_210288_, boolean p_210289_) {
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
        RegistryAccess registryaccess = context.f_197360_();
        JigsawConfiguration jigsawconfiguration = (JigsawConfiguration)context.f_197356_();
        ChunkGenerator chunkgenerator = context.f_197352_();
        StructureManager structuremanager = context.f_197359_();
        LevelHeightAccessor levelheightaccessor = context.f_197357_();
        Predicate predicate = context.f_197358_();
        StructureFeature.m_67096_();
        Registry registry = registryaccess.m_175515_(Registry.f_122884_);
        Rotation rotation = Rotation.m_55956_((Random)worldgenrandom);
        StructureTemplatePool structuretemplatepool = (StructureTemplatePool)jigsawconfiguration.m_204802_().m_203334_();
        StructurePoolElement structurepoolelement = structuretemplatepool.m_210585_((Random)worldgenrandom);
        if (structurepoolelement == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        PoolElementStructurePiece poolelementstructurepiece = factory.create(structuremanager, structurepoolelement, pos, structurepoolelement.m_210540_(), rotation, structurepoolelement.m_207470_(structuremanager, pos, rotation));
        BoundingBox boundingbox = poolelementstructurepiece.m_73547_();
        int i = (boundingbox.m_162399_() + boundingbox.m_162395_()) / 2;
        int j = (boundingbox.m_162401_() + boundingbox.m_162398_()) / 2;
        int k = pos.m_123342_();
        if (!predicate.test(chunkgenerator.m_203495_(QuartPos.m_175400_((int)i), QuartPos.m_175400_((int)k), QuartPos.m_175400_((int)j)))) {
            return Optional.empty();
        }
        int l = boundingbox.m_162396_() + poolelementstructurepiece.m_72647_();
        poolelementstructurepiece.m_6324_(0, k - l, 0);
        return Optional.of((p_210282_, p_210283_) -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolelementstructurepiece);
            if (jigsawconfiguration.m_67765_() > 0) {
                int i1 = 80;
                AABB aabb = new AABB((double)(i - i1), (double)(k - i1), (double)(j - i1), (double)(i + i1 + 1), (double)(k + i1 + 1), (double)(j + i1 + 1));
                Placer jigsawplacement$placer = new Placer((Registry<StructureTemplatePool>)registry, jigsawconfiguration.m_67765_(), factory, chunkgenerator, structuremanager, list, (Random)worldgenrandom);
                jigsawplacement$placer.placing.addLast(new PieceState(poolelementstructurepiece, (MutableObject<VoxelShape>)new MutableObject((Object)Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)aabb), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox)), (BooleanOp)BooleanOp.f_82685_)), 0));
                while (!jigsawplacement$placer.placing.isEmpty()) {
                    PieceState jigsawplacement$piecestate = jigsawplacement$placer.placing.removeFirst();
                    jigsawplacement$placer.tryPlacingChildren(jigsawplacement$piecestate.piece, jigsawplacement$piecestate.free, jigsawplacement$piecestate.depth, p_210288_, levelheightaccessor);
                }
                list.forEach(arg_0 -> ((StructurePiecesBuilder)p_210282_).m_142679_(arg_0));
            }
        });
    }

    public static void addPieces(RegistryAccess registryAccess, PoolElementStructurePiece piece, int maxDepth, PieceFactory factory, ChunkGenerator chunkGenerator, StructureManager structureManager, List<? super PoolElementStructurePiece> pieces, Random random, LevelHeightAccessor level) {
        Registry registry = registryAccess.m_175515_(Registry.f_122884_);
        Placer jigsawplacement$placer = new Placer((Registry<StructureTemplatePool>)registry, maxDepth, factory, chunkGenerator, structureManager, pieces, random);
        jigsawplacement$placer.placing.addLast(new PieceState(piece, (MutableObject<VoxelShape>)new MutableObject((Object)Shapes.f_83036_), 0));
        while (!jigsawplacement$placer.placing.isEmpty()) {
            PieceState jigsawplacement$piecestate = jigsawplacement$placer.placing.removeFirst();
            jigsawplacement$placer.tryPlacingChildren(jigsawplacement$piecestate.piece, jigsawplacement$piecestate.free, jigsawplacement$piecestate.depth, false, level);
        }
    }

    public static int getRandomBetween(Random random, int min, int max) {
        OptionalInt randomNumber = random.ints(min, max + 1).findFirst();
        return randomNumber.isPresent() ? randomNumber.getAsInt() : min;
    }

    public static interface PieceFactory {
        public PoolElementStructurePiece create(StructureManager var1, StructurePoolElement var2, BlockPos var3, int var4, Rotation var5, BoundingBox var6);
    }

    static final class Placer {
        private final Registry<StructureTemplatePool> pools;
        private final int maxDepth;
        private final PieceFactory factory;
        private final ChunkGenerator chunkGenerator;
        private final StructureManager structureManager;
        private final List<? super PoolElementStructurePiece> pieces;
        private final Random random;
        final Deque<PieceState> placing = Queues.newArrayDeque();

        Placer(Registry<StructureTemplatePool> pools, int maxDepth, PieceFactory factory, ChunkGenerator chunkGenerator, StructureManager structureManager, List<? super PoolElementStructurePiece> pieces, Random random) {
            this.pools = pools;
            this.maxDepth = maxDepth;
            this.factory = factory;
            this.chunkGenerator = chunkGenerator;
            this.structureManager = structureManager;
            this.pieces = pieces;
            this.random = random;
        }

        void tryPlacingChildren(PoolElementStructurePiece structurePiece, MutableObject<VoxelShape> p_210335_, int p_210336_, boolean p_210337_, LevelHeightAccessor level) {
            StructurePoolElement structurepoolelement = structurePiece.m_209918_();
            BlockPos blockpos = structurePiece.m_72646_();
            Rotation rotation = structurePiece.m_6830_();
            StructureTemplatePool.Projection structuretemplatepool$projection = structurepoolelement.m_210539_();
            MutableObject<VoxelShape> mutableobject = new MutableObject<VoxelShape>();
            BoundingBox boundingbox = structurePiece.m_73547_();
            int i = boundingbox.m_162396_();
            block0: for (StructureTemplate.StructureBlockInfo structuretemplate$structureblockinfo : structurepoolelement.m_207245_(this.structureManager, blockpos, rotation, this.random)) {
                Direction direction = JigsawBlock.m_54250_((BlockState)structuretemplate$structureblockinfo.f_74676_);
                BlockPos blockpos1 = structuretemplate$structureblockinfo.f_74675_;
                BlockPos blockpos2 = blockpos1.m_142300_(direction);
                int j = blockpos1.m_123342_() - i;
                int k = -1;
                ResourceLocation resourcelocation = new ResourceLocation(structuretemplate$structureblockinfo.f_74677_.m_128461_("pool"));
                Optional optional = this.pools.m_6612_(resourcelocation);
                if (optional.isPresent() && (((StructureTemplatePool)optional.get()).m_210590_() != 0 || Objects.equals(resourcelocation, Pools.f_127186_.m_135782_()))) {
                    ResourceLocation resourcelocation1 = ((StructureTemplatePool)optional.get()).m_210573_();
                    Optional optional1 = this.pools.m_6612_(resourcelocation1);
                    if (optional1.isPresent() && (((StructureTemplatePool)optional1.get()).m_210590_() != 0 || Objects.equals(resourcelocation1, Pools.f_127186_.m_135782_()))) {
                        StructurePoolElement structurepoolelement1;
                        MutableObject<VoxelShape> mutableobject1;
                        boolean flag1 = boundingbox.m_71051_((Vec3i)blockpos2);
                        if (flag1) {
                            mutableobject1 = mutableobject;
                            if (mutableobject.getValue() == null) {
                                mutableobject.setValue((Object)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox)));
                            }
                        } else {
                            mutableobject1 = p_210335_;
                        }
                        ArrayList list = Lists.newArrayList();
                        if (p_210336_ != this.maxDepth) {
                            list.addAll(((StructureTemplatePool)optional.get()).m_210588_(this.random));
                        }
                        list.addAll(((StructureTemplatePool)optional1.get()).m_210588_(this.random));
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext() && (structurepoolelement1 = (StructurePoolElement)iterator.next()) != EmptyPoolElement.f_210175_) {
                            for (Rotation rotation1 : Rotation.m_55958_((Random)this.random)) {
                                List list1 = structurepoolelement1.m_207245_(this.structureManager, BlockPos.f_121853_, rotation1, this.random);
                                BoundingBox boundingbox1 = structurepoolelement1.m_207470_(this.structureManager, BlockPos.f_121853_, rotation1);
                                int l = boundingbox1.m_71057_() <= 16 ? list1.stream().mapToInt(structureBlockInfo -> {
                                    if (!boundingbox1.m_71051_((Vec3i)structureBlockInfo.f_74675_.m_142300_(JigsawBlock.m_54250_((BlockState)structureBlockInfo.f_74676_)))) {
                                        return 0;
                                    }
                                    ResourceLocation resourcelocation2 = new ResourceLocation(structureBlockInfo.f_74677_.m_128461_("pool"));
                                    Optional optional2 = this.pools.m_6612_(resourcelocation2);
                                    Optional<Integer> optional3 = optional2.flatMap(pool -> this.pools.m_6612_(pool.m_210573_()));
                                    int j3 = optional2.map(pool -> pool.m_210580_(this.structureManager)).orElse(0);
                                    int k3 = optional3.map(pool -> pool.m_210580_(this.structureManager)).orElse(0);
                                    return Math.max(j3, k3);
                                }).max().orElse(0) : 0;
                                for (StructureTemplate.StructureBlockInfo structuretemplate$structureblockinfo1 : list1) {
                                    if (!JigsawBlock.m_54245_((StructureTemplate.StructureBlockInfo)structuretemplate$structureblockinfo, (StructureTemplate.StructureBlockInfo)structuretemplate$structureblockinfo1)) continue;
                                    BlockPos blockpos3 = structuretemplate$structureblockinfo1.f_74675_;
                                    BlockPos blockpos4 = blockpos2.m_141950_((Vec3i)blockpos3);
                                    BoundingBox boundingbox2 = structurepoolelement1.m_207470_(this.structureManager, blockpos4, rotation1);
                                    int i1 = boundingbox2.m_162396_();
                                    StructureTemplatePool.Projection structuretemplatepool$projection1 = structurepoolelement1.m_210539_();
                                    int j1 = blockpos3.m_123342_();
                                    int k1 = j - j1 + JigsawBlock.m_54250_((BlockState)structuretemplate$structureblockinfo.f_74676_).m_122430_();
                                    int l1 = i + k1;
                                    int i2 = l1 - i1;
                                    BoundingBox boundingbox3 = boundingbox2.m_71045_(0, i2, 0);
                                    BlockPos blockpos5 = blockpos4.m_142082_(0, i2, 0);
                                    if (l > 0) {
                                        int j2 = Math.max(l + 1, boundingbox3.m_162400_() - boundingbox3.m_162396_());
                                        boundingbox3.m_162371_(new BlockPos(boundingbox3.m_162395_(), boundingbox3.m_162396_() + j2, boundingbox3.m_162398_()));
                                    }
                                    if (Shapes.m_83157_((VoxelShape)((VoxelShape)mutableobject1.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox3).m_82406_(0.25)), (BooleanOp)BooleanOp.f_82683_)) continue;
                                    mutableobject1.setValue((Object)Shapes.m_83148_((VoxelShape)((VoxelShape)mutableobject1.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox3)), (BooleanOp)BooleanOp.f_82685_));
                                    int i3 = structurePiece.m_72647_();
                                    int k2 = i3 - k1;
                                    PoolElementStructurePiece poolelementstructurepiece = this.factory.create(this.structureManager, structurepoolelement1, blockpos5, k2, rotation1, boundingbox3);
                                    if (k == -1) {
                                        k = blockpos1.m_123342_() + CustomJigsawPlacement.getRandomBetween(this.random, -3, 3);
                                    }
                                    int l2 = k + k1 / 2;
                                    structurePiece.m_209916_(new JigsawJunction(blockpos2.m_123341_(), l2 - j + i3, blockpos2.m_123343_(), k1, structuretemplatepool$projection1));
                                    poolelementstructurepiece.m_209916_(new JigsawJunction(blockpos1.m_123341_(), l2 - j1 + k2, blockpos1.m_123343_(), -k1, structuretemplatepool$projection));
                                    this.pieces.add((PoolElementStructurePiece)poolelementstructurepiece);
                                    if (p_210336_ + 1 > this.maxDepth) continue block0;
                                    this.placing.addLast(new PieceState(poolelementstructurepiece, mutableobject1, p_210336_ + 1));
                                    continue block0;
                                }
                            }
                        }
                        continue;
                    }
                    LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)resourcelocation1);
                    continue;
                }
                LOGGER.warn("Empty or non-existent pool: {}", (Object)resourcelocation);
            }
        }
    }

    static final class PieceState {
        final PoolElementStructurePiece piece;
        final MutableObject<VoxelShape> free;
        final int depth;

        PieceState(PoolElementStructurePiece piece, MutableObject<VoxelShape> free, int depth) {
            this.piece = piece;
            this.free = free;
            this.depth = depth;
        }
    }
}

