/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.client.render;

import dev.itsmeow.whisperwoods.imdlib.client.render.BaseRenderer;
import dev.itsmeow.whisperwoods.imdlib.entity.interfaces.IVariantTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1296;
import net.minecraft.class_1308;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_583;
import net.minecraft.class_897;
import net.minecraft.class_898;

public class ImplRenderer<T extends class_1308, A extends class_583<T>>
extends BaseRenderer<T, A> {
    private final TextureContainer<T, A> textureContainer;
    private final ModelContainer<T, A> modelContainer;
    private final PreRenderCallback<T> preRenderCallback;
    private final HandleRotation<T> handleRotation;
    private final ApplyRotations<T> applyRotations;
    private final SuperCallApplyRotations applyRotationsSuper;
    private final RenderLayer<T> renderLayer;

    public ImplRenderer(class_898 mgr, float shadow, TextureContainer<T, A> textureContainer, ModelContainer<T, A> modelContainer, PreRenderCallback<T> preRenderCallback, HandleRotation<T> handleRotation, ApplyRotations<T> applyRotations, SuperCallApplyRotations applyRotationsSuper, RenderLayer<T> renderLayer) {
        super(mgr, modelContainer.getBaseModel(), shadow);
        this.textureContainer = textureContainer;
        this.modelContainer = modelContainer;
        this.preRenderCallback = preRenderCallback;
        this.handleRotation = handleRotation;
        this.applyRotations = applyRotations;
        this.applyRotationsSuper = applyRotationsSuper;
        this.renderLayer = renderLayer;
    }

    public static <T extends class_1308, A extends class_583<T>> Builder<T, A> factory(String modid, float shadow) {
        return new Builder(modid, shadow);
    }

    private static class_2960 tex(String modid, String location) {
        return new class_2960(modid, "textures/entity/" + location + ".png");
    }

    protected void setupRotations(T e, class_4587 s, float a, float y, float p) {
        if (this.applyRotations == null) {
            super.method_4058(e, s, a, y, p);
        } else {
            if (this.applyRotationsSuper == SuperCallApplyRotations.PRE) {
                super.method_4058(e, s, a, y, p);
            }
            this.applyRotations.applyRotations(e, s, a, y, p);
            if (this.applyRotationsSuper == SuperCallApplyRotations.POST) {
                super.method_4058(e, s, a, y, p);
            }
        }
    }

    protected void scale(T e, class_4587 s, float p) {
        if (this.preRenderCallback != null) {
            this.preRenderCallback.preRenderCallback(e, s, p);
        }
    }

    protected float getBob(T e, float p) {
        return this.handleRotation == null ? super.method_4045(e, p) : this.handleRotation.handleRotation(e, p);
    }

    protected class_1921 getRenderType(T entity, boolean visible, boolean visibleToPlayer, boolean glowing) {
        return this.renderLayer == null ? super.method_24302(entity, visible, visibleToPlayer, glowing) : this.renderLayer.renderLayer(entity, visible, visibleToPlayer, glowing, this.getTextureLocation(entity));
    }

    public void method_4072(T e, float p_225623_2_, float p_225623_3_, class_4587 p_225623_4_, class_4597 p_225623_5_, int p_225623_6_) {
        this.field_4737 = this.modelContainer.getModel(e);
        super.method_4072(e, p_225623_2_, p_225623_3_, p_225623_4_, p_225623_5_, p_225623_6_);
    }

    public class_2960 getTextureLocation(T entity) {
        return this.textureContainer.getTexture(entity);
    }

    public static class ModelContainer<T extends class_1308, A extends class_583<T>> {
        private final Strategy strategy;
        private final A baseModel;
        private Function<T, class_583<T>> modelMapper;
        private A trueModel;
        private class_583<T> falseModel;
        private Predicate<T> condition;
        private class_583<T> conditionModel;

        public ModelContainer(A baseModel) {
            this.strategy = Strategy.SINGLE;
            this.baseModel = baseModel;
        }

        public ModelContainer(Function<T, class_583<T>> modelMapper, A baseModel) {
            this.strategy = Strategy.MAPPER;
            this.modelMapper = modelMapper;
            this.baseModel = baseModel;
        }

        public ModelContainer(Predicate<T> condition, Function<T, class_583<T>> modelMapper, A baseModel, class_583<T> conditionModel) {
            this.strategy = Strategy.MAPPER;
            this.modelMapper = modelMapper;
            this.baseModel = baseModel;
            this.conditionModel = conditionModel;
            this.condition = condition;
        }

        public ModelContainer(Predicate<T> condition, A trueModel, class_583<T> falseModel) {
            this.strategy = Strategy.CONDITION;
            this.condition = condition;
            this.trueModel = trueModel;
            this.falseModel = falseModel;
            this.baseModel = trueModel;
        }

        public class_583<T> getModel(T entity) {
            switch (this.strategy) {
                case SINGLE: {
                    return this.baseModel;
                }
                case MAPPER: {
                    return this.modelMapper.apply(entity);
                }
                case CONDITION: {
                    return this.condition.test(entity) ? this.trueModel : this.falseModel;
                }
                case MAPPER_CONDITION: {
                    return this.condition.test(entity) ? this.conditionModel : this.modelMapper.apply(entity);
                }
            }
            return null;
        }

        public A getBaseModel() {
            return this.baseModel;
        }
    }

    public static class TextureContainer<T extends class_1308, A extends class_583<T>> {
        private final Strategy strategy;
        private class_2960 singleTexture;
        private Function<T, class_2960> texMapper;
        private class_2960 trueTex;
        private class_2960 falseTex;
        private Predicate<T> condition;
        private class_2960 conditionTex;

        public TextureContainer(class_2960 singleTexture) {
            this.strategy = Strategy.SINGLE;
            this.singleTexture = singleTexture;
        }

        public TextureContainer(Function<T, class_2960> texMapper) {
            this.strategy = Strategy.MAPPER;
            this.texMapper = texMapper;
        }

        public TextureContainer(Predicate<T> condition, Function<T, class_2960> texMapper, class_2960 conditionTex) {
            this.strategy = Strategy.MAPPER_CONDITION;
            this.texMapper = texMapper;
            this.condition = condition;
            this.conditionTex = conditionTex;
        }

        public TextureContainer(Predicate<T> condition, class_2960 trueTex, class_2960 falseTex) {
            this.strategy = Strategy.CONDITION;
            this.condition = condition;
            this.trueTex = trueTex;
            this.falseTex = falseTex;
        }

        public class_2960 getTexture(T entity) {
            switch (this.strategy) {
                case SINGLE: {
                    return this.singleTexture;
                }
                case MAPPER: {
                    return this.texMapper.apply(entity);
                }
                case CONDITION: {
                    return this.condition.test(entity) ? this.trueTex : this.falseTex;
                }
                case MAPPER_CONDITION: {
                    return this.condition.test(entity) ? this.conditionTex : this.texMapper.apply(entity);
                }
            }
            return null;
        }
    }

    @FunctionalInterface
    public static interface PreRenderCallback<T extends class_1308> {
        public void preRenderCallback(T var1, class_4587 var2, float var3);
    }

    @FunctionalInterface
    public static interface HandleRotation<T extends class_1308> {
        public float handleRotation(T var1, float var2);
    }

    @FunctionalInterface
    public static interface ApplyRotations<T extends class_1308> {
        public void applyRotations(T var1, class_4587 var2, float var3, float var4, float var5);
    }

    public static enum SuperCallApplyRotations {
        PRE,
        NONE,
        POST;

    }

    @FunctionalInterface
    public static interface RenderLayer<T extends class_1308> {
        public class_1921 renderLayer(T var1, boolean var2, boolean var3, boolean var4, class_2960 var5);
    }

    public static class Builder<T extends class_1308, A extends class_583<T>> {
        private final String modid;
        private final float shadow;
        private final ArrayList<Function<BaseRenderer<T, A>, class_3887<T, A>>> layers = new ArrayList();
        private final Map<String, class_2960> texMapper = new HashMap<String, class_2960>();
        private final Map<Class<? extends class_583<T>>, class_583<T>> modelMapper = new HashMap<Class<? extends class_583<T>>, class_583<T>>();
        private TextureContainer<T, A> tex;
        private ModelContainer<T, A> model;
        private PreRenderCallback<T> preRender;
        private HandleRotation<T> handleRotation;
        private ApplyRotations<T> applyRotations;
        private SuperCallApplyRotations superCallApplyRotations = SuperCallApplyRotations.NONE;
        private RenderLayer<T> renderLayer;

        protected Builder(String modid, float shadow) {
            this.modid = modid;
            this.shadow = shadow;
        }

        public Builder<T, A> layer(Function<BaseRenderer<T, A>, class_3887<T, A>> layer) {
            this.layers.add(layer);
            return this;
        }

        public Builder<T, A> tSingle(String texture) {
            this.tex = new TextureContainer(ImplRenderer.tex(this.modid, texture));
            return this;
        }

        public Builder<T, A> tCondition(Predicate<T> condition, String trueTex, String falseTex) {
            this.tex = new TextureContainer(condition, ImplRenderer.tex(this.modid, trueTex), ImplRenderer.tex(this.modid, falseTex));
            return this;
        }

        public Builder<T, A> tMapped(Function<T, String> texMapper) {
            this.tex = new TextureContainer(entity -> this.texStored((String)texMapper.apply(entity)));
            return this;
        }

        public Builder<T, A> tSingleRaw(class_2960 texture) {
            this.tex = new TextureContainer(texture);
            return this;
        }

        public Builder<T, A> tConditionRaw(Predicate<T> condition, class_2960 trueTex, class_2960 falseTex) {
            this.tex = new TextureContainer(condition, trueTex, falseTex);
            return this;
        }

        public Builder<T, A> tMappedRaw(Function<T, class_2960> texMapper) {
            this.tex = new TextureContainer(texMapper);
            return this;
        }

        public Builder<T, A> tVariant() {
            return this.tMappedRaw(e -> {
                if (e instanceof IVariantTypes) {
                    return ((IVariantTypes)e).getVariantTextureOrNull();
                }
                return null;
            });
        }

        public Builder<T, A> tMappedConditionRaw(Predicate<T> condition, Function<T, class_2960> texMapper, String conditionTex) {
            return this.tMappedConditionRaw(condition, texMapper, ImplRenderer.tex(this.modid, conditionTex));
        }

        public Builder<T, A> tMappedConditionRaw(Predicate<T> condition, Function<T, class_2960> texMapper, class_2960 conditionTex) {
            this.tex = new TextureContainer(condition, texMapper, conditionTex);
            return this;
        }

        public Builder<T, A> tVariantCondition(Predicate<T> condition, Function<T, class_2960> texMapper, String conditionTex) {
            return this.tVariantCondition(condition, texMapper, ImplRenderer.tex(this.modid, conditionTex));
        }

        public Builder<T, A> tVariantCondition(Predicate<T> condition, Function<T, class_2960> texMapper, class_2960 conditionTex) {
            this.tex = new TextureContainer(condition, e -> {
                if (e instanceof IVariantTypes) {
                    return ((IVariantTypes)e).getVariantTextureOrNull();
                }
                return null;
            }, conditionTex);
            return this;
        }

        public Builder<T, A> tBabyVariant(String babyTex) {
            return this.tVariantCondition((T e) -> {
                if (e instanceof class_1296) {
                    return e.method_6109();
                }
                return false;
            }, (T e) -> {
                if (e instanceof IVariantTypes) {
                    return ((IVariantTypes)e).getVariantTextureOrNull();
                }
                return null;
            }, ImplRenderer.tex(this.modid, babyTex));
        }

        public Builder<T, A> mSingle(A model) {
            this.model = new ModelContainer(model);
            return this;
        }

        public Builder<T, A> mMapped(Function<T, Class<? extends class_583<T>>> modelMapper, A baseModel) {
            this.model = new ModelContainer<class_1308, A>(e -> this.modelStored((Class)modelMapper.apply(e), baseModel), baseModel);
            return this;
        }

        public Builder<T, A> mCondition(Predicate<T> condition, A trueModel, class_583<T> falseModel) {
            this.model = new ModelContainer<T, A>(condition, trueModel, falseModel);
            return this;
        }

        public Builder<T, A> preRender(PreRenderCallback<T> preRender) {
            this.preRender = preRender;
            return this;
        }

        public Builder<T, A> simpleScale(Function<T, Float> function) {
            this.preRender((e, s, p) -> {
                float scale = ((Float)function.apply(e)).floatValue();
                s.method_22905(scale, scale, scale);
            });
            return this;
        }

        public Builder<T, A> condScale(Predicate<T> cond, float xScale, float yScale, float zScale) {
            this.preRender((e, s, p) -> {
                if (cond.test(e)) {
                    s.method_22905(xScale, yScale, zScale);
                }
            });
            return this;
        }

        public Builder<T, A> condScale(Predicate<T> cond, float scale) {
            return this.condScale(cond, scale, scale, scale);
        }

        public Builder<T, A> condDualScale(Predicate<T> cond, float truexScale, float trueyScale, float truezScale, float falsexScale, float falseyScale, float falsezScale) {
            this.preRender((e, s, p) -> {
                if (cond.test(e)) {
                    s.method_22905(truexScale, trueyScale, truezScale);
                } else {
                    s.method_22905(falsexScale, falseyScale, falsezScale);
                }
            });
            return this;
        }

        public Builder<T, A> condDualScale(Predicate<T> cond, float trueScale, float falseScale) {
            return this.condDualScale(cond, trueScale, trueScale, trueScale, falseScale, falseScale, falseScale);
        }

        public Builder<T, A> childScale(float xScale, float yScale, float zScale) {
            this.preRender((e, s, p) -> {
                if (e instanceof class_1296 && e.method_6109()) {
                    s.method_22905(xScale, yScale, zScale);
                }
            });
            return this;
        }

        public Builder<T, A> childScale(float scale) {
            return this.childScale(scale, scale, scale);
        }

        public Builder<T, A> ageScale(float adultxScale, float adultyScale, float adultzScale, float childxScale, float childyScale, float childzScale) {
            this.preRender((e, s, p) -> {
                if (e instanceof class_1296) {
                    if (e.method_6109()) {
                        s.method_22905(childxScale, childyScale, childzScale);
                    } else {
                        s.method_22905(adultxScale, adultyScale, adultzScale);
                    }
                }
            });
            return this;
        }

        public Builder<T, A> ageScale(float adultScale, float childScale) {
            return this.ageScale(adultScale, adultScale, adultScale, childScale, childScale, childScale);
        }

        public Builder<T, A> handleRotation(HandleRotation<T> handleRotationFunc) {
            this.handleRotation = handleRotationFunc;
            return this;
        }

        public Builder<T, A> applyRotations(ApplyRotations<T> applyRotationsFunc, SuperCallApplyRotations superCall) {
            this.superCallApplyRotations = superCall;
            return this.applyRotations(applyRotationsFunc);
        }

        public Builder<T, A> applyRotations(ApplyRotations<T> applyRotationsFunc) {
            this.applyRotations = applyRotationsFunc;
            return this;
        }

        public Builder<T, A> renderLayer(RenderLayer<T> renderLayerFunc) {
            this.renderLayer = renderLayerFunc;
            return this;
        }

        public Function<class_898, class_897<T>> done() {
            if (this.tex == null || this.model == null) {
                throw new IllegalArgumentException("Must define both a texture and a model before calling build()!");
            }
            return mgr -> new ImplRenderer<T, A>((class_898)mgr, this.shadow, this.tex, this.model, this.preRender, this.handleRotation, this.applyRotations, this.superCallApplyRotations, this.renderLayer).layers(this.layers);
        }

        private class_2960 texStored(String location) {
            return this.texMapper.computeIfAbsent(location, l -> ImplRenderer.tex(this.modid, l));
        }

        private class_583<T> modelStored(Class<? extends class_583<T>> clazz, A defaultModel) {
            return this.modelMapper.computeIfAbsent(clazz, l -> {
                try {
                    return (class_583)clazz.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                    return defaultModel;
                }
            });
        }
    }

    @FunctionalInterface
    public static interface RenderDef<T extends class_1308, A extends class_583<T>> {
        public Builder<T, A> apply(Builder<T, A> var1);
    }

    public static enum Strategy {
        SINGLE,
        MAPPER,
        MAPPER_CONDITION,
        CONDITION;

    }
}

