/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.entity;

import com.google.common.collect.Sets;
import dev.itsmeow.whisperwoods.imdlib.IMDLib;
import dev.itsmeow.whisperwoods.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.whisperwoods.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.whisperwoods.imdlib.entity.util.builder.IEntityBuilder;
import dev.itsmeow.whisperwoods.imdlib.entity.util.variant.EntityVariant;
import dev.itsmeow.whisperwoods.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.whisperwoods.imdlib.util.BiomeListBuilder;
import dev.itsmeow.whisperwoods.imdlib.util.HeadType;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2902;
import net.minecraft.class_5132;
import net.minecraft.class_5321;

public abstract class AbstractEntityBuilder<T extends class_1308, C extends EntityTypeContainer<T>, B extends AbstractEntityBuilder<T, C, B>>
implements IEntityBuilder<T, C, B> {
    protected final Class<T> entityClass;
    protected final String entityName;
    protected final class_1299.class_4049<T> factory;
    protected final String modid;
    protected final Supplier<class_5132.class_5133> attributeMap;
    public boolean hasSpawns;
    protected class_1311 spawnType;
    protected int eggColorSolid;
    protected int eggColorSpot;
    protected int spawnWeight;
    protected boolean useSpawnCosts;
    protected int spawnMinGroup;
    protected int spawnMaxGroup;
    protected double spawnCostPer;
    protected double spawnMaxCost;
    protected float width;
    protected float height;
    protected boolean despawn;
    protected EntityTypeContainer.CustomConfigurationLoad customConfigLoad;
    protected EntityTypeContainer.CustomConfigurationInit customConfigInit;
    protected EntityTypeContainer.CustomConfigurationLoad customClientConfigLoad;
    protected EntityTypeContainer.CustomConfigurationInit customClientConfigInit;
    protected Supplier<Set<class_5321<class_1959>>> defaultBiomeSupplier;
    protected class_1317.class_1319 placementType;
    protected class_2902.class_2903 heightMapType;
    protected class_1317.class_4306<T> placementPredicate;
    protected int variantCount = 0;
    protected IVariant[] variants;
    protected boolean hasEgg;
    protected Function<C, HeadType> headTypeBuilder;

    protected AbstractEntityBuilder(Class<T> EntityClass, class_1299.class_4049<T> factory, String entityNameIn, Supplier<class_5132.class_5133> attributeMap, String modid) {
        this.entityClass = EntityClass;
        this.factory = factory;
        this.entityName = entityNameIn;
        this.modid = modid;
        this.eggColorSolid = 0;
        this.eggColorSpot = 0xFFFFFF;
        this.spawnWeight = 1;
        this.spawnMinGroup = 1;
        this.spawnMaxGroup = 1;
        this.useSpawnCosts = false;
        this.spawnCostPer = 1.0;
        this.spawnMaxCost = 10.0;
        this.spawnType = class_1311.field_6294;
        this.hasSpawns = false;
        this.width = 1.0f;
        this.height = 1.0f;
        this.despawn = false;
        this.hasEgg = false;
        this.defaultBiomeSupplier = HashSet::new;
        this.placementType = null;
        this.heightMapType = null;
        this.placementPredicate = null;
        this.attributeMap = attributeMap;
    }

    protected static Supplier<Set<class_5321<class_1959>>> toBiomes(BiomeTypes.Type[] biomeTypes, boolean overworldOnly) {
        return () -> {
            HashSet<class_5321> set = new HashSet<class_5321>();
            class_2385 reg = null;
            try {
                reg = IMDLib.getStaticServerInstance().method_30611().method_30530(class_2378.field_25114);
            }
            catch (RuntimeException e) {
                return set;
            }
            for (class_1959 biome : reg) {
                class_5321 biomeResourceKey = (class_5321)reg.method_29113((Object)biome).orElseThrow(RuntimeException::new);
                for (BiomeTypes.Type predicate : biomeTypes) {
                    if (!predicate.hasType((class_5321<class_1959>)biomeResourceKey) || overworldOnly && !BiomeTypes.OVERWORLD.hasType((class_5321<class_1959>)biomeResourceKey)) continue;
                    set.add(biomeResourceKey);
                }
            }
            return set;
        };
    }

    public abstract B getImplementation();

    @Override
    public B spawn(class_1311 type, int weight, int min, int max) {
        this.hasSpawns = true;
        this.spawnType = type;
        this.spawnWeight = weight;
        this.spawnMinGroup = min;
        this.spawnMaxGroup = max;
        return this.getImplementation();
    }

    @Override
    public B spawnCosts(double cost, double maxCost) {
        if (!this.hasSpawns) {
            throw new RuntimeException("You must specify spawns before spawn costs");
        }
        this.useSpawnCosts = true;
        this.spawnCostPer = cost;
        this.spawnMaxCost = maxCost;
        return this.getImplementation();
    }

    @Override
    public B egg(int solid, int spot) {
        this.hasEgg = true;
        this.eggColorSolid = solid;
        this.eggColorSpot = spot;
        return this.getImplementation();
    }

    @Override
    public B size(float width, float height) {
        this.width = width;
        this.height = height;
        return this.getImplementation();
    }

    @Override
    public B despawn() {
        this.despawn = true;
        return this.getImplementation();
    }

    @Override
    public B config(EntityTypeContainer.CustomConfigurationInit configurationInit) {
        return (B)this.config(configurationInit, holder -> {});
    }

    @Override
    public B clientConfig(EntityTypeContainer.CustomConfigurationInit configurationInit) {
        return (B)this.clientConfig(configurationInit, holder -> {});
    }

    @Override
    public B config(EntityTypeContainer.CustomConfigurationInit configurationInit, EntityTypeContainer.CustomConfigurationLoad configurationLoad) {
        this.customConfigLoad = configurationLoad;
        this.customConfigInit = configurationInit;
        return this.getImplementation();
    }

    @Override
    public B clientConfig(EntityTypeContainer.CustomConfigurationInit configurationInit, EntityTypeContainer.CustomConfigurationLoad configurationLoad) {
        this.customClientConfigLoad = configurationLoad;
        this.customClientConfigInit = configurationInit;
        return this.getImplementation();
    }

    @Override
    public B placement(class_1317.class_1319 type, class_2902.class_2903 heightMap, class_1317.class_4306<T> predicate) {
        if (!this.hasSpawns) {
            throw new RuntimeException("You must specify spawns before placement");
        }
        this.placementType = type;
        this.heightMapType = heightMap;
        this.placementPredicate = predicate;
        return this.getImplementation();
    }

    @Override
    public B defaultPlacement(class_1317.class_4306<T> predicate) {
        return (B)this.placement(class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, (class_1317.class_4306)predicate);
    }

    @Override
    public B waterPlacement() {
        return (B)this.placement(class_1317.class_1319.field_6318, class_2902.class_2903.field_13203, EntityTypeContainer::waterSpawn);
    }

    @Override
    public B waterPlacement(class_1317.class_4306<T> predicate) {
        return (B)this.placement(class_1317.class_1319.field_6318, class_2902.class_2903.field_13203, (class_1317.class_4306)predicate);
    }

    @Override
    public B biomes(BiomeTypes.Type ... biomeTypes) {
        if (!this.hasSpawns) {
            throw new RuntimeException("You must specify spawns before biomes");
        }
        this.defaultBiomeSupplier = AbstractEntityBuilder.toBiomes(biomeTypes, false);
        return this.getImplementation();
    }

    @Override
    public B biomesOverworld(BiomeTypes.Type ... biomeTypes) {
        if (!this.hasSpawns) {
            throw new RuntimeException("You must specify spawns before biomes");
        }
        this.defaultBiomeSupplier = AbstractEntityBuilder.toBiomes(biomeTypes, true);
        return this.getImplementation();
    }

    @Override
    public B biomes(Supplier<class_5321<class_1959>[]> biomes) {
        if (!this.hasSpawns) {
            throw new RuntimeException("You must specify spawns before biomes");
        }
        this.defaultBiomeSupplier = () -> Sets.newHashSet((Object[])((class_5321[])biomes.get()));
        return this.getImplementation();
    }

    @Override
    public B biomes(Function<BiomeListBuilder, BiomeListBuilder> biomes) {
        return (B)this.biomes(biomes.apply(BiomeListBuilder.create())::collect);
    }

    @Override
    public B variants(IVariant ... variants) {
        this.variantCount = variants.length;
        this.variants = variants;
        return this.getImplementation();
    }

    @Override
    public B variants(String ... nameTextures) {
        this.variantCount = nameTextures.length;
        this.variants = new EntityVariant[nameTextures.length];
        for (int i = 0; i < nameTextures.length; ++i) {
            String nameTex = nameTextures[i];
            this.variants[i] = new EntityVariant(this.modid, nameTex, this.entityName + "_" + nameTex);
        }
        return this.getImplementation();
    }

    @Override
    public B variants(int max) {
        if (max > 0) {
            this.variantCount = max;
            this.variants = new EntityVariant[max];
            for (int i = 0; i < max; ++i) {
                String nameTex = String.valueOf(i + 1);
                this.variants[i] = new EntityVariant(this.modid, nameTex, this.entityName + "_" + nameTex);
            }
        } else {
            throw new RuntimeException("what are you doing kid");
        }
        return this.getImplementation();
    }

    @Override
    public B variants(Function<String, IVariant> constructor, String ... variants) {
        this.variantCount = variants.length;
        IVariant[] variantList = new IVariant[this.variantCount];
        for (int i = 0; i < this.variantCount; ++i) {
            variantList[i] = constructor.apply(variants[i]);
        }
        this.variants = variantList;
        return this.getImplementation();
    }

    @Override
    public HeadType.Builder<T, C, B> head(String headName) {
        return new HeadType.Builder(this.getImplementation(), headName);
    }

    @Override
    public HeadType.Builder<T, C, B> head() {
        return this.head(this.entityName + "head");
    }

    @Override
    public void postBuild(C container) {
        if (this.headTypeBuilder != null) {
            ((EntityTypeContainer)container).setHeadType(this.headTypeBuilder.apply(container));
        }
    }

    @Override
    public void setHeadBuild(Function<C, HeadType> builder) {
        this.headTypeBuilder = builder;
    }

    @Override
    public String getMod() {
        return this.modid;
    }
}

