/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.util;

import dev.itsmeow.whisperwoods.imdlib.block.GenericSkullBlock;
import dev.itsmeow.whisperwoods.imdlib.blockentity.HeadBlockEntity;
import dev.itsmeow.whisperwoods.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.whisperwoods.imdlib.entity.interfaces.IVariantTypes;
import dev.itsmeow.whisperwoods.imdlib.entity.util.builder.IEntityBuilder;
import dev.itsmeow.whisperwoods.imdlib.entity.util.variant.EntityVariant;
import dev.itsmeow.whisperwoods.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.whisperwoods.imdlib.item.ItemBlockHeadType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.registry.Registries;
import me.shedaniel.architectury.registry.RegistrySupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_583;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class HeadType {
    protected static final Set<HeadType> HEADS = new HashSet<HeadType>();
    protected static final Map<String, HeadType> HEADS_MAP = new HashMap<String, HeadType>();
    protected static final Map<class_2960, HeadType> HEADS_BLOCK_MAP = new HashMap<class_2960, HeadType>();
    private final String name;
    private final PlacementType placement;
    private final EntityTypeContainer<? extends class_1309> container;
    private final String modid;
    @Environment(value=EnvType.CLIENT)
    public Supplier<Supplier<class_583<? extends class_1297>>> modelSupplier;
    private IVariant singletonVariant;
    private final Map<IVariant, Pair<RegistrySupplier<GenericSkullBlock>, RegistrySupplier<ItemBlockHeadType>>> heads = new HashMap<IVariant, Pair<RegistrySupplier<GenericSkullBlock>, RegistrySupplier<ItemBlockHeadType>>>();
    private final Set<RegistrySupplier<ItemBlockHeadType>> items = new HashSet<RegistrySupplier<ItemBlockHeadType>>();
    private final Set<RegistrySupplier<GenericSkullBlock>> blocks = new HashSet<RegistrySupplier<GenericSkullBlock>>();
    private final Map<class_2960, IVariant> reverseVariantMap = new HashMap<class_2960, IVariant>();
    private final Consumer<Registries> registerVariants;

    public HeadType(String modid, class_1761 group, String name, PlacementType placement, HeadIDMapping mapping, @Nullable Function<IVariant, String> variantMapper, @Nullable IVariant singletonVariant, @Nullable String singletonID, EntityTypeContainer<? extends class_1309> container) {
        this.name = name;
        this.modid = modid;
        this.placement = placement;
        this.container = container;
        if (!container.hasVariants() && mapping != HeadIDMapping.SINGLETON) {
            throw new RuntimeException("Tried to create non-singleton head type with a variantless entity!");
        }
        this.registerVariants = registries -> {
            switch (mapping) {
                case NAMES: {
                    for (IVariant variant : container.getVariants()) {
                        if (!variant.hasHead()) continue;
                        this.setupVariant((Registries)registries, variant, group, variant.getName());
                    }
                    break;
                }
                case NUMBERS: {
                    for (IVariant variant : container.getVariants()) {
                        if (!variant.hasHead()) continue;
                        this.setupVariant((Registries)registries, variant, group, String.valueOf(container.getVariants().indexOf((Object)variant) + 1));
                    }
                    break;
                }
                case CUSTOM: {
                    for (IVariant variant : container.getVariants()) {
                        if (!variant.hasHead()) continue;
                        this.setupVariant((Registries)registries, variant, group, (String)variantMapper.apply(variant));
                    }
                    break;
                }
                case SINGLETON: {
                    this.setupVariant((Registries)registries, singletonVariant, group, singletonID);
                    this.singletonVariant = singletonVariant;
                    break;
                }
            }
        };
        HEADS.add(this);
        HEADS_MAP.put(name, this);
    }

    public void register(Registries registries) {
        this.registerVariants.accept(registries);
    }

    protected void setupVariant(Registries registries, IVariant variant, class_1761 group, String id) {
        class_2960 rl = new class_2960(this.getMod(), this.getName() + "_" + id);
        RegistrySupplier block = registries.get(class_2378.field_25105).registerSupplied(rl, () -> new GenericSkullBlock(this, id));
        RegistrySupplier item = registries.get(class_2378.field_25108).registerSupplied(rl, () -> new ItemBlockHeadType((class_2248)block.get(), this, id, variant, group));
        this.heads.put(variant, (Pair<RegistrySupplier<GenericSkullBlock>, RegistrySupplier<ItemBlockHeadType>>)Pair.of((Object)block, (Object)item));
        this.blocks.add((RegistrySupplier<GenericSkullBlock>)block);
        this.items.add((RegistrySupplier<ItemBlockHeadType>)item);
        this.reverseVariantMap.put(rl, variant);
        HEADS_BLOCK_MAP.put(rl, this);
    }

    public static Set<HeadType> values() {
        return HEADS;
    }

    public static HeadType valueOf(String name) {
        return HEADS_MAP.get(name);
    }

    public static HeadType valueOf(class_2248 block) {
        return HEADS_BLOCK_MAP.get(block);
    }

    public static GenericSkullBlock[] getAllBlocks() {
        return HeadType.values().stream().map(type -> type.getBlockObjects()).flatMap(Collection::stream).map(Supplier::get).collect(Collectors.toList()).toArray(new GenericSkullBlock[0]);
    }

    public IVariant getVariantForBlock(class_2248 block) {
        return this.reverseVariantMap.get(class_2378.field_11146.method_10221((Object)block));
    }

    public Pair<RegistrySupplier<GenericSkullBlock>, RegistrySupplier<ItemBlockHeadType>> getPairForVariant(IVariant variant) {
        return this.heads.get(variant);
    }

    public RegistrySupplier<GenericSkullBlock> getBlockForVariant(IVariant variant) {
        if (this.getPairForVariant(variant) == null) {
            return null;
        }
        return (RegistrySupplier)this.getPairForVariant(variant).getLeft();
    }

    public RegistrySupplier<ItemBlockHeadType> getItemForVariant(IVariant variant) {
        if (this.getPairForVariant(variant) == null) {
            return null;
        }
        return (RegistrySupplier)this.getPairForVariant(variant).getRight();
    }

    public RegistrySupplier<GenericSkullBlock> getSingletonBlock() {
        if (this.getPairForVariant(this.singletonVariant) == null) {
            return null;
        }
        return (RegistrySupplier)this.getPairForVariant(this.singletonVariant).getLeft();
    }

    public RegistrySupplier<ItemBlockHeadType> getSingletonItem() {
        if (this.getPairForVariant(this.singletonVariant) == null) {
            return null;
        }
        return (RegistrySupplier)this.getPairForVariant(this.singletonVariant).getRight();
    }

    public Set<RegistrySupplier<ItemBlockHeadType>> getItemObjects() {
        return this.items;
    }

    public Set<RegistrySupplier<GenericSkullBlock>> getBlockObjects() {
        return this.blocks;
    }

    public HeadBlockEntity createTE() {
        return new HeadBlockEntity(this);
    }

    public String getName() {
        return this.name;
    }

    public PlacementType getPlacementType() {
        return this.placement;
    }

    @Environment(value=EnvType.CLIENT)
    public Supplier<Supplier<class_583<? extends class_1297>>> getModelSupplier() {
        return this.modelSupplier;
    }

    public EntityTypeContainer<? extends class_1309> getContainer() {
        return this.container;
    }

    public IVariant getSingletonVariant() {
        return this.singletonVariant;
    }

    public void drop(class_1308 entity, int chance) {
        this.drop(entity, chance, this.getHeadID(entity).orElse(null));
    }

    public void drop(class_1308 entity, int chance, IVariant variant) {
        if (variant != null && !entity.field_6002.field_9236 && !entity.method_6109() && entity.method_6051().nextInt(chance) == 0) {
            class_1799 stack = new class_1799((class_1935)this.getItemForVariant(variant).get());
            entity.method_5699(stack, 0.5f);
        }
    }

    private Optional<IVariant> getHeadID(class_1308 entity) {
        if (entity instanceof IVariantTypes && this.container.hasVariants()) {
            IVariantTypes ent = (IVariantTypes)entity;
            return ent.getVariant();
        }
        return Optional.of(this.singletonVariant);
    }

    public String getMod() {
        return this.modid;
    }

    public static enum PlacementType {
        FLOOR_AND_WALL,
        WALL_ONLY;

    }

    public static enum HeadIDMapping {
        NAMES,
        NUMBERS,
        CUSTOM,
        SINGLETON;

    }

    public static class Builder<T extends class_1308, C extends EntityTypeContainer<T>, B extends IEntityBuilder<T, C, B>> {
        private final String name;
        private final B initial;
        private PlacementType placement;
        @Environment(value=EnvType.CLIENT)
        private Supplier<Supplier<class_583<?>>> modelSupplier;
        private HeadIDMapping idMapping;
        private Function<IVariant, String> customMapper;
        private IVariant singletonVariant;
        private String singletonID;
        private class_1761 group;

        public Builder(B initial, String name) {
            this.initial = initial;
            this.name = name;
            this.placement = PlacementType.WALL_ONLY;
            this.idMapping = null;
        }

        public Builder<T, C, B> itemGroup(class_1761 group) {
            this.group = group;
            return this;
        }

        public Builder<T, C, B> mapToNames() {
            this.idMapping = HeadIDMapping.NAMES;
            return this;
        }

        public Builder<T, C, B> mapToNumbers() {
            this.idMapping = HeadIDMapping.NUMBERS;
            return this;
        }

        public Builder<T, C, B> mapToCustom(Function<IVariant, String> customMapper) {
            this.idMapping = HeadIDMapping.CUSTOM;
            this.customMapper = customMapper;
            return this;
        }

        public Builder<T, C, B> singleton(String id, String texture) {
            this.idMapping = HeadIDMapping.SINGLETON;
            this.singletonID = id;
            this.singletonVariant = new EntityVariant(this.initial.getMod(), id, texture);
            return this;
        }

        public Builder<T, C, B> allowFloor() {
            this.placement = PlacementType.FLOOR_AND_WALL;
            return this;
        }

        public Builder<T, C, B> setModel(Supplier<Supplier<class_583<? extends class_1297>>> modelSupplier) {
            if (Platform.getEnv() == EnvType.CLIENT) {
                this.modelSupplier = modelSupplier;
            }
            return this;
        }

        public B done() {
            this.initial.setHeadBuild(this::build);
            return this.initial;
        }

        public HeadType build(C container) {
            if (this.idMapping == null) {
                throw new RuntimeException("No ID mapping set for head builder " + this.name);
            }
            HeadType type = new HeadType(this.initial.getMod(), this.group, this.name, this.placement, this.idMapping, this.customMapper, this.singletonVariant, this.singletonID, (EntityTypeContainer<? extends class_1309>)container);
            if (Platform.getEnv() == EnvType.CLIENT) {
                type.modelSupplier = this.modelSupplier;
            }
            return type;
        }
    }
}

