/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.util;

import com.google.common.collect.ImmutableSet;
import dev.itsmeow.whisperwoods.imdlib.util.ClassLoadHacks;
import dev.itsmeow.whisperwoods.util.MutablePair;
import java.util.HashSet;
import java.util.Set;
import me.shedaniel.architectury.event.events.TickEvent;
import me.shedaniel.architectury.event.events.client.ClientTickEvent;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.utils.Env;

public class TaskQueue {
    public static final TaskQueue QUEUE_SERVER = new TaskQueue(Env.SERVER);
    public static final TaskQueue QUEUE_CLIENT = new TaskQueue(Env.CLIENT);
    private final Set<MutablePair<Integer, Runnable>> taskQueue = new HashSet<MutablePair<Integer, Runnable>>();

    public TaskQueue(Env logicalSide) {
        if (logicalSide == Env.CLIENT) {
            ClassLoadHacks.runIf(Platform.getEnvironment() == Env.CLIENT, () -> () -> ClientTickEvent.CLIENT_PRE.register(client -> this.tick()));
        } else {
            TickEvent.SERVER_PRE.register(server -> this.tick());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(int ticks, Runnable run) {
        Set<MutablePair<Integer, Runnable>> set = this.taskQueue;
        synchronized (set) {
            this.taskQueue.add(new MutablePair<Integer, Runnable>(ticks, run));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        Set<MutablePair<Integer, Runnable>> set = this.taskQueue;
        synchronized (set) {
            for (MutablePair p : ImmutableSet.copyOf(this.taskQueue)) {
                if ((Integer)p.getLeft() <= 0) {
                    this.taskQueue.remove(p);
                    ((Runnable)p.getRight()).run();
                    continue;
                }
                p.setLeft((Integer)p.getLeft() - 1);
            }
        }
    }
}

