/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.blockentity;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import dev.itsmeow.whisperwoods.block.GhostLightBlock;
import dev.itsmeow.whisperwoods.block.HandOfFateBlock;
import dev.itsmeow.whisperwoods.entity.EntityWisp;
import dev.itsmeow.whisperwoods.init.ModBlockEntities;
import dev.itsmeow.whisperwoods.init.ModEntities;
import dev.itsmeow.whisperwoods.network.HOFEffectPacket;
import dev.itsmeow.whisperwoods.network.WWNetwork;
import dev.itsmeow.whisperwoods.util.TaskQueue;
import dev.itsmeow.whisperwoods.util.WispColors;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.architectury.extensions.BlockEntityExtension;
import me.shedaniel.architectury.registry.Registries;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;

public class HandOfFateBlockEntity
extends TileEntity
implements ITickableTileEntity,
BlockEntityExtension {
    public static final ImmutableBiMap<String, HOFRecipe> RECIPES = ImmutableBiMap.of((Object)"hirschgeist", (Object)new HOFRecipe(TextFormatting.AQUA, true, Items.field_151103_aS, Items.field_151045_i, Items.field_221693_cI), (Object)"wisp", (Object)new HOFRecipe(TextFormatting.GOLD, false, Items.field_151065_br, Items.field_151114_aO, Items.field_221693_cI));
    private final CurrentRecipeContainer recipeContainer = new CurrentRecipeContainer();
    private Item toDisplay = null;
    private boolean displayDirty = true;
    public float lastAnimationY = 0.0f;

    public HandOfFateBlockEntity() {
        super((TileEntityType)ModBlockEntities.HAND_OF_FATE.get());
    }

    public Item getDisplayItem() {
        if (this.displayDirty) {
            this.toDisplay = this.getRecipeContainer().getDisplayItem();
            this.displayDirty = false;
        }
        return this.toDisplay;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.func_145830_o() && !this.field_145850_b.func_201670_d()) {
            this.syncData();
        }
    }

    public boolean isLit() {
        Block b = this.func_195044_w().func_177230_c();
        if (b instanceof HandOfFateBlock && this.func_145830_o()) {
            HandOfFateBlock block = (HandOfFateBlock)b;
            return block.isLit(this.func_145831_w(), this.func_174877_v());
        }
        return false;
    }

    public boolean hasBlaze() {
        return this.recipeContainer.hasItemInRecipe(Items.field_151065_br);
    }

    public CurrentRecipeContainer getRecipeContainer() {
        return this.recipeContainer;
    }

    protected void playSound(SoundEvent sound, float vol, float pitch) {
        if (this.func_145830_o()) {
            this.func_145831_w().func_184148_a(null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), sound, SoundCategory.BLOCKS, vol, pitch);
        }
    }

    protected void sendToTrackers(HOFEffectPacket pkt) {
        if (this.func_145830_o()) {
            WWNetwork.HANDLER.sendToPlayers((Iterable)((ServerChunkProvider)this.func_145831_w().func_72863_F()).field_217237_a.func_219097_a(new ChunkPos(this.field_174879_c), false).collect(Collectors.toSet()), (Object)pkt);
        }
    }

    public void func_73660_a() {
        if (this.func_145830_o() && this.field_174879_c != null && this.field_145850_b.func_82737_E() % 5L == 0L && !this.field_145850_b.field_72995_K) {
            BlockState state = this.func_195044_w();
            List items = this.field_145850_b.func_217357_a(ItemEntity.class, state.func_196951_e((IBlockReader)this.field_145850_b, this.field_174879_c).func_197752_a().func_186670_a(this.field_174879_c).func_186662_g(0.25));
            for (ItemEntity item : items) {
                ItemStack stack;
                if (!item.func_70089_S() || (stack = item.func_92059_d()).func_190916_E() <= 0) continue;
                ActionResultType r = this.reactToItem(stack, state, this.field_145850_b, this.field_174879_c);
                if (r == ActionResultType.CONSUME) {
                    item.func_92059_d().func_190918_g(1);
                    this.playSound(SoundEvents.field_193781_bp, 1.0f, 1.0f);
                    this.displayDirty = true;
                    if (item.func_92059_d().func_190916_E() == 0) {
                        item.func_70106_y();
                    }
                    this.func_70296_d();
                    break;
                }
                if (!(stack.func_77973_b() instanceof BlockItem) || !this.field_145850_b.func_175623_d(this.field_174879_c.func_177984_a())) continue;
                BlockItem i = (BlockItem)stack.func_77973_b();
                if (i.func_179223_d() instanceof GhostLightBlock) {
                    item.func_92059_d().func_190918_g(1);
                    this.playSound(SoundEvents.field_193781_bp, 1.0f, 1.0f);
                    this.field_145850_b.func_175656_a(this.field_174879_c.func_177984_a(), i.func_179223_d().func_176223_P());
                }
                if (item.func_92059_d().func_190916_E() != 0) break;
                item.func_70106_y();
                break;
            }
        }
    }

    public ActionResultType onBlockActivated(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ActionResultType r = this.reactToItem(player.func_184586_b(hand), state, worldIn, pos);
        if (r == ActionResultType.CONSUME) {
            if (!player.func_184812_l_()) {
                player.func_184586_b(hand).func_190918_g(1);
            }
            this.playSound(SoundEvents.field_193781_bp, 1.0f, 1.0f);
            this.displayDirty = true;
            this.func_70296_d();
        }
        return r;
    }

    public ActionResultType reactToItem(ItemStack stack, BlockState state, World worldIn, BlockPos pos) {
        boolean lit;
        boolean bl = lit = this.isLit() || this.hasBlaze();
        if (lit || stack.func_77973_b() == Items.field_151065_br) {
            if (!this.getRecipeContainer().hasRecipe()) {
                for (HOFRecipe recipe : RECIPES.values()) {
                    if (!recipe.isFirst(stack.func_77973_b())) continue;
                    this.getRecipeContainer().setRecipe(recipe);
                    if (!this.getRecipeContainer().checkedAdd(stack.func_77973_b())) continue;
                    return ActionResultType.CONSUME;
                }
            } else if (this.getRecipeContainer().checkedAdd(stack.func_77973_b())) {
                if (this.getRecipeContainer().isRecipeComplete()) {
                    this.onRecipeComplete(this.getRecipeContainer().getCurrentRecipe(), state, worldIn, pos);
                }
                return ActionResultType.CONSUME;
            }
        }
        return ActionResultType.PASS;
    }

    public void onRecipeComplete(HOFRecipe recipe, BlockState state, World worldIn, BlockPos pos) {
        if (worldIn instanceof ServerWorld && !worldIn.field_72995_K) {
            ServerWorld world = (ServerWorld)worldIn;
            switch (recipe.getName()) {
                case "hirschgeist": {
                    HOFEffectPacket hgpk = new HOFEffectPacket(HOFEffectPacket.HOFEffectType.HIRSCHGEIST, new Vector3f((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 1.0f, (float)pos.func_177952_p() + 0.5f), WispColors.BLUE.getColor());
                    this.sendToTrackers(hgpk);
                    this.playSound(SoundEvents.field_191244_bn, 1.0f, 1.0f);
                    this.playSound(SoundEvents.field_219604_Z, 1.0f, 1.0f);
                    TaskQueue.QUEUE_SERVER.schedule(50, () -> ModEntities.HIRSCHGEIST.getEntityType().func_220331_a((ServerWorld)worldIn, null, null, pos.func_177984_a(), SpawnReason.EVENT, false, false));
                    break;
                }
                case "wisp": {
                    EntityWisp wisp = (EntityWisp)ModEntities.WISP.getEntityType().func_200721_a((World)world);
                    Block above = world.func_180495_p(pos.func_177984_a()).func_177230_c();
                    WispColors.WispColor wColor = above instanceof GhostLightBlock ? WispColors.byColor(((GhostLightBlock)above).getColor()) : WispColors.values()[wisp.func_70681_au().nextInt(WispColors.values().length)];
                    wisp.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5);
                    double d0 = 1.0 + VoxelShapes.func_212437_a((Direction.Axis)Direction.Axis.Y, (AxisAlignedBB)wisp.func_174813_aQ(), (Stream)world.func_234867_d_(null, new AxisAlignedBB(pos), e -> true), (double)-1.0);
                    wisp.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + d0, (double)pos.func_177952_p() + 0.5, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                    wisp.field_70759_as = wisp.field_70177_z;
                    wisp.field_70761_aq = wisp.field_70177_z;
                    wisp.isHostile = wisp.getNewHostileChance();
                    wisp.func_184212_Q().func_187227_b(EntityWisp.COLOR_VARIANT, (Object)(wColor.ordinal() + 1));
                    worldIn.func_217376_c((Entity)wisp);
                    int color = wisp.getWispColor().getColor();
                    HOFEffectPacket packet = new HOFEffectPacket(HOFEffectPacket.HOFEffectType.CIRCLE, new Vector3f((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 1.0f, (float)pos.func_177952_p() + 0.5f), color);
                    this.sendToTrackers(packet);
                    if (wisp.isHostile) {
                        HOFEffectPacket packet2 = new HOFEffectPacket(HOFEffectPacket.HOFEffectType.CIRCLE, new Vector3f((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 1.0f, (float)pos.func_177952_p() + 0.5f), 0xFF0000);
                        this.sendToTrackers(packet2);
                    }
                    this.playSound(wisp.isHostile ? SoundEvents.field_187514_aD : SoundEvents.field_191244_bn, 1.0f, 1.0f);
                    break;
                }
            }
            this.func_70296_d();
        }
        this.getRecipeContainer().setRecipe(null);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.getRecipeContainer().read(state, nbt);
        this.displayDirty = true;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT c = super.func_189515_b(compound);
        this.getRecipeContainer().write(compound);
        return c;
    }

    public void loadClientData(BlockState pos, CompoundNBT tag) {
        this.func_230337_a_(pos, tag);
    }

    public CompoundNBT saveClientData(CompoundNBT tag) {
        return this.func_189515_b(tag);
    }

    public void dropItems(World worldIn, BlockPos pos) {
        if (worldIn != null && this.getRecipeContainer().hasRecipe() && this.getRecipeContainer().data != null) {
            this.getRecipeContainer().data.getItemData().forEach((i, v) -> {
                Item toDrop;
                if (v.booleanValue() && (toDrop = (Item)Registries.get((String)"whisperwoods").get(Registry.field_239714_o_).get(new ResourceLocation(i))) != null) {
                    InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)new ItemStack((IItemProvider)toDrop));
                }
            });
        }
    }

    public static class CurrentRecipeContainer {
        private HOFRecipe currentRecipe = null;
        private RecipeItemData data = null;

        public void setRecipe(HOFRecipe recipe) {
            this.currentRecipe = recipe;
            this.data = recipe != null ? new RecipeItemData(recipe) : null;
        }

        public boolean hasRecipe() {
            return this.currentRecipe != null;
        }

        public boolean hasItemInRecipe(Item item) {
            return this.hasRecipe() && this.data != null && this.data.hasItem(item);
        }

        public boolean isRecipeComplete() {
            if (this.hasRecipe() && this.data != null) {
                boolean anyFalse = false;
                for (Item item : this.getCurrentRecipe().items) {
                    if (this.data.hasItem(item)) continue;
                    anyFalse = true;
                }
                return !anyFalse;
            }
            return false;
        }

        public HOFRecipe getCurrentRecipe() {
            return this.currentRecipe;
        }

        public boolean canRecipeAccept(Item item) {
            String next;
            if (this.hasRecipe() && this.data != null && (next = this.data.getNextNonContainedItem()) != null) {
                return next.equals(Registries.get((String)"whisperwoods").get(Registry.field_239714_o_).getId((Object)item).toString());
            }
            return false;
        }

        public boolean checkedAdd(Item item) {
            return this.canRecipeAccept(item) && this.data.addItem(item);
        }

        public Item getDisplayItem() {
            String itemName;
            if (this.hasRecipe() && this.data != null && (itemName = this.data.getNextNonContainedItem()) != null) {
                return (Item)Registries.get((String)"whisperwoods").get(Registry.field_239714_o_).get(new ResourceLocation(itemName));
            }
            return null;
        }

        public void read(BlockState state, CompoundNBT nbt) {
            if (nbt.func_74764_b("recipe")) {
                this.setRecipe((HOFRecipe)RECIPES.getOrDefault((Object)nbt.func_74779_i("recipe"), null));
                if (this.data != null) {
                    this.data.read(state, nbt);
                }
            } else {
                this.setRecipe(null);
            }
        }

        public CompoundNBT write(CompoundNBT compound) {
            if (this.hasRecipe()) {
                compound.func_74778_a("recipe", this.getCurrentRecipe().getName());
                if (this.data != null) {
                    this.data.write(compound);
                }
            }
            return compound;
        }
    }

    public static class HOFRecipe {
        private final TextFormatting color;
        private final boolean bold;
        private String name = null;
        public final ImmutableList<Item> items;

        public HOFRecipe(TextFormatting color, boolean bold, Item ... items) {
            if (items.length < 1) {
                throw new IllegalArgumentException("HOFRecipe constructor: \"items\" must have at least one item!");
            }
            this.color = color;
            this.bold = bold;
            this.items = ImmutableList.copyOf((Object[])items);
        }

        public TextFormatting getColor() {
            return this.color;
        }

        public boolean isBold() {
            return this.bold;
        }

        public String getName() {
            if (this.name == null) {
                this.name = (String)RECIPES.inverse().get((Object)this);
            }
            return this.name;
        }

        public Item getFirst() {
            return (Item)this.items.get(0);
        }

        public Item getLast() {
            return (Item)this.items.get(this.items.size() - 1);
        }

        public boolean isFirst(Item item) {
            return item == this.getFirst();
        }

        public boolean isLast(Item item) {
            return item == this.getLast();
        }

        public boolean isMiddleIngredient(Item item) {
            return this.items.contains((Object)item) && !this.isFirst(item) && !this.isLast(item);
        }

        public Item getNextIngredient(Item lastIngredient) {
            int i = this.items.indexOf((Object)lastIngredient) + 1;
            if (!this.isLast(lastIngredient) && i < this.items.size()) {
                return (Item)this.items.get(i);
            }
            return null;
        }
    }

    public static class RecipeItemData {
        private final Map<String, Boolean> data = new LinkedHashMap<String, Boolean>();

        public RecipeItemData(HOFRecipe recipe) {
            recipe.items.forEach(item -> this.data.put(Registries.get((String)"whisperwoods").get(Registry.field_239714_o_).getId(item).toString(), false));
        }

        public RecipeItemData(HOFRecipe recipe, Set<String> items) {
            recipe.items.forEach(item -> {
                String key = Registries.get((String)"whisperwoods").get(Registry.field_239714_o_).getId(item).toString();
                this.data.put(key, items.contains(key));
            });
        }

        public String getNextNonContainedItem() {
            for (String key : this.data.keySet()) {
                if (this.data.get(key).booleanValue()) continue;
                return key;
            }
            return null;
        }

        public boolean addItem(Item item) {
            String key = Registries.get((String)"whisperwoods").get(Registry.field_239714_o_).getId((Object)item).toString();
            if (this.data.containsKey(key)) {
                this.data.put(key, true);
                return true;
            }
            return false;
        }

        public boolean hasItem(Item item) {
            return this.data.getOrDefault(Registries.get((String)"whisperwoods").get(Registry.field_239714_o_).getId((Object)item).toString(), false);
        }

        public void read(BlockState state, CompoundNBT nbt) {
            if (nbt.func_74764_b("items")) {
                nbt.func_150295_c("items", 8).forEach(i -> this.data.put(i.func_150285_a_(), true));
            } else {
                this.data.keySet().forEach(i -> this.data.put((String)i, false));
            }
        }

        public CompoundNBT write(CompoundNBT compound) {
            ListNBT list = new ListNBT();
            this.data.forEach((i, v) -> {
                if (v.booleanValue()) {
                    list.add((Object)StringNBT.func_229705_a_((String)i));
                }
            });
            compound.func_218657_a("items", (INBT)list);
            return compound;
        }

        public Map<String, Boolean> getItemData() {
            return this.data;
        }
    }
}

