/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.entity;

import dev.itsmeow.whisperwoods.entity.EntityCreatureWithSelectiveTypes;
import dev.itsmeow.whisperwoods.entity.EntityCreatureWithTypes;
import dev.itsmeow.whisperwoods.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.whisperwoods.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.whisperwoods.imdlib.entity.util.variant.EntityVariant;
import dev.itsmeow.whisperwoods.init.ModEntities;
import dev.itsmeow.whisperwoods.init.ModSounds;
import dev.itsmeow.whisperwoods.util.IOverrideCollisions;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.utils.Env;
import net.minecraft.block.BlockState;
import net.minecraft.block.TorchBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;

public class EntityHidebehind
extends EntityCreatureWithSelectiveTypes
implements IOverrideCollisions<EntityCreatureWithTypes> {
    public final DamageSource HIDEBEHIND = new EntityDamageSource("hidebehind", (Entity)this).func_151518_m().func_76348_h();
    protected static final DataParameter<Integer> HIDING = EntityDataManager.func_187226_a(EntityHidebehind.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> OPEN = EntityDataManager.func_187226_a(EntityHidebehind.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> ATTACK_SEQUENCE_TICKS = EntityDataManager.func_187226_a(EntityHidebehind.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Optional<UUID>> TARGET_UUID = EntityDataManager.func_187226_a(EntityHidebehind.class, (IDataSerializer)DataSerializers.field_187203_m);

    public EntityHidebehind(EntityType<? extends EntityHidebehind> type, World world) {
        super((EntityType<? extends EntityCreatureWithSelectiveTypes>)type, world);
        this.field_70138_W = 2.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new HideFromTargetGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new StalkTargetGoal(this, 0.5, 35.0f));
        this.field_70715_bh.func_75776_a(0, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 0, false, false, this::isEntityAttackable));
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSounds.HIDEBEHIND_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return (SoundEvent)ModSounds.HIDEBEHIND_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSounds.HIDEBEHIND_DEATH.get();
    }

    public boolean hasTargetUUID() {
        return ((Optional)this.func_184212_Q().func_187225_a(TARGET_UUID)).isPresent();
    }

    public boolean isSequenceTarget(PlayerEntity player) {
        Optional opt = (Optional)this.func_184212_Q().func_187225_a(TARGET_UUID);
        return player != null && player.func_146103_bH().getId() != null && opt.isPresent() && player.func_146103_bH().getId().equals(opt.get());
    }

    public void setSequenceTarget(PlayerEntity player) {
        this.func_184212_Q().func_187227_b(TARGET_UUID, player == null || player.func_146103_bH().getId() == null ? Optional.empty() : Optional.of(player.func_146103_bH().getId()));
    }

    public int attackSequenceTicks() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_SEQUENCE_TICKS);
    }

    public void attackSequenceTicksDecrement() {
        this.field_70180_af.func_187227_b(ATTACK_SEQUENCE_TICKS, (Object)(this.attackSequenceTicks() - 1));
    }

    public void setAttackSequenceTicks(int value) {
        this.field_70180_af.func_187227_b(ATTACK_SEQUENCE_TICKS, (Object)value);
        if (value == 0) {
            this.setSequenceTarget(null);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() == this.func_70638_az() && this.attackSequenceTicks() > 0) {
            this.setAttackSequenceTicks(0);
        }
        if (!this.field_70170_p.func_201670_d()) {
            PlayerEntity player;
            boolean isImmediate = source.func_76364_f() instanceof PlayerEntity;
            Object object = isImmediate ? (PlayerEntity)source.func_76364_f() : (player = source.func_76346_g() instanceof PlayerEntity ? (PlayerEntity)source.func_76346_g() : null);
            if (player != null) {
                int hiding = this.getHidingInt();
                boolean attackable = this.isEntityAttackable((LivingEntity)player);
                if (!attackable || hiding > 0) {
                    if (!player.func_184812_l_()) {
                        player.func_195064_c(new EffectInstance(Effects.field_76440_q, 15 * (hiding == 1 ? 5 : 20), 0));
                        if (player.func_70032_d((Entity)this) < 3.0f) {
                            player.func_70097_a(this.HIDEBEHIND, 1.0f);
                        }
                    }
                    HideFromTargetGoal.doTreeTick(this);
                    return super.func_70097_a(source, amount * (hiding == 1 ? 0.5f : 0.25f));
                }
            }
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
            this.func_70624_b(null);
        }
        if (this.func_70090_H()) {
            int i = 12;
            int j = 2;
            BlockPos.Mutable bp = new BlockPos.Mutable();
            BlockPos destinationBlock = null;
            int k = 0;
            while (k <= j) {
                for (int l = 0; l < i; ++l) {
                    int i1 = 0;
                    while (i1 <= l) {
                        int j1;
                        int n = j1 = i1 < l && i1 > -l ? l : 0;
                        while (j1 <= l) {
                            bp.func_189533_g((Vector3i)this.func_233580_cy_()).func_196234_d(i1, k - 1, j1);
                            if (this.field_70170_p.func_180495_p((BlockPos)bp).func_177230_c().func_203417_a((ITag)BlockTags.field_200031_h)) {
                                destinationBlock = bp.func_185334_h();
                            }
                            j1 = j1 > 0 ? -j1 : 1 - j1;
                        }
                        i1 = i1 > 0 ? -i1 : 1 - i1;
                    }
                }
                k = k > 0 ? -k : 1 - k;
            }
            boolean fixed = false;
            if (destinationBlock != null) {
                for (Direction dir : Direction.values()) {
                    if (fixed || !this.field_70170_p.func_175623_d(destinationBlock.func_177972_a(dir)) && !this.field_70170_p.func_180495_p(destinationBlock.func_177972_a(dir)).func_177230_c().func_203417_a((ITag)BlockTags.field_206952_E)) continue;
                    destinationBlock = destinationBlock.func_177972_a(dir);
                    fixed = true;
                }
            }
            if (fixed) {
                this.func_70634_a(destinationBlock.func_177958_n(), destinationBlock.func_177956_o(), destinationBlock.func_177952_p());
            }
        }
        if (!this.field_70170_p.func_201670_d()) {
            if (this.field_70170_p.func_72935_r() && this.field_70170_p.func_226658_a_(LightType.SKY, this.func_233580_cy_()) > 10) {
                this.setHiding(2);
            } else if (this.getHidingInt() == 2) {
                this.setHiding(1);
            }
            if (!this.isBeingViewed() && this.getHidingInt() == 1) {
                this.setHiding(false);
            }
        }
        float atkTicks = this.attackSequenceTicks();
        if (this.func_70638_az() != null && this.func_70638_az().func_70068_e((Entity)this) < 5.0 && atkTicks == 0.0f && !this.getHiding() && this.isEntityAttackable(this.func_70638_az()) && this.func_70638_az() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)this.func_70638_az();
            if (!this.field_70170_p.field_72995_K && this.func_70681_au().nextInt(20) == 0) {
                if ((double)player.func_110143_aJ() > this.func_110148_a(Attributes.field_233823_f_).func_111126_e()) {
                    this.func_70652_k((Entity)player);
                } else {
                    this.setAttackSequenceTicks(40);
                    this.setSequenceTarget(player);
                }
            }
        }
        if (atkTicks > 0.0f) {
            if (!this.getOpen()) {
                this.setOpen(true);
            }
            ServerPlayerEntity target = null;
            if (this.func_70638_az() instanceof ServerPlayerEntity) {
                target = (ServerPlayerEntity)this.func_70638_az();
            } else if (Platform.getEnvironment() == Env.CLIENT) {
                Supplier<Supplier> s = () -> ClientSafeLogic::getTargetClient;
                target = (PlayerEntity)s.get().get();
            }
            if (this.isSequenceTarget((PlayerEntity)target)) {
                target.func_213293_j(0.0, 0.0, 0.0);
                double d0 = this.func_226277_ct_() - target.func_226277_ct_();
                double d1 = this.func_226281_cx_() - target.func_226281_cx_();
                float angle = (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
                target.func_70080_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), angle, 0.0f);
                double e0 = target.func_226277_ct_() - this.func_226277_ct_();
                double e1 = target.func_226281_cx_() - this.func_226281_cx_();
                float angle1 = (float)(MathHelper.func_181159_b((double)e1, (double)e0) * 57.2957763671875) - 90.0f;
                this.func_70080_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), angle1, 0.0f);
                this.field_70177_z = angle1;
                if (this.attackSequenceTicks() == 40) {
                    target.func_184185_a((SoundEvent)ModSounds.HIDEBEHIND_SCARE.get(), 2.0f, 1.0f);
                }
                this.func_70671_ap().func_75651_a((Entity)target, 360.0f, 360.0f);
            }
            this.attackSequenceTicksDecrement();
            if (atkTicks - 1.0f == 0.0f && !this.field_70170_p.func_201670_d()) {
                this.setOpen(false);
                if (this.func_70638_az() != null) {
                    this.func_70652_k((Entity)target);
                    this.func_70624_b(null);
                    this.func_184212_Q().func_187227_b(TARGET_UUID, Optional.empty());
                }
            }
        }
        if (atkTicks == 0.0f && this.getOpen()) {
            this.setOpen(false);
        }
    }

    public boolean isEntityAttackable(LivingEntity target) {
        Item mainItem = target.func_184586_b(Hand.MAIN_HAND).func_77973_b();
        Item offItem = target.func_184586_b(Hand.OFF_HAND).func_77973_b();
        return !(this.field_70170_p.func_201696_r(target.func_233580_cy_()) >= 8 || mainItem instanceof BlockItem && ((BlockItem)mainItem).func_179223_d() instanceof TorchBlock || offItem instanceof BlockItem && ((BlockItem)offItem).func_179223_d() instanceof TorchBlock);
    }

    protected float func_189749_co() {
        return 1.0f;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean getHiding() {
        return this.getHidingInt() != 0;
    }

    public int getHidingInt() {
        return (Integer)this.func_184212_Q().func_187225_a(HIDING);
    }

    public void setHiding(boolean hiding) {
        this.func_184212_Q().func_187227_b(HIDING, (Object)(hiding ? 1 : 0));
    }

    public void setHiding(int hiding) {
        this.func_184212_Q().func_187227_b(HIDING, (Object)hiding);
    }

    public boolean getOpen() {
        return (Boolean)this.func_184212_Q().func_187225_a(OPEN);
    }

    public void setOpen(boolean open) {
        this.func_184212_Q().func_187227_b(OPEN, (Object)open);
    }

    public boolean isBeingViewed() {
        return Math.abs(this.getTargetViewingAngle()) <= 50.0;
    }

    public double getTargetViewingAngle() {
        LivingEntity target = this.func_70638_az();
        if (target == null) {
            return -1000.0;
        }
        return MathHelper.func_76138_g((double)(this.getRequiredViewingAngle() - (double)MathHelper.func_76142_g((float)this.func_70638_az().field_70177_z)));
    }

    public double getRequiredViewingAngle() {
        LivingEntity target = this.func_70638_az();
        if (target == null) {
            return -1000.0;
        }
        return MathHelper.func_76138_g((double)(90.0 + Math.toDegrees(Math.atan2(target.func_226281_cx_() - this.func_226281_cx_(), target.func_226277_ct_() - this.func_226277_ct_()))));
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag;
        int i;
        float f = (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e();
        float f1 = (float)this.func_110148_a(Attributes.field_233824_g_).func_111126_e();
        if (entity instanceof LivingEntity) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)entity).func_70668_bt());
            f1 += (float)EnchantmentHelper.func_77501_a((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.func_90036_a((LivingEntity)this)) > 0) {
            entity.func_70015_d(i * 4);
        }
        if (flag = entity.func_70097_a(this.HIDEBEHIND, f)) {
            if (f1 > 0.0f && entity instanceof LivingEntity) {
                ((LivingEntity)entity).func_233627_a_(f1 * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            this.func_174815_a((LivingEntity)this, entity);
            this.func_130011_c(entity);
        }
        return flag;
    }

    public boolean func_70094_T() {
        return this.insideOpaque();
    }

    @Override
    public boolean canPassThrough(BlockState state) {
        return state.func_177230_c().func_203417_a((ITag)BlockTags.field_206952_E);
    }

    @Override
    public boolean preventSuffocation(BlockState state) {
        return state.func_177230_c().func_203417_a((ITag)BlockTags.field_200031_h) || this.canPassThrough(state);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HIDING, (Object)0);
        this.field_70180_af.func_187214_a(OPEN, (Object)false);
        this.field_70180_af.func_187214_a(ATTACK_SEQUENCE_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(TARGET_UUID, Optional.empty());
    }

    @Override
    public boolean func_213397_c(double range) {
        return this.field_70170_p.func_72935_r() && super.func_213397_c(range);
    }

    protected PathNavigator func_175447_b(World world) {
        return new HidebehindGroundNavigator((MobEntity)this, world);
    }

    @Override
    public EntityTypeContainer<EntityHidebehind> getContainer() {
        return ModEntities.HIDEBEHIND;
    }

    @Override
    public String[] getTypesFor(RegistryKey<Biome> biomeKey, Biome biome, Set<BiomeTypes.Type> types, SpawnReason reason) {
        if (biomeKey == Biomes.field_185432_ad || biomeKey == Biomes.field_185433_ae || biomeKey == Biomes.field_150578_U || biomeKey == Biomes.field_150581_V) {
            return new String[]{"mega_taiga", "mega_taiga", "mega_taiga", "darkforest"};
        }
        if (types.contains(BiomeTypes.CONIFEROUS)) {
            return new String[]{"coniferous", "coniferous", "coniferous", "coniferous", "black", "darkforest"};
        }
        if (types.contains(BiomeTypes.FOREST)) {
            return new String[]{"forest", "black", "darkforest"};
        }
        return new String[]{"black", "coniferous", "darkforest", "forest", "mega_taiga"};
    }

    public static class HideFromTargetGoal
    extends Goal {
        private final EntityHidebehind hidebehind;

        public HideFromTargetGoal(EntityHidebehind hb) {
            this.hidebehind = hb;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return this.hidebehind.func_70638_az() != null && (this.hidebehind.isBeingViewed() || !this.hidebehind.isEntityAttackable(this.hidebehind.func_70638_az())) && this.hidebehind.attackSequenceTicks() == 0;
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        public void func_75251_c() {
            if (this.hidebehind.getHidingInt() == 1) {
                this.hidebehind.setHiding(false);
            }
        }

        public void func_75249_e() {
            if (!this.hidebehind.getHiding()) {
                this.hidebehind.setHiding(true);
            }
            this.hidebehind.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            HideFromTargetGoal.doTreeTick(this.hidebehind);
        }

        public static void doTreeTick(EntityHidebehind hidebehind) {
            hidebehind.func_70661_as().func_75499_g();
            boolean nearTree = false;
            for (Direction dir : Direction.values()) {
                if (nearTree) continue;
                if (hidebehind.field_70170_p.func_180495_p(hidebehind.func_233580_cy_().func_177972_a(dir)).func_177230_c().func_203417_a((ITag)BlockTags.field_200031_h)) {
                    nearTree = true;
                }
                if (!hidebehind.field_70170_p.func_180495_p(hidebehind.func_233580_cy_().func_177981_b(3).func_177972_a(dir)).func_177230_c().func_203417_a((ITag)BlockTags.field_206952_E)) continue;
                nearTree = true;
            }
            if (!nearTree && hidebehind.func_70681_au().nextInt(5) == 0) {
                int i = 12;
                int j = 2;
                BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
                BlockPos destinationBlock = null;
                int k = 0;
                while (k <= j) {
                    for (int l = 0; l < i; ++l) {
                        int i1 = 0;
                        while (i1 <= l) {
                            int j1;
                            int n = j1 = i1 < l && i1 > -l ? l : 0;
                            while (j1 <= l) {
                                blockpos$mutableblockpos.func_189533_g((Vector3i)hidebehind.func_233580_cy_()).func_196234_d(i1, k - 1, j1);
                                if (hidebehind.field_70170_p.func_180495_p((BlockPos)blockpos$mutableblockpos).func_177230_c().func_203417_a((ITag)BlockTags.field_200031_h)) {
                                    destinationBlock = blockpos$mutableblockpos.func_185334_h();
                                }
                                j1 = j1 > 0 ? -j1 : 1 - j1;
                            }
                            i1 = i1 > 0 ? -i1 : 1 - i1;
                        }
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                boolean fixed = false;
                if (destinationBlock != null) {
                    for (Direction dir : Direction.values()) {
                        if (fixed || !hidebehind.field_70170_p.func_175623_d(destinationBlock.func_177972_a(dir)) && !hidebehind.field_70170_p.func_180495_p(destinationBlock.func_177972_a(dir)).func_177230_c().func_203417_a((ITag)BlockTags.field_206952_E)) continue;
                        destinationBlock = destinationBlock.func_177972_a(dir);
                        fixed = true;
                    }
                }
                if (fixed) {
                    hidebehind.func_70634_a(destinationBlock.func_177958_n(), destinationBlock.func_177956_o(), destinationBlock.func_177952_p());
                }
            }
        }
    }

    public static class StalkTargetGoal
    extends Goal {
        private final EntityHidebehind hidebehind;
        private LivingEntity target;
        private final double speed;
        private final float maxTargetDistance;

        public StalkTargetGoal(EntityHidebehind creature, double speedIn, float targetMaxDistance) {
            this.hidebehind = creature;
            this.speed = speedIn;
            this.maxTargetDistance = targetMaxDistance;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            this.target = this.hidebehind.func_70638_az();
            if (this.target == null || this.target.func_70068_e((Entity)this.hidebehind) > (double)(this.maxTargetDistance * this.maxTargetDistance)) {
                return false;
            }
            Vector3d vec3d = RandomPositionGenerator.func_75464_a((CreatureEntity)this.hidebehind, (int)16, (int)7, (Vector3d)new Vector3d(this.target.func_226277_ct_(), this.target.func_226278_cu_(), this.target.func_226281_cx_()));
            return vec3d != null && this.hidebehind.isEntityAttackable(this.target) && this.hidebehind.attackSequenceTicks() <= 0 && !this.hidebehind.getHiding();
        }

        public boolean func_75253_b() {
            return !this.hidebehind.getHiding() && !this.hidebehind.func_70661_as().func_75500_f() && this.target.func_70089_S() && this.target.func_70068_e((Entity)this.hidebehind) < (double)(this.maxTargetDistance * this.maxTargetDistance) && this.hidebehind.attackSequenceTicks() == 0 && this.hidebehind.isEntityAttackable(this.target);
        }

        public void func_75251_c() {
            this.target = null;
            this.hidebehind.func_70661_as().func_75499_g();
        }

        public void func_75249_e() {
            this.hidebehind.field_70749_g.func_75651_a((Entity)this.target, 1000.0f, 1000.0f);
            this.hidebehind.func_70661_as().func_75497_a((Entity)this.hidebehind.func_70638_az(), this.speed);
        }
    }

    public static class HidebehindGroundNavigator
    extends GroundPathNavigator {
        public HidebehindGroundNavigator(MobEntity entityliving, World world) {
            super(entityliving, world);
        }

        protected PathFinder func_179679_a(int i1) {
            this.field_179695_a = new HidebehindNodeProcessor();
            this.field_179695_a.func_186317_a(true);
            return new PathFinder(this.field_179695_a, i1);
        }

        public static class HidebehindNodeProcessor
        extends WalkNodeProcessor {
            protected PathNodeType func_215744_a(IBlockReader reader, boolean b1, boolean b2, BlockPos pos, PathNodeType typeIn) {
                return typeIn == PathNodeType.LEAVES ? PathNodeType.OPEN : super.func_215744_a(reader, b1, b2, pos, typeIn);
            }
        }
    }

    public static class HidebehindVariant
    extends EntityVariant {
        private final ResourceLocation openTexture;

        public HidebehindVariant(String nameTexture) {
            super("whisperwoods", nameTexture, "hidebehind_" + nameTexture);
            this.openTexture = new ResourceLocation("whisperwoods", "textures/entity/hidebehind_" + nameTexture + "_open.png");
        }

        @Override
        public ResourceLocation getTexture(Entity entity) {
            if (entity instanceof EntityHidebehind) {
                return ((EntityHidebehind)entity).getOpen() ? this.openTexture : this.texture;
            }
            return this.texture;
        }
    }

    public static class ClientSafeLogic {
        public static PlayerEntity getTargetClient() {
            return Minecraft.func_71410_x().field_71439_g;
        }
    }
}

