/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.entity;

import dev.itsmeow.whisperwoods.entity.EntityWisp;
import dev.itsmeow.whisperwoods.entity.projectile.EntityHirschgeistFireball;
import dev.itsmeow.whisperwoods.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.whisperwoods.init.ModEntities;
import dev.itsmeow.whisperwoods.init.ModSounds;
import dev.itsmeow.whisperwoods.util.IOverrideCollisions;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityHirschgeist
extends MonsterEntity
implements IMob,
IOverrideCollisions<EntityHirschgeist> {
    protected int flameIndex = 0;
    public static final DataParameter<Float> DISTANCE_TO_TARGET = EntityDataManager.func_187226_a(EntityHirschgeist.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Boolean> DAYTIME = EntityDataManager.func_187226_a(EntityHirschgeist.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS).func_186741_a(false);
    private boolean wasSummoned = false;

    public EntityHirschgeist(EntityType<? extends EntityHirschgeist> entityType, World worldIn) {
        super(entityType, worldIn);
        this.field_70728_aV = 150;
        this.field_70138_W = 1.5f;
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.7, true){

            public boolean func_75250_a() {
                return !EntityHirschgeist.this.isDaytime() && super.func_75250_a();
            }

            public boolean func_75253_b() {
                return !EntityHirschgeist.this.isDaytime() && super.func_75253_b();
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new FlameAttackGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new SummonWispsGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 20.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        if (reason == SpawnReason.EVENT || reason == SpawnReason.MOB_SUMMONED) {
            this.setWasSummoned();
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new GroundPathNavigator((MobEntity)this, worldIn){

            protected PathFinder func_179679_a(int i1) {
                this.field_179695_a = new WalkNodeProcessor(){

                    protected PathNodeType func_215744_a(IBlockReader reader, boolean b1, boolean b2, BlockPos pos, PathNodeType typeIn) {
                        return typeIn == PathNodeType.LEAVES || reader.func_180495_p(pos).func_177230_c().func_203417_a((ITag)BlockTags.field_200031_h) || reader.func_180495_p(pos).func_177230_c().func_203417_a((ITag)BlockTags.field_206952_E) ? PathNodeType.OPEN : super.func_215744_a(reader, b1, b2, pos, typeIn);
                    }
                };
                this.field_179695_a.func_186317_a(true);
                return new PathFinder(this.field_179695_a, i1);
            }
        };
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DISTANCE_TO_TARGET, (Object)Float.valueOf(-1.0f));
        this.func_184212_Q().func_187214_a(DAYTIME, (Object)true);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
        if (compound.func_74767_n("summoned")) {
            this.setWasSummoned();
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("summoned", this.wasSummoned());
    }

    public void func_200203_b(ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public float getTargetDistance() {
        return ((Float)this.func_184212_Q().func_187225_a(DISTANCE_TO_TARGET)).floatValue();
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).func_233627_a_(2.0f, this.func_226277_ct_() - entityIn.func_226277_ct_(), this.func_226281_cx_() - entityIn.func_226281_cx_());
                entityIn.func_70015_d(2 + this.func_70681_au().nextInt(2));
                if (this.field_70170_p instanceof ServerWorld) {
                    ServerWorld serverLevel = (ServerWorld)this.field_70170_p;
                    serverLevel.func_195598_a((IParticleData)ParticleTypes.field_239811_B_, this.func_213303_ch().func_82615_a() + (entityIn.func_213303_ch().func_82615_a() - this.func_213303_ch().func_82615_a()) / 2.0, this.func_213303_ch().func_82617_b() + (entityIn.func_213303_ch().func_82617_b() - this.func_213303_ch().func_82617_b()) / 2.0, this.func_213303_ch().func_82616_c() + (entityIn.func_213303_ch().func_82616_c() - this.func_213303_ch().func_82616_c()) / 2.0, 500, Math.abs((entityIn.func_213303_ch().func_82615_a() - this.func_213303_ch().func_82615_a()) / 25.0), 0.0, Math.abs((entityIn.func_213303_ch().func_82616_c() - this.func_213303_ch().func_82616_c()) / 25.0), 0.1);
                }
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getFlameAnimationIndex() {
        return this.flameIndex;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa % 2 == 0) {
            this.flameIndex = this.flameIndex >= 7 ? 0 : ++this.flameIndex;
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (!this.field_70170_p.field_72995_K) {
            this.func_184212_Q().func_187227_b(DISTANCE_TO_TARGET, (Object)Float.valueOf(this.func_70638_az() == null ? -1.0f : this.func_70638_az().func_70032_d((Entity)this)));
            this.func_184212_Q().func_187227_b(DAYTIME, (Object)this.isDaytime());
        }
    }

    public boolean isDaytime() {
        return this.field_70170_p.func_72935_r();
    }

    public boolean isDaytimeClient() {
        return (Boolean)this.func_184212_Q().func_187225_a(DAYTIME);
    }

    public boolean func_190631_cK() {
        return !this.isDaytime();
    }

    public boolean func_190530_aW() {
        return this.isDaytime();
    }

    public boolean func_180431_b(DamageSource source) {
        return this.isDaytime() && source != DamageSource.field_76380_i && !source.func_180136_u() || source.func_76346_g() instanceof EntityHirschgeist || source == DamageSource.field_76376_m || source == DamageSource.field_76372_a || source == DamageSource.field_76370_b || source == DamageSource.field_76371_c;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && source.func_76346_g() instanceof PlayerEntity && !source.func_180136_u()) {
            if (this.isDaytime()) {
                PlayerEntity player = (PlayerEntity)source.func_76346_g();
                player.func_145747_a((ITextComponent)new TranslationTextComponent("entity.whisperwoods.hirschgeist.message.invulnerable"), Util.field_240973_b_);
                return false;
            }
            if (this.func_70681_au().nextInt(4) == 0) {
                this.field_70170_p.func_217384_a(null, source.func_76346_g(), SoundEvents.field_187633_N, SoundCategory.MASTER, 1.0f, 2.0f);
                return false;
            }
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70624_b(LivingEntity entityIn) {
        super.func_70624_b(this.isDaytime() ? null : entityIn);
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSounds.HIRSCHGEIST_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return (SoundEvent)ModSounds.HIRSCHGEIST_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSounds.HIRSCHGEIST_DEATH.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.5f, 0.6f);
    }

    public boolean func_70094_T() {
        return this.insideOpaque();
    }

    @Override
    public boolean canPassThrough(BlockState state) {
        return state.func_177230_c().func_203417_a((ITag)BlockTags.field_206952_E) || state.func_177230_c().func_203417_a((ITag)BlockTags.field_200031_h);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return this.despawn(distanceToClosestPlayer) && !this.wasSummoned();
    }

    public boolean wasSummoned() {
        return this.wasSummoned;
    }

    public void setWasSummoned() {
        this.wasSummoned = true;
    }

    @Override
    public EntityTypeContainer<EntityHirschgeist> getContainer() {
        return ModEntities.HIRSCHGEIST;
    }

    @Override
    public EntityHirschgeist getImplementation() {
        return this;
    }

    public static class FlameAttackGoal
    extends Goal {
        private final EntityHirschgeist attacker;

        public FlameAttackGoal(EntityHirschgeist creature) {
            this.attacker = creature;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return this.attacker.func_70638_az() != null && this.attacker.func_70681_au().nextInt(500) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            this.attacker.func_70625_a((Entity)this.attacker.func_70638_az(), 20.0f, 20.0f);
            LivingEntity target = this.attacker.func_70638_az();
            double d0 = target.func_226277_ct_() - this.attacker.func_226277_ct_();
            double d1 = target.func_226278_cu_() - this.attacker.func_226280_cw_() - 0.1;
            double d2 = target.func_226281_cx_() - this.attacker.func_226281_cx_();
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            EntityHirschgeistFireball ball = new EntityHirschgeistFireball((EntityType<? extends EntityHirschgeistFireball>)((EntityType)ModEntities.PROJECTILE_HIRSCHGEIST_FIREBALL.get()), this.attacker.field_70170_p, (LivingEntity)this.attacker);
            ball.func_70107_b(target.func_226277_ct_(), target.func_226280_cw_() - 0.1, target.func_226281_cx_());
            ball.func_70186_c(d0, d1 + d3 * 0.2, d2, 0.5f, 2.0f);
            this.attacker.field_70170_p.func_217384_a(null, (Entity)this.attacker, SoundEvents.field_191244_bn, SoundCategory.HOSTILE, 1.0f, 1.0f);
            this.attacker.field_70170_p.func_217376_c((Entity)ball);
        }
    }

    public static class SummonWispsGoal
    extends Goal {
        private final EntityHirschgeist parent;

        public SummonWispsGoal(EntityHirschgeist parent) {
            this.parent = parent;
        }

        public boolean func_75250_a() {
            return this.parent.func_70638_az() != null && this.parent.func_70681_au().nextInt(500) == 0 && this.parent.field_70170_p.func_175647_a(EntityWisp.class, this.parent.func_174813_aQ().func_186662_g(10.0), wisp -> wisp.isHirschgeistSummon()).size() == 0;
        }

        public void func_75249_e() {
            if (this.parent.field_70170_p instanceof ServerWorld) {
                this.parent.field_70170_p.func_217384_a(null, (Entity)this.parent, SoundEvents.field_191244_bn, SoundCategory.HOSTILE, 1.0f, 1.0f);
                for (int i = 0; i < 3; ++i) {
                    EntityWisp wisp = (EntityWisp)ModEntities.WISP.getEntityType().func_220349_b((ServerWorld)this.parent.field_70170_p, null, null, null, this.parent.func_233580_cy_().func_177963_a((double)(this.parent.func_70681_au().nextInt(8) - 4) + 0.5, (double)(this.parent.func_70681_au().nextInt(4) + 1) + 0.5, (double)(this.parent.func_70681_au().nextInt(8) - 4) + 0.5), SpawnReason.REINFORCEMENT, false, false);
                    wisp.setHirschgeistSummon(true);
                    if (this.parent.func_70638_az() != null) {
                        wisp.func_70624_b(this.parent.func_70638_az());
                    }
                    this.parent.field_70170_p.func_217376_c((Entity)wisp);
                }
            }
        }

        public boolean func_75253_b() {
            return false;
        }
    }
}

