/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.entity;

import dev.itsmeow.whisperwoods.entity.EntityMonsterWithTypes;
import dev.itsmeow.whisperwoods.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.whisperwoods.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.whisperwoods.init.ModEntities;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;

public class EntityZotzpyre
extends EntityMonsterWithTypes
implements IFlyingAnimal {
    private static final DataParameter<Boolean> HANGING = EntityDataManager.func_187226_a(EntityZotzpyre.class, (IDataSerializer)DataSerializers.field_187198_h);
    private FastFlyingMoveControl moveSwoop;
    private FlyingMovementController moveNormal;

    public EntityZotzpyre(EntityType<? extends EntityZotzpyre> entityType, World worldIn) {
        super(entityType, worldIn);
        this.func_189654_d(true);
        this.moveSwoop = new FastFlyingMoveControl((MobEntity)this);
        this.moveNormal = new FlyingMovementController((MobEntity)this, 20, false);
        this.field_70765_h = this.moveNormal;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new SwoopingAttackGoal<EntityZotzpyre>(this));
        this.field_70714_bg.func_75776_a(1, new HangFromCeilingGoal<EntityZotzpyre>(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomFlyingGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 0, false, false, e -> true));
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new FlyingPathNavigator((MobEntity)this, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(HANGING, (Object)false);
    }

    public boolean isHanging() {
        return (Boolean)this.func_184212_Q().func_187225_a(HANGING);
    }

    public void setHanging(boolean hanging) {
        this.func_184212_Q().func_187227_b(HANGING, (Object)hanging);
    }

    protected float func_70599_aP() {
        return 0.5f;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.05f;
    }

    public SoundEvent func_184639_G() {
        return SoundEvents.field_187740_w;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187743_y;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187742_x;
    }

    public static boolean canSpawn(EntityType<EntityZotzpyre> type, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        if (pos.func_177956_o() >= world.func_181545_F() && !BiomeTypes.getTypes((RegistryKey<Biome>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)((ServerWorld)world).func_73046_m().func_244267_aX().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)world.func_226691_t_(pos)))).contains(BiomeTypes.JUNGLE)) {
            return false;
        }
        return EntityZotzpyre.func_223324_d(type, (IWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)rand);
    }

    public boolean func_70652_k(Entity entityIn) {
        float f = (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e();
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f);
        if (flag) {
            if (entityIn instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entityIn;
                int slowTicks = 0;
                if (this.field_70170_p.func_175659_aa() == Difficulty.EASY) {
                    slowTicks = 200;
                } else if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                    slowTicks = 300;
                } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    slowTicks = 600;
                }
                if (slowTicks > 0) {
                    player.func_195064_c(new EffectInstance(Effects.field_76421_d, slowTicks, 1, false, false));
                }
            }
            this.func_130011_c(entityIn);
        }
        return flag;
    }

    public boolean func_241849_j(Entity entity) {
        return entity != this.func_70638_az() && super.func_241849_j(entity);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
    }

    public void func_213352_e(Vector3d vec3) {
        if (this.isHanging() || this.field_70765_h == this.moveSwoop) {
            if (this.func_70090_H()) {
                this.func_213309_a(0.02f, vec3);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                this.func_213317_d(this.func_213322_ci().func_186678_a((double)0.8f));
            } else if (this.func_180799_ab()) {
                this.func_213309_a(0.02f, vec3);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
            } else {
                float f = 0.91f;
                if (this.field_70122_E) {
                    f = this.field_70170_p.func_180495_p(new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() - 1.0, this.func_226281_cx_())).func_177230_c().func_208618_m() * 0.91f;
                }
                float g = 0.16277137f / (f * f * f);
                this.func_213309_a(this.field_70122_E ? 0.1f * g : 0.02f, vec3);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                this.func_213317_d(this.func_213322_ci().func_186678_a((double)f));
            }
            this.func_233629_a_((LivingEntity)this, false);
        } else {
            super.func_213352_e(vec3);
        }
    }

    public boolean func_70617_f_() {
        return !this.isHanging();
    }

    @Override
    public EntityTypeContainer<EntityZotzpyre> getContainer() {
        return ModEntities.ZOTZPYRE;
    }

    public static class FastFlyingMoveControl
    extends MovementController {
        private boolean cantReach = false;

        public FastFlyingMoveControl(MobEntity mob) {
            super(mob);
        }

        public void func_75642_a(double d, double e, double f, double g) {
            super.func_75642_a(d, e, f, g);
            this.cantReach = false;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                this.field_75648_a.func_189654_d(true);
                Vector3d diff = new Vector3d(this.field_75646_b - this.field_75648_a.func_226277_ct_(), this.field_75647_c - this.field_75648_a.func_226278_cu_(), this.field_75644_d - this.field_75648_a.func_226281_cx_());
                Vector3d diffNorm = diff.func_72432_b();
                if (this.canReach(diffNorm, MathHelper.func_76143_f((double)diff.func_72433_c()))) {
                    this.field_75648_a.func_213317_d(this.field_75648_a.func_213322_ci().func_178787_e(diffNorm.func_186678_a(0.1)));
                } else {
                    this.cantReach = true;
                    this.stop();
                }
                double yawAngle = Math.atan2(diff.func_82616_c(), diff.func_82615_a()) * 57.29577951308232 - 90.0;
                this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, (float)yawAngle, 35.0f);
                double pitchAngle = -Math.atan2(diff.func_82617_b(), Math.sqrt(diff.func_82615_a() * diff.func_82615_a() + diff.func_82616_c() * diff.func_82616_c())) * 57.29577951308232;
                this.field_75648_a.field_70125_A = this.func_75639_a(this.field_75648_a.field_70125_A, (float)pitchAngle, 35.0f);
            } else {
                this.field_75648_a.func_189654_d(false);
            }
        }

        public boolean cantReach() {
            return this.cantReach;
        }

        public void stop() {
            this.field_188491_h = MovementController.Action.WAIT;
        }

        private boolean canReach(Vector3d vec3, int i) {
            AxisAlignedBB box = this.field_75648_a.func_174813_aQ();
            for (int j = 1; j < i; ++j) {
                if (this.field_75648_a.field_70170_p.func_226666_b_((Entity)this.field_75648_a, box = box.func_191194_a(vec3)).allMatch(VoxelShape::func_197766_b)) continue;
                return false;
            }
            return true;
        }
    }

    public static class SwoopingAttackGoal<T extends CreatureEntity>
    extends Goal {
        protected MovementPhase phase;
        protected T parentEntity;
        private int phaseTicks;
        private Vector3d startPos;
        private Vector3d targetPosition;

        public SwoopingAttackGoal(T parentEntity) {
            this.parentEntity = parentEntity;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.phase = MovementPhase.SWOOP_TO;
            this.phaseTicks = 0;
            this.startPos = null;
            this.targetPosition = null;
        }

        public void func_75251_c() {
            this.phase = MovementPhase.SWOOP_TO;
            this.phaseTicks = 0;
            this.startPos = null;
            this.targetPosition = null;
            if (this.parentEntity.func_70605_aq() instanceof FastFlyingMoveControl) {
                ((FastFlyingMoveControl)this.parentEntity.func_70605_aq()).stop();
            }
            if (this.parentEntity instanceof EntityZotzpyre) {
                EntityZotzpyre zotzpyre = (EntityZotzpyre)this.parentEntity;
                zotzpyre.field_70765_h = (MovementController)zotzpyre.moveNormal;
            }
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null && this.parentEntity.func_213336_c(this.parentEntity.func_70638_az());
        }

        public void func_75249_e() {
            if (this.parentEntity instanceof EntityZotzpyre) {
                EntityZotzpyre zotzpyre = (EntityZotzpyre)this.parentEntity;
                zotzpyre.field_70765_h = zotzpyre.moveSwoop;
            }
            this.startPos = this.parentEntity.func_213303_ch();
            this.phaseTicks = 0;
            LivingEntity target = this.parentEntity.func_70638_az();
            if ((double)this.parentEntity.func_70032_d((Entity)target) < 1.0) {
                this.phase = MovementPhase.HIT;
                this.startPos = null;
            }
            this.targetPosition = target.func_174824_e(1.0f);
        }

        private boolean isAtPosition() {
            return this.targetPosition != null ? this.parentEntity.func_213303_ch().func_72438_d(this.targetPosition) < 1.5 : false;
        }

        /*
         * Unable to fully structure code
         */
        public void func_75246_d() {
            block17: {
                block16: {
                    target = this.parentEntity.func_70638_az();
                    if (this.phase != MovementPhase.SWOOP_TO) break block16;
                    this.targetPosition = target.func_174824_e(1.0f);
                    if (this.targetPosition == null || this.isAtPosition()) ** GOTO lbl-1000
                    v0 = this.phaseTicks++;
                    if ((float)v0 > 20.0f && this.parentEntity.func_213322_ci().func_72433_c() < 0.01) {
                        this.parentEntity.func_70661_as().func_75492_a(this.targetPosition.func_82615_a(), this.targetPosition.func_82617_b(), this.targetPosition.func_82616_c(), 1.0);
                    } else lbl-1000:
                    // 2 sources

                    {
                        this.parentEntity.func_70661_as().func_75499_g();
                    }
                    this.parentEntity.func_70625_a((Entity)target, 30.0f, 30.0f);
                    if (this.isAtPosition()) {
                        this.phase = MovementPhase.HIT;
                        this.phaseTicks = 0;
                    }
                    break block17;
                }
                if (this.phase == MovementPhase.HIT) {
                    this.targetPosition = target.func_174824_e(1.0f);
                    this.parentEntity.func_70625_a((Entity)target, 30.0f, 30.0f);
                    if (this.parentEntity.field_70173_aa - this.parentEntity.func_142013_aG() > 40 && this.parentEntity.func_70652_k((Entity)target) || this.phaseTicks++ > 45) {
                        this.phaseTicks = 0;
                        this.phase = MovementPhase.SWOOP_AWAY;
                        this.targetPosition = null;
                    }
                } else if (this.phase == MovementPhase.SWOOP_AWAY) {
                    if (this.targetPosition != null) {
                        if (this.isAtPosition() || this.phaseTicks++ > 45 || this.parentEntity.func_70661_as().func_225466_a(this.targetPosition.func_82615_a(), this.targetPosition.func_82617_b(), this.targetPosition.func_82616_c(), 1) == null) {
                            this.phase = MovementPhase.SWOOP_TO;
                            this.phaseTicks = 0;
                            this.startPos = this.parentEntity.func_213303_ch();
                            this.targetPosition = null;
                        }
                    } else if (this.startPos != null) {
                        oScale = this.startPos.func_178788_d(target.func_213303_ch()).func_216372_d(-2.0, 1.0, -2.0);
                        if (oScale.func_72433_c() > 10.0) {
                            oScale = oScale.func_216372_d(0.5, 1.0, 0.5);
                        }
                        if (oScale.func_82617_b() > 5.0) {
                            oScale = oScale.func_178786_a(0.0, 2.5, 0.0);
                        }
                        this.targetPosition = opposite = target.func_213303_ch().func_178787_e(oScale);
                    } else {
                        this.targetPosition = newPos = RandomPositionGenerator.func_226338_a_(this.parentEntity, (int)10, (int)10, (int)10, null, (double)1.0);
                    }
                } else {
                    this.phase = MovementPhase.SWOOP_TO;
                    this.phaseTicks = 0;
                    this.startPos = null;
                    this.targetPosition = null;
                }
            }
            if (this.targetPosition != null && !this.isAtPosition()) {
                this.parentEntity.func_70605_aq().func_75642_a(this.targetPosition.func_82615_a(), this.targetPosition.func_82617_b(), this.targetPosition.func_82616_c(), 1.0);
            }
        }

        public static enum MovementPhase {
            SWOOP_TO,
            HIT,
            SWOOP_AWAY;

        }
    }

    public static class HangFromCeilingGoal<T extends MobEntity>
    extends Goal {
        protected T parentEntity;

        public HangFromCeilingGoal(T parentEntity) {
            this.parentEntity = parentEntity;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() == null && ((MobEntity)this.parentEntity).field_70170_p.func_180495_p(this.parentEntity.func_233580_cy_().func_177984_a()).func_224755_d((IBlockReader)((MobEntity)this.parentEntity).field_70170_p, this.parentEntity.func_233580_cy_().func_177984_a(), Direction.DOWN);
        }

        public void func_75246_d() {
            this.parentEntity.func_70661_as().func_75492_a(this.parentEntity.func_226277_ct_(), (double)this.parentEntity.func_233580_cy_().func_177956_o(), this.parentEntity.func_226281_cx_(), 1.0);
        }

        public void func_75249_e() {
            if (this.parentEntity instanceof EntityZotzpyre) {
                ((EntityZotzpyre)this.parentEntity).setHanging(true);
            }
        }

        public void func_75251_c() {
            ((EntityZotzpyre)this.parentEntity).setHanging(false);
        }
    }
}

