/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.itsmeow.whisperwoods.imdlib.entity.EntityRegistrarHandler;
import dev.itsmeow.whisperwoods.imdlib.forge.IMDLibImpl;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.registry.Registries;
import me.shedaniel.architectury.registry.Registry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.LazyValue;
import net.minecraft.util.RegistryKey;

public class IMDLib {
    private static LazyValue<Registries> REGISTRIES;
    private static MinecraftServer SERVER;

    public static Registries getRegistries() {
        if (REGISTRIES == null) {
            throw new RuntimeException("Registries have not been initialized yet! Call IMDLib.setRegistry(modid) or use IMDLib.entityHandler(modid)");
        }
        return (Registries)REGISTRIES.func_179281_c();
    }

    public static <T> Registry<T> getRegistry(RegistryKey<net.minecraft.util.registry.Registry<T>> key) {
        return IMDLib.getRegistries().get(key);
    }

    public static void setRegistry(String modid) {
        REGISTRIES = new LazyValue(() -> Registries.get((String)modid));
    }

    public static void setStaticServerInstance(MinecraftServer server) {
        SERVER = server;
    }

    public static MinecraftServer getStaticServerInstance() {
        if (SERVER == null) {
            MinecraftServer server;
            if (Platform.isForge() && (server = IMDLib.getForgeServer()) != null) {
                SERVER = server;
                return server;
            }
            throw new RuntimeException("Server not initialized yet! Call IMDLib.setStaticServerInstance(server) or use IMDLib.entityHandler(modid)");
        }
        return SERVER;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static MinecraftServer getForgeServer() {
        return IMDLibImpl.getForgeServer();
    }

    public static EntityRegistrarHandler entityHandler(String modid) {
        IMDLib.setRegistry(modid);
        return new EntityRegistrarHandler(modid);
    }
}

