/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.entity;

import dev.itsmeow.whisperwoods.imdlib.IMDLib;
import dev.itsmeow.whisperwoods.imdlib.blockentity.HeadBlockEntity;
import dev.itsmeow.whisperwoods.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.whisperwoods.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.whisperwoods.imdlib.entity.util.EntityTypeContainerContainable;
import dev.itsmeow.whisperwoods.imdlib.entity.util.builder.IEntityBuilder;
import dev.itsmeow.whisperwoods.imdlib.item.ItemModFishBucket;
import dev.itsmeow.whisperwoods.imdlib.item.ModSpawnEggItem;
import dev.itsmeow.whisperwoods.imdlib.mixin.EntityTypeAccessor;
import dev.itsmeow.whisperwoods.imdlib.mixin.SpawnSettingsAccessor;
import dev.itsmeow.whisperwoods.imdlib.util.HeadType;
import dev.itsmeow.whisperwoods.imdlib.util.config.CommonConfigAPI;
import dev.itsmeow.whisperwoods.imdlib.util.config.ConfigBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.architectury.event.events.LifecycleEvent;
import me.shedaniel.architectury.registry.entity.EntityAttributes;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;

public class EntityRegistrarHandler {
    public final String modid;
    public final LinkedHashMap<String, EntityTypeContainer<? extends MobEntity>> ENTITIES = new LinkedHashMap();

    public EntityRegistrarHandler(String modid) {
        this.modid = modid;
    }

    public void init() {
        LifecycleEvent.SERVER_BEFORE_START.register(state -> IMDLib.setStaticServerInstance(state));
        LifecycleEvent.SERVER_STOPPED.register(state -> IMDLib.setStaticServerInstance(null));
        BiomeTypes.init();
        for (HeadType headType : HeadType.values()) {
            headType.register(IMDLib.getRegistries());
        }
        me.shedaniel.architectury.registry.Registry items = IMDLib.getRegistry(Registry.field_239714_o_);
        for (EntityTypeContainer<? extends MobEntity> entityTypeContainer : this.ENTITIES.values()) {
            if (entityTypeContainer instanceof EntityTypeContainerContainable) {
                EntityTypeContainerContainable c = (EntityTypeContainerContainable)entityTypeContainer;
                if (!items.containsValue(c.getContainerItem())) {
                    items.register(new ResourceLocation(this.modid, c.getContainerItemName()), c::getContainerItem);
                }
                if (!items.containsValue((Object)c.getEmptyContainerItem())) {
                    items.register(new ResourceLocation(this.modid, c.getEmptyContainerItemName()), c::getEmptyContainerItem);
                }
            }
            if (!entityTypeContainer.hasEgg()) continue;
            entityTypeContainer.egg = items.registerSupplied(new ResourceLocation(entityTypeContainer.getModId(), entityTypeContainer.getEntityName().toLowerCase() + "_spawn_egg"), () -> new ModSpawnEggItem(container));
        }
        me.shedaniel.architectury.registry.Registry registry = IMDLib.getRegistry(Registry.field_239667_E_);
        registry.register(new ResourceLocation(this.modid, "head"), () -> HeadBlockEntity.HEAD_TYPE);
        me.shedaniel.architectury.registry.Registry registry2 = IMDLib.getRegistry(Registry.field_239713_n_);
        for (EntityTypeContainer<? extends MobEntity> container : this.ENTITIES.values()) {
            ResourceLocation rl = new ResourceLocation(this.modid, container.getEntityName());
            registry2.register(rl, container::getEntityType);
            EntityAttributes.register(container::getEntityType, container.getAttributeBuilder());
        }
        CommonConfigAPI.createServerConfig(builder -> {
            builder.push("entities");
            this.ENTITIES.values().forEach(c -> c.createConfiguration((ConfigBuilder)builder));
            builder.pop();
        }, server -> {
            this.ENTITIES.values().forEach(e -> e.getConfiguration().load());
            MutableRegistry biomeRegistry = server.func_244267_aX().func_243612_b(Registry.field_239720_u_);
            for (ResourceLocation key : biomeRegistry.func_148742_b()) {
                Biome biome = (Biome)biomeRegistry.func_82594_a(key);
                MobSpawnInfo spawnInfo = biome.func_242433_b();
                SpawnSettingsAccessor spawnInfoA = (SpawnSettingsAccessor)spawnInfo;
                spawnInfoA.setSpawners(new HashMap<EntityClassification, List<MobSpawnInfo.Spawners>>(spawnInfoA.getSpawners()));
                for (EntityClassification classification : EntityClassification.values()) {
                    ArrayList<MobSpawnInfo.Spawners> newList = new ArrayList<MobSpawnInfo.Spawners>();
                    List<MobSpawnInfo.Spawners> oldList = spawnInfoA.getSpawners().get(classification);
                    if (oldList != null) {
                        newList.addAll(oldList);
                    }
                    spawnInfoA.getSpawners().put(classification, newList);
                }
                spawnInfoA.setMobSpawnCosts(new HashMap(spawnInfoA.getMobSpawnCosts()));
                for (EntityTypeContainer entityTypeContainer : this.ENTITIES.values()) {
                    EntityTypeContainer.EntityConfiguration config = entityTypeContainer.getConfiguration();
                    if (!entityTypeContainer.getDefinition().hasSpawns() || !config.doSpawning.get().booleanValue() || config.spawnWeight.get() <= 0 || !entityTypeContainer.getBiomeIDs().contains(key.toString())) continue;
                    entityTypeContainer.registerPlacement();
                    List<MobSpawnInfo.Spawners> list = spawnInfoA.getSpawners().get(entityTypeContainer.getDefinition().getSpawnClassification());
                    if (list != null) {
                        list.add(entityTypeContainer.getSpawnEntry());
                    }
                    if (config.spawnCostPer.get() == 0.0 || config.spawnMaxCost.get() == 0.0 || !entityTypeContainer.getSpawnCostBiomeIDs().contains(key.toString())) continue;
                    MobSpawnInfo.SpawnCosts costs = ((SpawnSettingsAccessor)new MobSpawnInfo.Builder().func_242573_a(entityTypeContainer.getEntityType(), config.spawnCostPer.get().doubleValue(), config.spawnMaxCost.get().doubleValue()).func_242577_b()).getMobSpawnCosts().get(entityTypeContainer.getEntityType());
                    spawnInfoA.getMobSpawnCosts().put(entityTypeContainer.getEntityType(), costs);
                }
            }
        });
        CommonConfigAPI.createConfig(CommonConfigAPI.ConfigType.CLIENT, builder -> {
            builder.push("entities");
            this.ENTITIES.values().forEach(c -> c.clientCustomConfigurationInit((ConfigBuilder)builder));
            builder.pop();
        }, () -> this.ENTITIES.values().forEach(EntityTypeContainer::clientCustomConfigurationLoad));
    }

    public <T extends MobEntity> EntityTypeContainer<T> getEntityTypeContainer(String name) {
        return this.ENTITIES.get(name);
    }

    public <T extends MobEntity> EntityType<T> getEntityType(String name) {
        return this.ENTITIES.get(name).getEntityType();
    }

    public <T extends MobEntity> EntityTypeContainer<T> add(Class<T> entityClass, EntityType.IFactory<T> factory, String name, Supplier<AttributeModifierMap.MutableAttribute> attributeMap, Function<EntityTypeContainer.Builder<T>, EntityTypeContainer.Builder<T>> transformer) {
        return this.add((IEntityBuilder)transformer.apply(EntityTypeContainer.Builder.create(entityClass, factory, name, attributeMap, this.modid)));
    }

    public <T extends MobEntity, I extends Item> EntityTypeContainerContainable<T, I> addContainable(Class<T> entityClass, EntityType.IFactory<T> factory, String name, Supplier<AttributeModifierMap.MutableAttribute> attributeMap, Function<EntityTypeContainerContainable.Builder<T, I>, EntityTypeContainerContainable.Builder<T, I>> transformer) {
        return (EntityTypeContainerContainable)this.add((IEntityBuilder)transformer.apply(EntityTypeContainerContainable.Builder.create(entityClass, factory, name, attributeMap, this.modid)));
    }

    public <T extends MobEntity> EntityTypeContainerContainable<T, ItemModFishBucket<T>> addContainableB(Class<T> entityClass, EntityType.IFactory<T> factory, String name, Supplier<AttributeModifierMap.MutableAttribute> attributeMap, Function<EntityTypeContainerContainable.Builder<T, ItemModFishBucket<T>>, EntityTypeContainerContainable.Builder<T, ItemModFishBucket<T>>> transformer) {
        return (EntityTypeContainerContainable)this.add((IEntityBuilder)transformer.apply(EntityTypeContainerContainable.Builder.create(entityClass, factory, name, attributeMap, this.modid)));
    }

    public <T extends MobEntity, C extends EntityTypeContainer<T>> C add(IEntityBuilder<T, C, ?> builder) {
        C c = builder.build();
        ((EntityTypeContainer)c).entityType = this.createEntityType((EntityTypeContainer<T>)c);
        ((EntityTypeContainer)c).onCreateEntityType();
        this.ENTITIES.put(((EntityTypeContainer)c).getEntityName(), (EntityTypeContainer<? extends MobEntity>)c);
        return c;
    }

    public <T extends MobEntity> EntityType<T> createEntityType(EntityTypeContainer<T> container) {
        return this.createEntityType(container.getDefinition().getEntityFactory(), container.getEntityName(), container.getDefinition().getSpawnClassification(), 64, 1, true, container.getWidth(), container.getHeight());
    }

    public <T extends Entity> EntityType<T> createEntityType(EntityType.IFactory<T> factory, String entityNameIn, EntityClassification classification, int trackingRange, int updateInterval, boolean velUpdates, float width, float height) {
        EntityType type = EntityType.Builder.func_220322_a(factory, (EntityClassification)classification).func_233606_a_(trackingRange).func_233608_b_(updateInterval).func_220321_a(width, height).func_200706_c().func_206830_a(this.modid + ":" + entityNameIn.toLowerCase());
        ((EntityTypeAccessor)type).setSerialize(true);
        return type;
    }
}

