/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.entity.interfaces;

import dev.itsmeow.whisperwoods.imdlib.entity.interfaces.IVariantTypes;
import dev.itsmeow.whisperwoods.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.whisperwoods.imdlib.entity.util.variant.IVariant;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import org.jetbrains.annotations.Nullable;

public interface ISelectiveVariantTypes<T extends MobEntity>
extends IVariantTypes<T> {
    @Override
    @Nullable
    default public ILivingEntityData initData(IWorld world, SpawnReason reason, ILivingEntityData livingdata) {
        return this.useSelectiveTypes(reason) ? this.dataFromVariant(this.getRandomVariantForBiome(world, reason), livingdata) : IVariantTypes.super.initData(world, reason, livingdata);
    }

    @Override
    @Nullable
    default public ILivingEntityData initAgeableData(IWorld world, SpawnReason reason, ILivingEntityData livingdata) {
        return this.useSelectiveTypes(reason) ? this.ageableDataFromVariant(this.getRandomVariantForBiome(world, reason), livingdata) : IVariantTypes.super.initAgeableData(world, reason, livingdata);
    }

    public String[] getTypesFor(RegistryKey<Biome> var1, Biome var2, Set<BiomeTypes.Type> var3, SpawnReason var4);

    default public boolean useSelectiveTypes() {
        return this.getContainer().getConfiguration().biomeVariants.get();
    }

    default public boolean useSelectiveTypes(SpawnReason reason) {
        return this.useSelectiveTypes() && (reason == SpawnReason.CHUNK_GENERATION || reason == SpawnReason.NATURAL);
    }

    @Nullable
    default public IVariant getRandomVariantForBiome(IWorld world, SpawnReason reason) {
        Biome biome = world.func_226691_t_(this.getImplementation().func_233580_cy_());
        Optional biomeKey = world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_230519_c_((Object)biome);
        biomeKey.orElseThrow(() -> new RuntimeException("Biome provided to selective type generation has no ID found."));
        String[] validTypes = this.getTypesFor((RegistryKey<Biome>)((RegistryKey)biomeKey.get()), biome, BiomeTypes.getTypes((RegistryKey<Biome>)((RegistryKey)biomeKey.get())), reason);
        String varStr = validTypes[this.getImplementation().func_70681_au().nextInt(validTypes.length)];
        Optional<IVariant> variant = this.getContainer().getVariantForName(varStr);
        if (!variant.isPresent() || !varStr.equals(variant.get().getName())) {
            throw new RuntimeException("Received invalid variant \"" + varStr + "\" from selective type on entity " + this.getContainer().getEntityName());
        }
        return variant.get();
    }
}

