/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.util;

import dev.itsmeow.whisperwoods.imdlib.IMDLib;
import dev.itsmeow.whisperwoods.imdlib.entity.util.BiomeTypes;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;

public class BiomeListBuilder {
    private final Set<RegistryKey<Biome>> extras = new HashSet<RegistryKey<Biome>>();
    private final Set<BiomeTypes.Type> list = new HashSet<BiomeTypes.Type>();
    private final Set<BiomeTypes.Type> blacklist = new HashSet<BiomeTypes.Type>();
    private final Set<RegistryKey<Biome>> blacklistBiome = new HashSet<RegistryKey<Biome>>();
    private final Set<BiomeTypes.Type> required = new HashSet<BiomeTypes.Type>();
    private boolean onlyOverworld = false;

    private BiomeListBuilder() {
    }

    public static BiomeListBuilder create() {
        return new BiomeListBuilder();
    }

    @SafeVarargs
    public final BiomeListBuilder extra(RegistryKey<Biome> ... extraBiomes) {
        this.extras.addAll(Arrays.asList(extraBiomes));
        return this;
    }

    public BiomeListBuilder extra(BiomeTypes.Type ... types) {
        this.list.addAll(Arrays.asList(types));
        return this;
    }

    public BiomeListBuilder withoutTypes(BiomeTypes.Type ... types) {
        this.blacklist.addAll(Arrays.asList(types));
        return this;
    }

    public BiomeListBuilder withTypes(BiomeTypes.Type ... types) {
        this.required.addAll(Arrays.asList(types));
        return this;
    }

    @SafeVarargs
    public final BiomeListBuilder withoutBiomes(RegistryKey<Biome> ... biomes) {
        this.blacklistBiome.addAll(Arrays.asList(biomes));
        return this;
    }

    public BiomeListBuilder onlyOverworld() {
        this.onlyOverworld = true;
        return this;
    }

    public RegistryKey<Biome>[] collect() {
        HashSet<RegistryKey<Biome>> set = new HashSet<RegistryKey<Biome>>(this.extras);
        for (BiomeTypes.Type extraT : this.list) {
            set.addAll(BiomeTypes.getBiomes(extraT));
        }
        if (this.required.size() > 0 || this.blacklist.size() > 0) {
            MutableRegistry registry = null;
            try {
                registry = IMDLib.getStaticServerInstance().func_244267_aX().func_243612_b(Registry.field_239720_u_);
            }
            catch (RuntimeException e) {
                return new RegistryKey[0];
            }
            for (Biome biome : registry) {
                Optional biomeKeyOpt = registry.func_230519_c_((Object)biome);
                biomeKeyOpt.ifPresent(biomeKey -> {
                    Set<BiomeTypes.Type> types = BiomeTypes.getTypes((RegistryKey<Biome>)biomeKey);
                    if (types.size() > 0) {
                        boolean pass = true;
                        for (BiomeTypes.Type type : this.required) {
                            if (types.contains(type)) continue;
                            pass = false;
                            break;
                        }
                        for (BiomeTypes.Type type : this.blacklist) {
                            if (!types.contains(type)) continue;
                            pass = false;
                            break;
                        }
                        if (this.blacklistBiome.contains(biomeKey)) {
                            pass = false;
                        }
                        if (this.onlyOverworld && !types.contains(BiomeTypes.OVERWORLD)) {
                            pass = false;
                        }
                        if (pass) {
                            set.add((RegistryKey<Biome>)biomeKey);
                        }
                    }
                });
            }
        }
        return set.toArray(new RegistryKey[0]);
    }
}

