/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.network;

import dev.itsmeow.whisperwoods.particle.WispParticleData;
import java.util.function.Supplier;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.utils.Env;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.vector.Vector3d;

public class WispAttackPacket {
    public Vector3d fromPos;
    public int color;

    public WispAttackPacket(Vector3d fromPos, int color) {
        this.fromPos = fromPos;
        this.color = color;
    }

    public static void encode(WispAttackPacket pkt, PacketBuffer buf) {
        buf.writeDouble(pkt.fromPos.func_82615_a());
        buf.writeDouble(pkt.fromPos.func_82617_b());
        buf.writeDouble(pkt.fromPos.func_82616_c());
        buf.writeInt(pkt.color);
    }

    public static WispAttackPacket decode(PacketBuffer buf) {
        return new WispAttackPacket(new Vector3d(buf.readDouble(), buf.readDouble(), buf.readDouble()), buf.readInt());
    }

    public static void handle(WispAttackPacket msg, Supplier<NetworkManager.PacketContext> ctx) {
        if (ctx.get().getEnvironment() == Env.CLIENT) {
            ctx.get().queue(() -> {
                if (Minecraft.func_71410_x().field_71441_e != null && msg != null) {
                    Vector3d pos = msg.fromPos;
                    int color = msg.color;
                    float r = color >> 16 & 0xFF;
                    float g = color >> 8 & 0xFF;
                    float b = color & 0xFF;
                    ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                    if (player != null) {
                        Vector3d destPos = player.func_213303_ch().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
                        double stops = Math.round(3.0 * pos.func_72438_d(destPos));
                        double dirX = (destPos.func_82615_a() - pos.func_82615_a()) / stops;
                        double dirY = (destPos.func_82617_b() - pos.func_82617_b()) / stops;
                        double dirZ = (destPos.func_82616_c() - pos.func_82616_c()) / stops;
                        Vector3d dir = new Vector3d(dirX, dirY, dirZ);
                        for (double i = 1.0; i <= stops; i += 1.0) {
                            Vector3d posOff = dir.func_186678_a(i).func_178787_e(pos);
                            double sin = Math.sin(i / stops * (Math.PI * 2)) / 4.0;
                            double cos = Math.cos(i / stops * (Math.PI * 2)) / 4.0;
                            player.field_70170_p.func_195594_a((IParticleData)new WispParticleData(r, g, b, 0.5f), posOff.func_82615_a() + sin, posOff.func_82617_b() + sin, posOff.func_82616_c() - cos, 0.0, 0.0, 0.0);
                        }
                    }
                }
            });
        }
    }
}

