/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.blockentity;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import dev.architectury.extensions.BlockEntityExtension;
import dev.architectury.registry.registries.Registries;
import dev.itsmeow.whisperwoods.block.GhostLightBlock;
import dev.itsmeow.whisperwoods.block.HandOfFateBlock;
import dev.itsmeow.whisperwoods.entity.EntityWisp;
import dev.itsmeow.whisperwoods.init.ModBlockEntities;
import dev.itsmeow.whisperwoods.init.ModEntities;
import dev.itsmeow.whisperwoods.network.HOFEffectPacket;
import dev.itsmeow.whisperwoods.network.WWNetwork;
import dev.itsmeow.whisperwoods.util.TaskQueue;
import dev.itsmeow.whisperwoods.util.WispColors;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3965;

public class HandOfFateBlockEntity
extends class_2586
implements BlockEntityExtension {
    public static final ImmutableBiMap<String, HOFRecipe> RECIPES = ImmutableBiMap.of((Object)"hirschgeist", (Object)new HOFRecipe(class_124.field_1075, true, class_1802.field_8606, class_1802.field_8477, class_1802.field_8067), (Object)"wisp", (Object)new HOFRecipe(class_124.field_1065, false, class_1802.field_8183, class_1802.field_8601, class_1802.field_8067));
    private final CurrentRecipeContainer recipeContainer = new CurrentRecipeContainer();
    private class_1792 toDisplay = null;
    boolean displayDirty = true;
    public float lastAnimationY = 0.0f;

    public HandOfFateBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.HAND_OF_FATE.get(), pos, state);
    }

    public class_1792 getDisplayItem() {
        if (this.displayDirty) {
            this.toDisplay = this.getRecipeContainer().getDisplayItem();
            this.displayDirty = false;
        }
        return this.toDisplay;
    }

    public void method_5431() {
        super.method_5431();
        if (this.method_11002() && !this.field_11863.method_8608()) {
            this.syncData();
        }
    }

    public boolean isLit() {
        class_2248 b = this.method_11010().method_26204();
        if (b instanceof HandOfFateBlock && this.method_11002()) {
            HandOfFateBlock block = (HandOfFateBlock)b;
            return block.isLit(this.method_10997(), this.method_11016());
        }
        return false;
    }

    public boolean hasBlaze() {
        return this.recipeContainer.hasItemInRecipe(class_1802.field_8183);
    }

    public CurrentRecipeContainer getRecipeContainer() {
        return this.recipeContainer;
    }

    protected void playSound(class_3414 sound, float vol, float pitch) {
        if (this.method_11002()) {
            this.method_10997().method_8465(null, (double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260(), sound, class_3419.field_15245, vol, pitch);
        }
    }

    protected void sendToTrackers(HOFEffectPacket pkt) {
        if (this.method_11002()) {
            WWNetwork.HANDLER.sendToPlayers((Iterable)((class_3215)this.method_10997().method_8398()).field_17254.method_17210(new class_1923(this.field_11867), false).collect(Collectors.toSet()), (Object)pkt);
        }
    }

    public static <T extends HandOfFateBlockEntity> void serverTick(class_1937 level, class_2338 pos, class_2680 state, T blockEntity) {
        if (level.method_8510() % 5L == 0L) {
            List items = level.method_18467(class_1542.class, state.method_26222((class_1922)level, pos).method_1107().method_996(pos).method_1014(0.25));
            for (class_1542 item : items) {
                class_1799 stack;
                if (!item.method_5805() || (stack = item.method_6983()).method_7947() <= 0) continue;
                class_1269 r = blockEntity.reactToItem(stack, state, level, pos);
                if (r == class_1269.field_21466) {
                    item.method_6983().method_7934(1);
                    blockEntity.playSound(class_3417.field_19197, 1.0f, 1.0f);
                    blockEntity.displayDirty = true;
                    if (item.method_6983().method_7947() == 0) {
                        item.method_31472();
                    }
                    blockEntity.method_5431();
                    break;
                }
                if (!(stack.method_7909() instanceof class_1747) || !level.method_22347(pos.method_10084())) continue;
                class_1747 i = (class_1747)stack.method_7909();
                if (i.method_7711() instanceof GhostLightBlock) {
                    item.method_6983().method_7934(1);
                    blockEntity.playSound(class_3417.field_19197, 1.0f, 1.0f);
                    level.method_8501(pos.method_10084(), i.method_7711().method_9564());
                }
                if (item.method_6983().method_7947() != 0) break;
                item.method_31472();
                break;
            }
        }
    }

    public class_1269 onBlockActivated(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1269 r = this.reactToItem(player.method_5998(hand), state, worldIn, pos);
        if (r == class_1269.field_21466) {
            if (!player.method_7337()) {
                player.method_5998(hand).method_7934(1);
            }
            this.playSound(class_3417.field_19197, 1.0f, 1.0f);
            this.displayDirty = true;
            this.method_5431();
        }
        return r;
    }

    public class_1269 reactToItem(class_1799 stack, class_2680 state, class_1937 worldIn, class_2338 pos) {
        boolean lit;
        boolean bl = lit = this.isLit() || this.hasBlaze();
        if (lit || stack.method_7909() == class_1802.field_8183) {
            if (!this.getRecipeContainer().hasRecipe()) {
                for (HOFRecipe recipe : RECIPES.values()) {
                    if (!recipe.isFirst(stack.method_7909())) continue;
                    this.getRecipeContainer().setRecipe(recipe);
                    if (!this.getRecipeContainer().checkedAdd(stack.method_7909())) continue;
                    return class_1269.field_21466;
                }
            } else if (this.getRecipeContainer().checkedAdd(stack.method_7909())) {
                if (this.getRecipeContainer().isRecipeComplete()) {
                    this.onRecipeComplete(this.getRecipeContainer().getCurrentRecipe(), state, worldIn, pos);
                }
                return class_1269.field_21466;
            }
        }
        return class_1269.field_5811;
    }

    public void onRecipeComplete(HOFRecipe recipe, class_2680 state, class_1937 worldIn, class_2338 pos) {
        if (worldIn instanceof class_3218 && !worldIn.field_9236) {
            class_3218 world = (class_3218)worldIn;
            switch (recipe.getName()) {
                case "hirschgeist": {
                    HOFEffectPacket hgpk = new HOFEffectPacket(HOFEffectPacket.HOFEffectType.HIRSCHGEIST, new class_1160((float)pos.method_10263() + 0.5f, (float)pos.method_10264() + 1.0f, (float)pos.method_10260() + 0.5f), WispColors.BLUE.getColor());
                    this.sendToTrackers(hgpk);
                    this.playSound(class_3417.field_14858, 1.0f, 1.0f);
                    this.playSound(class_3417.field_19167, 1.0f, 1.0f);
                    TaskQueue.QUEUE_SERVER.schedule(50, () -> ModEntities.HIRSCHGEIST.getEntityType().method_5894((class_3218)worldIn, null, null, pos.method_10084(), class_3730.field_16467, false, false));
                    break;
                }
                case "wisp": {
                    EntityWisp wisp = (EntityWisp)ModEntities.WISP.getEntityType().method_5883((class_1937)world);
                    class_2248 above = world.method_8320(pos.method_10084()).method_26204();
                    WispColors.WispColor wColor = above instanceof GhostLightBlock ? WispColors.byColor(((GhostLightBlock)above).getColor()) : WispColors.values()[wisp.method_6051().nextInt(WispColors.values().length)];
                    wisp.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5);
                    double d0 = 1.0 + class_259.method_1085((class_2350.class_2351)class_2350.class_2351.field_11052, (class_238)wisp.method_5829(), (Stream)world.method_8600(null, new class_238(pos), e -> true), (double)-1.0);
                    wisp.method_5808((double)pos.method_10263() + 0.5, (double)pos.method_10264() + d0, (double)pos.method_10260() + 0.5, class_3532.method_15393((float)(world.field_9229.nextFloat() * 360.0f)), 0.0f);
                    wisp.field_6241 = wisp.method_36454();
                    wisp.field_6283 = wisp.method_36454();
                    wisp.isHostile = wisp.getNewHostileChance();
                    wisp.method_5841().method_12778(EntityWisp.COLOR_VARIANT, (Object)(wColor.ordinal() + 1));
                    worldIn.method_8649((class_1297)wisp);
                    int color = wisp.getWispColor().getColor();
                    HOFEffectPacket packet = new HOFEffectPacket(HOFEffectPacket.HOFEffectType.CIRCLE, new class_1160((float)pos.method_10263() + 0.5f, (float)pos.method_10264() + 1.0f, (float)pos.method_10260() + 0.5f), color);
                    this.sendToTrackers(packet);
                    if (wisp.isHostile) {
                        HOFEffectPacket packet2 = new HOFEffectPacket(HOFEffectPacket.HOFEffectType.CIRCLE, new class_1160((float)pos.method_10263() + 0.5f, (float)pos.method_10264() + 1.0f, (float)pos.method_10260() + 0.5f), 0xFF0000);
                        this.sendToTrackers(packet2);
                    }
                    this.playSound(wisp.isHostile ? class_3417.field_15203 : class_3417.field_14858, 1.0f, 1.0f);
                    break;
                }
            }
            this.method_5431();
        }
        this.getRecipeContainer().setRecipe(null);
    }

    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        this.getRecipeContainer().read(compoundTag);
        this.displayDirty = true;
    }

    public class_2487 method_11007(class_2487 compound) {
        class_2487 c = super.method_11007(compound);
        this.getRecipeContainer().write(compound);
        return c;
    }

    public void loadClientData(class_2680 pos, class_2487 tag) {
        this.method_11014(tag);
    }

    public class_2487 saveClientData(class_2487 tag) {
        return this.method_11007(tag);
    }

    public void dropItems(class_1937 worldIn, class_2338 pos) {
        if (worldIn != null && this.getRecipeContainer().hasRecipe() && this.getRecipeContainer().data != null) {
            this.getRecipeContainer().data.getItemData().forEach((i, v) -> {
                class_1792 toDrop;
                if (v.booleanValue() && (toDrop = (class_1792)Registries.get((String)"whisperwoods").get(class_2378.field_25108).get(new class_2960(i))) != null) {
                    class_1264.method_5449((class_1937)worldIn, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)new class_1799((class_1935)toDrop));
                }
            });
        }
    }

    public static class CurrentRecipeContainer {
        private HOFRecipe currentRecipe = null;
        private RecipeItemData data = null;

        public void setRecipe(HOFRecipe recipe) {
            this.currentRecipe = recipe;
            this.data = recipe != null ? new RecipeItemData(recipe) : null;
        }

        public boolean hasRecipe() {
            return this.currentRecipe != null;
        }

        public boolean hasItemInRecipe(class_1792 item) {
            return this.hasRecipe() && this.data != null && this.data.hasItem(item);
        }

        public boolean isRecipeComplete() {
            if (this.hasRecipe() && this.data != null) {
                boolean anyFalse = false;
                for (class_1792 item : this.getCurrentRecipe().items) {
                    if (this.data.hasItem(item)) continue;
                    anyFalse = true;
                }
                return !anyFalse;
            }
            return false;
        }

        public HOFRecipe getCurrentRecipe() {
            return this.currentRecipe;
        }

        public boolean canRecipeAccept(class_1792 item) {
            String next;
            if (this.hasRecipe() && this.data != null && (next = this.data.getNextNonContainedItem()) != null) {
                return next.equals(Registries.get((String)"whisperwoods").get(class_2378.field_25108).getId((Object)item).toString());
            }
            return false;
        }

        public boolean checkedAdd(class_1792 item) {
            return this.canRecipeAccept(item) && this.data.addItem(item);
        }

        public class_1792 getDisplayItem() {
            String itemName;
            if (this.hasRecipe() && this.data != null && (itemName = this.data.getNextNonContainedItem()) != null) {
                return (class_1792)Registries.get((String)"whisperwoods").get(class_2378.field_25108).get(new class_2960(itemName));
            }
            return null;
        }

        public void read(class_2487 nbt) {
            if (nbt.method_10545("recipe")) {
                this.setRecipe((HOFRecipe)RECIPES.getOrDefault((Object)nbt.method_10558("recipe"), null));
                if (this.data != null) {
                    this.data.read(nbt);
                }
            } else {
                this.setRecipe(null);
            }
        }

        public class_2487 write(class_2487 compound) {
            if (this.hasRecipe()) {
                compound.method_10582("recipe", this.getCurrentRecipe().getName());
                if (this.data != null) {
                    this.data.write(compound);
                }
            }
            return compound;
        }
    }

    public static class HOFRecipe {
        private final class_124 color;
        private final boolean bold;
        private String name = null;
        public final ImmutableList<class_1792> items;

        public HOFRecipe(class_124 color, boolean bold, class_1792 ... items) {
            if (items.length < 1) {
                throw new IllegalArgumentException("HOFRecipe constructor: \"items\" must have at least one item!");
            }
            this.color = color;
            this.bold = bold;
            this.items = ImmutableList.copyOf((Object[])items);
        }

        public class_124 getColor() {
            return this.color;
        }

        public boolean isBold() {
            return this.bold;
        }

        public String getName() {
            if (this.name == null) {
                this.name = (String)RECIPES.inverse().get((Object)this);
            }
            return this.name;
        }

        public class_1792 getFirst() {
            return (class_1792)this.items.get(0);
        }

        public class_1792 getLast() {
            return (class_1792)this.items.get(this.items.size() - 1);
        }

        public boolean isFirst(class_1792 item) {
            return item == this.getFirst();
        }

        public boolean isLast(class_1792 item) {
            return item == this.getLast();
        }

        public boolean isMiddleIngredient(class_1792 item) {
            return this.items.contains((Object)item) && !this.isFirst(item) && !this.isLast(item);
        }

        public class_1792 getNextIngredient(class_1792 lastIngredient) {
            int i = this.items.indexOf((Object)lastIngredient) + 1;
            if (!this.isLast(lastIngredient) && i < this.items.size()) {
                return (class_1792)this.items.get(i);
            }
            return null;
        }
    }

    public static class RecipeItemData {
        private final Map<String, Boolean> data = new LinkedHashMap<String, Boolean>();

        public RecipeItemData(HOFRecipe recipe) {
            recipe.items.forEach(item -> this.data.put(Registries.get((String)"whisperwoods").get(class_2378.field_25108).getId(item).toString(), false));
        }

        public RecipeItemData(HOFRecipe recipe, Set<String> items) {
            recipe.items.forEach(item -> {
                String key = Registries.get((String)"whisperwoods").get(class_2378.field_25108).getId(item).toString();
                this.data.put(key, items.contains(key));
            });
        }

        public String getNextNonContainedItem() {
            for (String key : this.data.keySet()) {
                if (this.data.get(key).booleanValue()) continue;
                return key;
            }
            return null;
        }

        public boolean addItem(class_1792 item) {
            String key = Registries.get((String)"whisperwoods").get(class_2378.field_25108).getId((Object)item).toString();
            if (this.data.containsKey(key)) {
                this.data.put(key, true);
                return true;
            }
            return false;
        }

        public boolean hasItem(class_1792 item) {
            return this.data.getOrDefault(Registries.get((String)"whisperwoods").get(class_2378.field_25108).getId((Object)item).toString(), false);
        }

        public void read(class_2487 nbt) {
            if (nbt.method_10545("items")) {
                nbt.method_10554("items", 8).forEach(i -> this.data.put(i.method_10714(), true));
            } else {
                this.data.keySet().forEach(i -> this.data.put((String)i, false));
            }
        }

        public class_2487 write(class_2487 compound) {
            class_2499 list = new class_2499();
            this.data.forEach((i, v) -> {
                if (v.booleanValue()) {
                    list.add((Object)class_2519.method_23256((String)i));
                }
            });
            compound.method_10566("items", (class_2520)list);
            return compound;
        }

        public Map<String, Boolean> getItemData() {
            return this.data;
        }
    }
}

