/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.entity;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.Registrar;
import dev.itsmeow.whisperwoods.imdlib.IMDLib;
import dev.itsmeow.whisperwoods.imdlib.blockentity.HeadBlockEntity;
import dev.itsmeow.whisperwoods.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.whisperwoods.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.whisperwoods.imdlib.entity.util.EntityTypeContainerContainable;
import dev.itsmeow.whisperwoods.imdlib.entity.util.builder.IEntityBuilder;
import dev.itsmeow.whisperwoods.imdlib.item.ItemModFishBucket;
import dev.itsmeow.whisperwoods.imdlib.item.ModSpawnEggItem;
import dev.itsmeow.whisperwoods.imdlib.mixin.SpawnSettingsAccessor;
import dev.itsmeow.whisperwoods.imdlib.util.HeadType;
import dev.itsmeow.whisperwoods.imdlib.util.config.CommonConfigAPI;
import dev.itsmeow.whisperwoods.imdlib.util.config.ConfigBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1792;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5132;
import net.minecraft.class_5483;
import net.minecraft.class_6012;

public class EntityRegistrarHandler {
    public final String modid;
    public final LinkedHashMap<String, EntityTypeContainer<? extends class_1308>> ENTITIES = new LinkedHashMap();

    public EntityRegistrarHandler(String modid) {
        this.modid = modid;
    }

    public void init() {
        LifecycleEvent.SERVER_BEFORE_START.register(state -> IMDLib.setStaticServerInstance(state));
        LifecycleEvent.SERVER_STOPPED.register(state -> IMDLib.setStaticServerInstance(null));
        BiomeTypes.init();
        for (HeadType headType : HeadType.values()) {
            headType.register(IMDLib.getRegistries().get());
        }
        Registrar items = IMDLib.getRegistry(class_2378.field_25108);
        for (EntityTypeContainer<? extends class_1308> entityTypeContainer : this.ENTITIES.values()) {
            if (entityTypeContainer instanceof EntityTypeContainerContainable) {
                EntityTypeContainerContainable c = (EntityTypeContainerContainable)entityTypeContainer;
                if (!items.containsValue(c.getContainerItem())) {
                    items.register(new class_2960(this.modid, c.getContainerItemName()), c::getContainerItem);
                }
                if (!items.containsValue((Object)c.getEmptyContainerItem())) {
                    items.register(new class_2960(this.modid, c.getEmptyContainerItemName()), c::getEmptyContainerItem);
                }
            }
            if (!entityTypeContainer.hasEgg()) continue;
            entityTypeContainer.egg = items.register(new class_2960(entityTypeContainer.getModId(), entityTypeContainer.getEntityName().toLowerCase() + "_spawn_egg"), () -> new ModSpawnEggItem(container));
        }
        Registrar registrar = IMDLib.getRegistry(class_2378.field_25073);
        registrar.register(new class_2960(this.modid, "head"), () -> HeadBlockEntity.HEAD_TYPE);
        Registrar registrar2 = IMDLib.getRegistry(class_2378.field_25107);
        for (EntityTypeContainer<? extends class_1308> container : this.ENTITIES.values()) {
            class_2960 rl = new class_2960(this.modid, container.getEntityName());
            registrar2.register(rl, container::getEntityType);
            EntityAttributeRegistry.register(container::getEntityType, container.getAttributeBuilder());
        }
        CommonConfigAPI.createServerConfig(builder -> {
            builder.push("entities");
            this.ENTITIES.values().forEach(c -> c.createConfiguration((ConfigBuilder)builder));
            builder.pop();
        }, server -> {
            this.ENTITIES.values().forEach(e -> e.getConfiguration().load());
            class_2378 biomeRegistrar = server.method_30611().method_30530(class_2378.field_25114);
            for (class_2960 key : biomeRegistrar.method_10235()) {
                class_1959 biome = (class_1959)biomeRegistrar.method_10223(key);
                class_5483 spawnInfo = biome.method_30966();
                SpawnSettingsAccessor spawnInfoA = (SpawnSettingsAccessor)spawnInfo;
                spawnInfoA.setSpawners(new HashMap<class_1311, List<class_5483.class_1964>>(spawnInfoA.getSpawners()));
                for (class_1311 category : class_1311.values()) {
                    if (!(spawnInfoA.getSpawners().get(category) instanceof List)) continue;
                    spawnInfoA.getSpawners().put(category, new ArrayList(spawnInfoA.getSpawners().get(category)));
                }
                spawnInfoA.setMobSpawnCosts(new HashMap(spawnInfoA.getMobSpawnCosts()));
                for (EntityTypeContainer entityTypeContainer : this.ENTITIES.values()) {
                    EntityTypeContainer.EntityConfiguration config = entityTypeContainer.getConfiguration();
                    if (!entityTypeContainer.getDefinition().hasSpawns() || !config.doSpawning.get().booleanValue() || config.spawnWeight.get() <= 0 || !entityTypeContainer.getBiomeIDs().contains(key.toString())) continue;
                    entityTypeContainer.registerPlacement();
                    List<class_5483.class_1964> list = spawnInfoA.getSpawners().get(entityTypeContainer.getDefinition().getSpawnClassification());
                    if (list != null) {
                        List<class_5483.class_1964> w$temp = list;
                        if (w$temp instanceof class_6012) {
                            class_6012 w = (class_6012)w$temp;
                            ArrayList<class_5483.class_1964> l = new ArrayList<class_5483.class_1964>(w.method_34994());
                            l.add(entityTypeContainer.getSpawnEntry());
                            spawnInfoA.getSpawners().put(entityTypeContainer.getDefinition().getSpawnClassification(), (List<class_5483.class_1964>)class_6012.method_34988(l));
                        } else {
                            List<class_5483.class_1964> l$temp = list;
                            if (l$temp instanceof ArrayList) {
                                ArrayList l = (ArrayList)l$temp;
                                l.add(entityTypeContainer.getSpawnEntry());
                            }
                        }
                    }
                    if (config.spawnCostPer.get() == 0.0 || config.spawnMaxCost.get() == 0.0 || !entityTypeContainer.getSpawnCostBiomeIDs().contains(key.toString())) continue;
                    class_5483.class_5265 costs = ((SpawnSettingsAccessor)new class_5483.class_5496().method_31009(entityTypeContainer.getEntityType(), config.spawnCostPer.get().doubleValue(), config.spawnMaxCost.get().doubleValue()).method_31007()).getMobSpawnCosts().get(entityTypeContainer.getEntityType());
                    spawnInfoA.getMobSpawnCosts().put(entityTypeContainer.getEntityType(), costs);
                }
            }
        });
        CommonConfigAPI.createConfig(CommonConfigAPI.ConfigType.CLIENT, builder -> {
            builder.push("entities");
            this.ENTITIES.values().forEach(c -> c.clientCustomConfigurationInit((ConfigBuilder)builder));
            builder.pop();
        }, () -> this.ENTITIES.values().forEach(EntityTypeContainer::clientCustomConfigurationLoad));
    }

    public <T extends class_1308> EntityTypeContainer<T> getEntityTypeContainer(String name) {
        return this.ENTITIES.get(name);
    }

    public <T extends class_1308> class_1299<T> getEntityType(String name) {
        return this.ENTITIES.get(name).getEntityType();
    }

    public <T extends class_1308> EntityTypeContainer<T> add(Class<T> entityClass, class_1299.class_4049<T> factory, String name, Supplier<class_5132.class_5133> attributeMap, Function<EntityTypeContainer.Builder<T>, EntityTypeContainer.Builder<T>> transformer) {
        return this.add((IEntityBuilder)transformer.apply(EntityTypeContainer.Builder.create(entityClass, factory, name, attributeMap, this.modid)));
    }

    public <T extends class_1308, I extends class_1792> EntityTypeContainerContainable<T, I> addContainable(Class<T> entityClass, class_1299.class_4049<T> factory, String name, Supplier<class_5132.class_5133> attributeMap, Function<EntityTypeContainerContainable.Builder<T, I>, EntityTypeContainerContainable.Builder<T, I>> transformer) {
        return (EntityTypeContainerContainable)this.add((IEntityBuilder)transformer.apply(EntityTypeContainerContainable.Builder.create(entityClass, factory, name, attributeMap, this.modid)));
    }

    public <T extends class_1308> EntityTypeContainerContainable<T, ItemModFishBucket<T>> addContainableB(Class<T> entityClass, class_1299.class_4049<T> factory, String name, Supplier<class_5132.class_5133> attributeMap, Function<EntityTypeContainerContainable.Builder<T, ItemModFishBucket<T>>, EntityTypeContainerContainable.Builder<T, ItemModFishBucket<T>>> transformer) {
        return (EntityTypeContainerContainable)this.add((IEntityBuilder)transformer.apply(EntityTypeContainerContainable.Builder.create(entityClass, factory, name, attributeMap, this.modid)));
    }

    public <T extends class_1308, C extends EntityTypeContainer<T>> C add(IEntityBuilder<T, C, ?> builder) {
        C c = builder.build();
        ((EntityTypeContainer)c).entityType = this.createEntityType((EntityTypeContainer<T>)c);
        ((EntityTypeContainer)c).onCreateEntityType();
        this.ENTITIES.put(((EntityTypeContainer)c).getEntityName(), (EntityTypeContainer<? extends class_1308>)c);
        return c;
    }

    public <T extends class_1308> class_1299<T> createEntityType(EntityTypeContainer<T> container) {
        return this.createEntityType(container.getDefinition().getEntityFactory(), container.getEntityName(), container.getDefinition().getSpawnClassification(), 64, 1, true, container.getWidth(), container.getHeight());
    }

    public <T extends class_1297> class_1299<T> createEntityType(class_1299.class_4049<T> factory, String entityNameIn, class_1311 classification, int trackingRange, int updateInterval, boolean velUpdates, float width, float height) {
        return class_1299.class_1300.method_5903(factory, (class_1311)classification).method_27299(trackingRange).method_27300(updateInterval).method_17687(width, height).method_5905(this.modid + ":" + entityNameIn.toLowerCase());
    }
}

