/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.block;

import dev.itsmeow.whisperwoods.blockentity.GhostLightBlockEntity;
import dev.itsmeow.whisperwoods.util.IHaveColor;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WispLanternBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock,
IHaveColor {
    private static VoxelShape[] SHAPES = new VoxelShape[Direction.values().length];
    public static final BooleanProperty WATERLOGGED;
    public static final DirectionProperty FACING;
    public static final DirectionProperty HORIZONTAL_FACING;
    private int color = 0;

    public WispLanternBlock(int color, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = color;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.DOWN)).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new GhostLightBlockEntity(pos, state);
    }

    @Override
    public int getColor() {
        return this.color;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext ctx) {
        return SHAPES[((Direction)state.m_61143_((Property)FACING)).ordinal()];
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
            if (!blockstate.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            if (direction.m_122434_() == Direction.Axis.Y) {
                blockstate = (BlockState)blockstate.m_61124_((Property)HORIZONTAL_FACING, (Comparable)context.m_43723_().m_6374_().m_122424_());
            }
            return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HORIZONTAL_FACING, WATERLOGGED});
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return Block.m_49863_((LevelReader)worldIn, (BlockPos)pos.m_142300_(direction), (Direction)direction.m_122424_());
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_6217_().m_5945_(currentPos, (Object)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return stateIn.m_61143_((Property)FACING) == facing && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    static {
        for (Direction facing : Direction.values()) {
            int x;
            double d = 0.25;
            if (facing == Direction.UP) {
                WispLanternBlock.SHAPES[facing.ordinal()] = Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)1.0, (double)0.75);
                continue;
            }
            if (facing == Direction.DOWN) {
                WispLanternBlock.SHAPES[facing.ordinal()] = Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.8125, (double)0.75);
                continue;
            }
            int n = facing == Direction.WEST ? 1 : (x = facing == Direction.EAST ? -1 : 0);
            int z = facing == Direction.NORTH ? 1 : (facing == Direction.SOUTH ? -1 : 0);
            WispLanternBlock.SHAPES[facing.ordinal()] = Shapes.m_83048_((double)(0.25 - 0.25 * (double)x), (double)0.0, (double)(0.25 - 0.25 * (double)z), (double)(0.75 - 0.25 * (double)x), (double)0.8125, (double)(0.75 - 0.25 * (double)z));
        }
        WATERLOGGED = BlockStateProperties.f_61362_;
        FACING = BlockStateProperties.f_61372_;
        HORIZONTAL_FACING = DirectionProperty.m_61546_((String)"horizontal", (Predicate)Direction.Plane.HORIZONTAL);
    }
}

