/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import dev.itsmeow.whisperwoods.entity.EntityHirschgeist;
import dev.itsmeow.whisperwoods.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.whisperwoods.imdlib.entity.interfaces.IContainerEntity;
import dev.itsmeow.whisperwoods.init.ModEntities;
import dev.itsmeow.whisperwoods.item.ItemBlockHirschgeistSkull;
import dev.itsmeow.whisperwoods.network.WWNetwork;
import dev.itsmeow.whisperwoods.network.WispAttackPacket;
import dev.itsmeow.whisperwoods.util.WispColors;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityWisp
extends Animal
implements IContainerEntity<EntityWisp> {
    public final DamageSource WISP = new EntityDamageSource("wisp", (Entity)this).m_19382_().m_19380_();
    public boolean isHostile = false;
    public long lastSpawn = 0L;
    private BlockPos targetPosition;
    public static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.m_135353_(EntityWisp.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> TARGET_ID = SynchedEntityData.m_135353_(EntityWisp.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TARGET_NAME = SynchedEntityData.m_135353_(EntityWisp.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Float> PASSIVE_SCALE = SynchedEntityData.m_135353_(EntityWisp.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> COLOR_VARIANT = SynchedEntityData.m_135353_(EntityWisp.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final TargetingConditions PASSIVE_SCALE_PREDICATE = TargetingConditions.m_148353_().m_26893_().m_148355_();
    private static final TargetingConditions HOSTILE_TARGET_PREDICATE = TargetingConditions.m_148352_().m_148355_().m_26888_(e -> !(e.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof ItemBlockHirschgeistSkull));
    protected ResourceLocation targetTexture;
    private boolean shouldBeHostile = false;
    private int attackCooldown = 0;
    private boolean isHirschgeistSummon = false;

    public EntityWisp(EntityType<? extends EntityWisp> entityType, Level world) {
        super(entityType, world);
    }

    public WispColors.WispColor getWispColor() {
        int c = (Integer)this.f_19804_.m_135370_(COLOR_VARIANT);
        if (c <= WispColors.values().length && c > 0) {
            return WispColors.values()[c - 1];
        }
        return WispColors.BLUE;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_STATE, (Object)0);
        this.f_19804_.m_135372_(TARGET_ID, (Object)"");
        this.f_19804_.m_135372_(TARGET_NAME, (Object)"");
        this.f_19804_.m_135372_(PASSIVE_SCALE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_VARIANT, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isHostile && this.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
            this.isHostile = false;
            this.shouldBeHostile = true;
        } else if (this.shouldBeHostile && this.f_19853_.m_46791_() != Difficulty.PEACEFUL) {
            this.isHostile = true;
            this.shouldBeHostile = false;
        }
        int state = (Integer)this.f_19804_.m_135370_(ATTACK_STATE);
        if (!this.hasSoul()) {
            this.m_20256_(this.m_20184_().m_82542_(0.5, 0.6, 0.5));
            this.f_19794_ = false;
        } else {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
            this.f_19794_ = true;
            this.f_19804_.m_135381_(ATTACK_STATE, (Object)(state + 1));
        }
        if (this.m_5448_() != null && !HOSTILE_TARGET_PREDICATE.m_26885_((LivingEntity)this, this.m_5448_())) {
            this.m_6710_(null);
        }
        if (!this.f_19853_.f_46443_ && this.isHirschgeistSummon() && this.m_5448_() != null) {
            double distance = this.m_20270_((Entity)this.m_5448_());
            if (this.attackCooldown <= 0) {
                if (distance < 10.0) {
                    WWNetwork.HANDLER.sendToPlayers((Iterable)((ChunkMap.TrackedEntity)((ServerChunkCache)this.f_19853_.m_7726_()).f_8325_.f_140150_.get((int)this.m_142049_())).f_140475_.stream().map(ServerPlayerConnection::m_142253_).collect(Collectors.toSet()), (Object)new WispAttackPacket(this.m_20182_().m_82520_(0.0, (double)this.m_20206_(), 0.0), this.getWispColor().getColor()));
                    this.m_5448_().m_6469_(DamageSource.f_19319_, 1.0f);
                    this.attackCooldown = 40 + this.m_21187_().nextInt(6);
                }
            } else {
                --this.attackCooldown;
            }
        }
        if (state == 400 && !this.f_19853_.f_46443_ && this.f_19853_.m_142572_() != null) {
            Player soul = null;
            if (this.m_5448_() instanceof Player) {
                soul = (Player)this.m_5448_();
            }
            if (soul == null) {
                soul = this.f_19853_.m_142572_().m_6846_().m_11259_(UUID.fromString((String)this.f_19804_.m_135370_(TARGET_ID)));
            }
            if (soul == null) {
                soul = this.f_19853_.m_142572_().m_6846_().m_11255_((String)this.f_19804_.m_135370_(TARGET_NAME));
            }
            this.resetAttackState();
            if (soul != null && HOSTILE_TARGET_PREDICATE.m_26885_((LivingEntity)this, (LivingEntity)soul)) {
                soul.m_6469_(this.WISP, 3000.0f);
            }
            this.targetPosition = null;
            this.m_6710_(null);
        }
        if (this.isPassive() && !this.f_19853_.f_46443_) {
            if (this.f_19853_.m_45976_(Player.class, this.m_142469_().m_82400_(10.0)).size() > 0) {
                Player nearest = (Player)this.f_19853_.m_45963_(Player.class, PASSIVE_SCALE_PREDICATE, null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_142469_().m_82400_(10.0));
                if (nearest != null) {
                    this.f_19804_.m_135381_(PASSIVE_SCALE, (Object)Float.valueOf(nearest.m_20270_((Entity)this) / 12.0f));
                } else {
                    this.f_19804_.m_135381_(PASSIVE_SCALE, (Object)Float.valueOf(0.3f));
                }
            } else {
                this.f_19804_.m_135381_(PASSIVE_SCALE, (Object)Float.valueOf(1.0f));
            }
        }
    }

    public boolean m_6673_(DamageSource source) {
        return super.m_6673_(source) || source.m_7639_() == this || source == DamageSource.f_19319_ || source == DamageSource.f_19305_ || source == DamageSource.f_19307_ || source.m_7639_() instanceof EntityHirschgeist;
    }

    public boolean isPassive() {
        return !this.isHostile && !this.isHirschgeistSummon();
    }

    public boolean isHirschgeistSummon() {
        return this.isHirschgeistSummon;
    }

    public void setHirschgeistSummon(boolean value) {
        this.isHirschgeistSummon = value;
        this.isHostile = false;
        this.shouldBeHostile = false;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.m_5448_() != null && this.m_5448_().m_20147_()) {
            this.m_6710_(null);
        }
        if (this.targetPosition != null && this.m_142538_().m_123331_((Vec3i)this.targetPosition) < 4.0 || this.targetPosition == null || !this.isHostile || !this.hasSoul() || this.isHirschgeistSummon()) {
            if (this.m_5448_() == null && !this.isPassive()) {
                this.m_6710_(this.f_19853_.m_45963_(Player.class, HOSTILE_TARGET_PREDICATE, null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_142469_().m_82400_(25.0)));
            }
            this.targetPosition = !this.isPassive() && this.m_5448_() != null ? this.m_5448_().m_142538_() : new BlockPos(this.m_20185_() + (double)this.f_19796_.nextInt(5) - (double)this.f_19796_.nextInt(5), this.m_20186_() + (double)this.f_19796_.nextInt(4) - 0.1, this.m_20189_() + (double)this.f_19796_.nextInt(5) - (double)this.f_19796_.nextInt(5));
            if (this.hasSoul() && this.isHostile) {
                this.targetPosition = new BlockPos(this.m_20185_() + (double)this.f_19796_.nextInt(60) - (double)this.f_19796_.nextInt(60), this.m_20186_() + (double)this.f_19796_.nextInt(4), this.m_20189_() + (double)this.f_19796_.nextInt(60) - (double)this.f_19796_.nextInt(60));
            }
        }
        if (this.targetPosition != null) {
            double d0 = (double)this.targetPosition.m_123341_() + 0.5 - this.m_20185_();
            double d1 = (double)this.targetPosition.m_123342_() + 0.1 - this.m_20186_();
            double d2 = (double)this.targetPosition.m_123343_() + 0.5 - this.m_20189_();
            Vec3 vec3d = this.m_20184_();
            Vec3 vec3d1 = vec3d.m_82520_((Math.signum(d0) * 0.5 - vec3d.f_82479_) * (double)0.1f, (Math.signum(d1) * (double)0.7f - vec3d.f_82480_) * (double)0.1f, (Math.signum(d2) * 0.5 - vec3d.f_82481_) * (double)0.1f);
            this.m_20256_(vec3d1);
            float f = (float)(Mth.m_14136_((double)vec3d1.f_82481_, (double)vec3d1.f_82479_) * 57.2957763671875) - 90.0f;
            float f1 = Mth.m_14177_((float)(f - this.m_146908_()));
            this.f_20902_ = 0.5f;
            this.m_146922_(this.m_146908_() + f1);
        }
    }

    public boolean hasSoul() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_STATE) > 0;
    }

    protected void resetAttackState() {
        this.f_19804_.m_135381_(ATTACK_STATE, (Object)0);
        this.f_19804_.m_135381_(TARGET_ID, (Object)"");
        this.f_19804_.m_135381_(TARGET_NAME, (Object)"");
        this.targetTexture = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTargetTexture() {
        if (this.targetTexture == null) {
            UUID target = UUID.fromString((String)this.m_20088_().m_135370_(TARGET_ID));
            String name = (String)this.m_20088_().m_135370_(TARGET_NAME);
            this.targetTexture = DefaultPlayerSkin.m_118627_((UUID)target);
            SkullBlockEntity.m_155738_((GameProfile)new GameProfile(target, name), newProfile -> {
                if (newProfile != null) {
                    ResourceLocation skin;
                    Map map = Minecraft.m_91087_().m_91109_().m_118815_(newProfile);
                    if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                        skin = Minecraft.m_91087_().m_91109_().m_118825_((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                    } else {
                        skin = DefaultPlayerSkin.m_118627_((UUID)target);
                        Minecraft.m_91087_().m_91109_().m_118817_(newProfile, null, false);
                    }
                    this.targetTexture = skin;
                }
            });
        }
        return this.targetTexture;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean m_6147_() {
        return false;
    }

    public boolean m_6090_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
    }

    protected void m_7324_(Entity entity) {
        if (entity == this.m_5448_() && this.m_5448_() != null && entity instanceof Player && HOSTILE_TARGET_PREDICATE.m_26885_((LivingEntity)this, (LivingEntity)((Player)entity)) && !this.hasSoul() && !this.isHirschgeistSummon()) {
            Player player = (Player)entity;
            this.f_19804_.m_135381_(ATTACK_STATE, (Object)1);
            this.f_19804_.m_135381_(TARGET_ID, (Object)player.m_36316_().getId().toString());
            this.f_19804_.m_135381_(TARGET_NAME, (Object)player.m_36316_().getName());
        }
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public boolean m_6785_(double range) {
        return this.getContainer().despawns() && !this.hasSoul();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("is_hostile", this.isHostile);
        compound.m_128405_("color_variant", ((Integer)this.f_19804_.m_135370_(COLOR_VARIANT)).intValue());
        compound.m_128379_("should_be_hostile", this.shouldBeHostile);
        compound.m_128379_("hirschgeist_summon", this.isHirschgeistSummon());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.isHostile = compound.m_128471_("is_hostile");
        this.f_19804_.m_135381_(COLOR_VARIANT, (Object)compound.m_128451_("color_variant"));
        this.shouldBeHostile = compound.m_128471_("should_be_hostile");
        this.setHirschgeistSummon(compound.m_128471_("hirschgeist_summon"));
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        if (!this.f_19853_.f_46443_ && !this.m_6162_() && (this.f_19796_.nextInt(10) == 0 || this.hasSoul() || this.isHirschgeistSummon())) {
            ItemStack stack = new ItemStack((ItemLike)EntityWisp.getItemForVariant((Integer)this.m_20088_().m_135370_(COLOR_VARIANT)));
            this.m_5552_(stack, 0.5f);
        }
    }

    private static Item getItemForVariant(int variant) {
        if (variant <= WispColors.values().length && variant > 0) {
            Block block = (Block)WispColors.values()[variant - 1].getGhostLight().get();
            return block.m_5456_();
        }
        return null;
    }

    public boolean getNewHostileChance() {
        return this.getContainer().getCustomConfiguration().getDouble("hostile_chance") / 100.0 > Math.random();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData livingdata, CompoundTag compound) {
        boolean hostile = this.getNewHostileChance();
        int colorVariant = this.m_21187_().nextInt(WispColors.values().length) + 1;
        if (livingdata instanceof WispData) {
            hostile = ((WispData)((Object)livingdata)).isHostile;
            colorVariant = ((WispData)((Object)livingdata)).colorVariant;
        } else {
            livingdata = new WispData(hostile, colorVariant);
        }
        this.isHostile = hostile;
        this.f_19804_.m_135381_(COLOR_VARIANT, (Object)colorVariant);
        return livingdata;
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        return null;
    }

    @Override
    public EntityWisp getImplementation() {
        return this;
    }

    @Override
    public EntityTypeContainer<EntityWisp> getContainer() {
        return ModEntities.WISP;
    }

    public static class WispData
    extends AgeableMob.AgeableMobGroupData {
        public boolean isHostile;
        public int colorVariant;

        public WispData(boolean isHostile, int colorVariant) {
            super(false);
            this.isHostile = isHostile;
            this.colorVariant = colorVariant;
        }
    }
}

